/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;

public class ConditionalBranchNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory {
    private LeftTupleSource tupleSource;
    private ConditionalBranchEvaluator branchEvaluator;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public ConditionalBranchNode() {
    }

    public ConditionalBranchNode(int id, LeftTupleSource tupleSource, ConditionalBranchEvaluator branchEvaluator, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = tupleSource;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.branchEvaluator = branchEvaluator;
        this.initMasks(context, tupleSource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.branchEvaluator = (ConditionalBranchEvaluator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.branchEvaluator);
    }

    public ConditionalBranchEvaluator getBranchEvaluator() {
        return this.branchEvaluator;
    }

    @Override
    public void attach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ConditionalBranchMemory memory = (ConditionalBranchMemory)workingMemory.getNodeMemory(this);
        boolean breaking = false;
        ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = this.branchEvaluator.evaluate(leftTuple, workingMemory, memory.context);
        if (conditionalExecution != null) {
            Object object;
            boolean useLeftMemory = true;
            if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                useLeftMemory = false;
            }
            conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
            breaking = conditionalExecution.isBreaking();
        }
        if (!breaking) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (leftTuple.getFirstChild() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ConditionalBranchMemory memory = (ConditionalBranchMemory)workingMemory.getNodeMemory(this);
        boolean wasPropagated = leftTuple.getFirstChild() != null;
        ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = this.branchEvaluator.evaluate(leftTuple, workingMemory, memory.context);
        if (wasPropagated) {
            LeftTupleSink mainSink = this.sink.getSinks()[0];
            LeftTupleSink oldSink = leftTuple.getFirstChild().getSink();
            if (conditionalExecution != null) {
                LeftTupleSink newSink = conditionalExecution.getSink().getSinks()[0];
                if (oldSink.equals(newSink)) {
                    conditionalExecution.getSink().propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    if (!conditionalExecution.isBreaking()) {
                        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    }
                } else {
                    if (oldSink.equals(mainSink)) {
                        if (conditionalExecution.isBreaking()) {
                            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                        } else {
                            this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                        }
                    } else {
                        conditionalExecution.getSink().propagateRetractLeftTuple(leftTuple, context, workingMemory);
                    }
                    conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    if (!conditionalExecution.isBreaking() && !oldSink.equals(mainSink)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                    }
                }
            } else if (oldSink.equals(mainSink)) {
                this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            } else {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        } else {
            boolean breaking = false;
            if (conditionalExecution != null) {
                conditionalExecution.getSink().propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
                breaking = conditionalExecution.isBreaking();
            }
            if (!breaking) {
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        }
    }

    @Override
    public String toString() {
        return "[ConditionalBranchNode: cond=" + this.branchEvaluator + "]";
    }

    @Override
    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.branchEvaluator.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ConditionalBranchNode.class) {
            return false;
        }
        ConditionalBranchNode other = (ConditionalBranchNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.branchEvaluator.equals(other.branchEvaluator);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new ConditionalBranchMemory(this.branchEvaluator.createContext());
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        EvalNodeLeftTuple peer = new EvalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleIterator it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory(this);
            }
        } else {
            throw new RuntimeException("ConditionalBranchNode cannot be shared");
        }
        this.tupleSource.removeTupleSink(this);
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.tupleSource.collectAncestors(nodeSet);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 167;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.tupleSource.getObjectTypeNode();
    }

    public static class ConditionalBranchMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Externalizable,
    Memory {
        private static final long serialVersionUID = 510L;
        public Object context;
        private SegmentMemory segmentMemory;

        public ConditionalBranchMemory() {
        }

        public ConditionalBranchMemory(Object context) {
            this.context = context;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
        }

        @Override
        public short getNodeType() {
            return 167;
        }

        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.segmentMemory = segmentMemory;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.segmentMemory;
        }
    }
}

