/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.readers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.commons.jci.readers.ResourceReader;

public class MemoryResourceReader
implements ResourceReader {
    private Map resources = null;

    @Override
    public boolean isAvailable(String pResourceName) {
        if (this.resources == null) {
            return false;
        }
        return this.resources.containsKey(pResourceName);
    }

    public void add(String pResourceName, byte[] pContent) {
        if (this.resources == null) {
            this.resources = new HashMap();
        }
        this.resources.put(pResourceName, pContent);
    }

    public void remove(String pResourceName) {
        if (this.resources != null) {
            this.resources.remove(pResourceName);
        }
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        return (byte[])this.resources.get(pResourceName);
    }

    @Override
    public Collection<String> getFileNames() {
        if (this.resources == null) {
            return Collections.emptySet();
        }
        return this.resources.keySet();
    }

    public String[] list() {
        if (this.resources == null) {
            return new String[0];
        }
        return this.resources.keySet().toArray(new String[this.resources.size()]);
    }
}

