/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.util;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.builder.model.QualifierModel;
import org.kie.api.builder.model.WorkItemHandlerModel;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;

public class CDIHelper {
    public static void wireListnersAndWIHs(KieSessionModel model, KieSession kSession) {
        CDIHelper.wireListnersAndWIHs(BeanCreatorHolder.beanCreator, model, kSession);
    }

    public static void wireListnersAndWIHs(BeanManager beanManager, KieSessionModel model, KieSession kSession) {
        CDIHelper.wireListnersAndWIHs(new CDIBeanCreator(beanManager), model, kSession);
    }

    private static void wireListnersAndWIHs(BeanCreator beanCreator, KieSessionModel model, KieSession kSession) {
        for (ListenerModel listenerModel : model.getListenerModels()) {
            Object listener;
            try {
                listener = beanCreator.createBean(listenerModel.getType(), listenerModel.getQualifierModel());
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instance listener " + listenerModel.getType(), e);
            }
            switch (listenerModel.getKind()) {
                case AGENDA_EVENT_LISTENER: {
                    kSession.addEventListener((AgendaEventListener)listener);
                    break;
                }
                case WORKING_MEMORY_EVENT_LISTENER: {
                    kSession.addEventListener((WorkingMemoryEventListener)listener);
                    break;
                }
                case PROCESS_EVENT_LISTENER: {
                    kSession.addEventListener((ProcessEventListener)listener);
                }
            }
        }
        for (WorkItemHandlerModel wihModel : model.getWorkItemHandlerModels()) {
            WorkItemHandler wih;
            try {
                wih = (WorkItemHandler)beanCreator.createBean(wihModel.getType(), wihModel.getQualifierModel());
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instance WorkItemHandler " + wihModel.getType(), e);
            }
            kSession.getWorkItemManager().registerWorkItemHandler("???", wih);
        }
    }

    private static class ReflectionBeanCreator
    implements BeanCreator {
        private ReflectionBeanCreator() {
        }

        @Override
        public <T> T createBean(String type, QualifierModel qualifier) throws Exception {
            if (qualifier != null) {
                throw new IllegalArgumentException("Cannot use a qualifier without a CDI container");
            }
            return (T)Class.forName(type).newInstance();
        }
    }

    private static class CDIBeanCreator
    implements BeanCreator {
        private final BeanManager beanManager;

        private CDIBeanCreator(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        @Override
        public <T> T createBean(String type, QualifierModel qualifier) throws Exception {
            Set beans;
            Class<?> beanType = Class.forName(type);
            if (qualifier == null) {
                beans = this.beanManager.getBeans(beanType, new Annotation[0]);
            } else {
                Annotation annotation = this.getQualifier(qualifier);
                beans = this.beanManager.getBeans(beanType, new Annotation[]{annotation});
            }
            Bean bean = (Bean)beans.iterator().next();
            return (T)bean.create(this.beanManager.createCreationalContext((Contextual)bean));
        }

        private Annotation getQualifier(QualifierModel model) throws Exception {
            return null;
        }
    }

    private static interface BeanCreator {
        public <T> T createBean(String var1, QualifierModel var2) throws Exception;
    }

    private static class BeanCreatorHolder {
        private static final BeanCreator beanCreator = BeanCreatorHolder.loadBeanCreator();

        private BeanCreatorHolder() {
        }

        private static BeanCreator loadBeanCreator() {
            BeanManager beanManager = BeanCreatorHolder.lookupBeanManager();
            return beanManager != null ? new CDIBeanCreator(beanManager) : new ReflectionBeanCreator();
        }

        private static BeanManager lookupBeanManager() {
            try {
                return (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
            }
            catch (NamingException e) {
                try {
                    return (BeanManager)InitialContext.doLookup("java:comp/env/BeanManager");
                }
                catch (NamingException namingException) {
                    return null;
                }
            }
        }
    }
}

