/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.rule.Rule;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;

public class SegmentUtilities {
    public static SegmentMemory createSegmentMemory(LeftTupleSource tupleSource, InternalWorkingMemory wm) {
        long allLinkedTestMask;
        SegmentMemory smem;
        LeftTupleSource segmentRoot;
        block20: {
            block19: {
                LeftTupleSinkNode sink;
                boolean initRtn = false;
                if (tupleSource.getType() == 120) {
                    initRtn = true;
                }
                while (tupleSource.getType() != 120 && SegmentUtilities.parentInSameSegment(tupleSource, null)) {
                    tupleSource = tupleSource.getLeftTupleSource();
                }
                segmentRoot = tupleSource;
                if (initRtn) {
                    SegmentUtilities.initialiseRtnMemory(segmentRoot, wm);
                }
                smem = new SegmentMemory(segmentRoot);
                long nodePosMask = 1L;
                allLinkedTestMask = 0L;
                boolean updateNodeBit = true;
                while (true) {
                    if (NodeTypeEnums.isBetaNode(tupleSource)) {
                        allLinkedTestMask = SegmentUtilities.processBetaNode(tupleSource, wm, smem, nodePosMask, allLinkedTestMask, updateNodeBit);
                    } else {
                        switch (tupleSource.getType()) {
                            case 120: {
                                allLinkedTestMask = SegmentUtilities.processLiaNode((LeftInputAdapterNode)tupleSource, wm, smem, nodePosMask, allLinkedTestMask);
                                break;
                            }
                            case 131: {
                                SegmentUtilities.processEvalNode((EvalConditionNode)tupleSource, wm, smem);
                                break;
                            }
                            case 167: {
                                updateNodeBit = SegmentUtilities.processBranchNode((ConditionalBranchNode)tupleSource, wm, smem);
                                break;
                            }
                            case 151: {
                                SegmentUtilities.processFromNode((FromNode)tupleSource, wm, smem);
                                break;
                            }
                            case 133: {
                                SegmentUtilities.processTimerNode((TimerNode)tupleSource, wm, smem);
                                break;
                            }
                            case 165: {
                                SegmentUtilities.processQueryNode((QueryElementNode)tupleSource, wm, segmentRoot, smem);
                            }
                        }
                    }
                    nodePosMask <<= 1;
                    if (tupleSource.getSinkPropagator().size() != 1) break block19;
                    sink = tupleSource.getSinkPropagator().getFirstLeftTupleSink();
                    if (!NodeTypeEnums.isLeftTupleSource(sink)) break;
                    tupleSource = (LeftTupleSource)((Object)sink);
                }
                if (sink.getType() == 71) {
                    RightInputAdapterNode.RiaNodeMemory memory = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                    smem.getNodeMemories().add(memory.getRiaPathMemory());
                    memory.getRiaPathMemory().setSegmentMemory(smem);
                } else if (NodeTypeEnums.isTerminalNode(sink)) {
                    PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                    smem.getNodeMemories().add(pmem);
                    pmem.setSegmentMemory(smem);
                }
                smem.setTipNode(sink);
                break block20;
            }
            smem.setTipNode(tupleSource);
        }
        smem.setAllLinkedMaskTest(allLinkedTestMask);
        LeftTupleSource pathRoot = segmentRoot;
        int ruleSegmentPosMask = 1;
        int counter = 0;
        while (pathRoot.getType() != 120) {
            if (!SegmentUtilities.parentInSameSegment(pathRoot, null)) {
                ruleSegmentPosMask <<= 1;
                ++counter;
            }
            pathRoot = pathRoot.getLeftTupleSource();
        }
        smem.setSegmentPosMaskBit(ruleSegmentPosMask);
        smem.setPos(counter);
        SegmentUtilities.updateRiaAndTerminalMemory(tupleSource, tupleSource, smem, wm);
        return smem;
    }

    private static void processQueryNode(QueryElementNode tupleSource, InternalWorkingMemory wm, LeftTupleSource segmentRoot, SegmentMemory smem) {
        QueryElementNode queryNode = tupleSource;
        LeftInputAdapterNode liaNode = SegmentUtilities.getQueryLiaNode(queryNode.getQueryElement().getQueryName(), SegmentUtilities.getQueryOtn(segmentRoot));
        LeftInputAdapterNode.LiaNodeMemory liam = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory(liaNode);
        SegmentMemory querySmem = liam.getSegmentMemory();
        if (querySmem == null) {
            querySmem = SegmentUtilities.createSegmentMemory(liaNode, wm);
        }
        QueryElementNode.QueryElementNodeMemory queryNodeMem = (QueryElementNode.QueryElementNodeMemory)smem.createNodeMemory(queryNode, wm);
        queryNodeMem.setQuerySegmentMemory(querySmem);
        queryNodeMem.setSegmentMemory(smem);
    }

    private static void processFromNode(FromNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        FromNode.FromMemory fromMemory = (FromNode.FromMemory)smem.createNodeMemory(tupleSource, wm);
        fromMemory.getBetaMemory().setSegmentMemory(smem);
    }

    private static boolean processBranchNode(ConditionalBranchNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        ConditionalBranchNode.ConditionalBranchMemory branchMem = (ConditionalBranchNode.ConditionalBranchMemory)smem.createNodeMemory(tupleSource, wm);
        branchMem.setSegmentMemory(smem);
        boolean updateNodeBit = false;
        return updateNodeBit;
    }

    private static void processEvalNode(EvalConditionNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        EvalConditionNode.EvalMemory evalMem = (EvalConditionNode.EvalMemory)smem.createNodeMemory(tupleSource, wm);
        evalMem.setSegmentMemory(smem);
    }

    private static void processTimerNode(TimerNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem) {
        TimerNode.TimerNodeMemory tnMem = (TimerNode.TimerNodeMemory)smem.createNodeMemory(tupleSource, wm);
        tnMem.setSegmentMemory(smem);
    }

    private static long processLiaNode(LeftInputAdapterNode tupleSource, InternalWorkingMemory wm, SegmentMemory smem, long nodePosMask, long allLinkedTestMask) {
        LeftInputAdapterNode.LiaNodeMemory liaMemory = (LeftInputAdapterNode.LiaNodeMemory)smem.createNodeMemory(tupleSource, wm);
        liaMemory.setSegmentMemory(smem);
        liaMemory.setNodePosMaskBit(nodePosMask);
        return allLinkedTestMask |= nodePosMask;
    }

    private static long processBetaNode(LeftTupleSource tupleSource, InternalWorkingMemory wm, SegmentMemory smem, long nodePosMask, long allLinkedTestMask, boolean updateNodeBit) {
        BetaNode betaNode = (BetaNode)tupleSource;
        BetaMemory bm = 211 == tupleSource.getType() ? ((AccumulateNode.AccumulateMemory)smem.createNodeMemory((AccumulateNode)tupleSource, wm)).getBetaMemory() : (BetaMemory)smem.createNodeMemory(betaNode, wm);
        bm.setSegmentMemory(smem);
        if (betaNode.isRightInputIsRiaNode()) {
            RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
            LeftTupleSource subnetworkLts = riaNode.getLeftTupleSource();
            while (subnetworkLts.getLeftTupleSource() != riaNode.getStartTupleSource()) {
                subnetworkLts = subnetworkLts.getLeftTupleSource();
            }
            Memory rootSubNetwokrMem = wm.getNodeMemory((MemoryFactory)((Object)subnetworkLts));
            SegmentMemory subNetworkSegmentMemory = rootSubNetwokrMem.getSegmentMemory();
            if (subNetworkSegmentMemory == null) {
                SegmentUtilities.createSegmentMemory(subnetworkLts, wm);
            }
            RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory(riaNode);
            bm.setRiaRuleMemory(riaMem.getRiaPathMemory());
            if (updateNodeBit && riaMem.getRiaPathMemory().getAllLinkedMaskTest() > 0L) {
                allLinkedTestMask |= nodePosMask;
            }
        } else if (updateNodeBit && (191 != tupleSource.getType() || ((NotNode)tupleSource).isEmptyBetaConstraints()) && 211 != tupleSource.getType()) {
            allLinkedTestMask |= nodePosMask;
        }
        bm.setNodePosMaskBit(nodePosMask);
        if (191 == tupleSource.getType()) {
            smem.linkNodeWithoutRuleNotify(bm.getNodePosMaskBit());
        }
        return allLinkedTestMask;
    }

    public static void createChildSegments(InternalWorkingMemory wm, SegmentMemory smem, LeftTupleSinkPropagator sinkProp) {
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            Memory memory = wm.getNodeMemory((MemoryFactory)((Object)sink));
            SegmentMemory childSmem = SegmentUtilities.createChildSegment(wm, sink, memory);
            smem.add(childSmem);
        }
    }

    public static SegmentMemory createChildSegment(InternalWorkingMemory wm, LeftTupleSink sink, Memory memory) {
        if (!NodeTypeEnums.isTerminalNode(sink) && sink.getType() != 71) {
            if (memory.getSegmentMemory() == null) {
                SegmentUtilities.createSegmentMemory((LeftTupleSource)((Object)sink), wm);
            }
        } else if (memory.getSegmentMemory() == null) {
            SegmentMemory childSmem = new SegmentMemory(sink);
            PathMemory pmem = NodeTypeEnums.isTerminalNode(sink) ? (PathMemory)memory : ((RightInputAdapterNode.RiaNodeMemory)memory).getRiaPathMemory();
            pmem.getSegmentMemories()[pmem.getSegmentMemories().length - 1] = childSmem;
            pmem.setSegmentMemory(childSmem);
            childSmem.getPathMemories().add(pmem);
            childSmem.setTipNode(sink);
            childSmem.setSinkFactory(sink);
        }
        return memory.getSegmentMemory();
    }

    public static boolean inSubNetwork(RightInputAdapterNode riaNode, LeftTupleSource leftTupleSource) {
        LeftTupleSource startTupleSource = riaNode.getStartTupleSource();
        for (LeftTupleSource parent = riaNode.getLeftTupleSource(); parent != startTupleSource; parent = parent.getLeftTupleSource()) {
            if (parent != leftTupleSource) continue;
            return true;
        }
        return false;
    }

    public static void updateRiaAndTerminalMemory(LeftTupleSource lt, LeftTupleSource originalLt, SegmentMemory smem, InternalWorkingMemory wm) {
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                BetaMemory bm;
                if (191 == sink.getType() && ((NotNode)sink).isEmptyBetaConstraints() && (bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)sink))).getSegmentMemory() == null) {
                    SegmentUtilities.createSegmentMemory((NotNode)sink, wm);
                }
                SegmentUtilities.updateRiaAndTerminalMemory((LeftTupleSource)((Object)sink), originalLt, smem, wm);
                continue;
            }
            if (sink.getType() == 71) {
                if (!SegmentUtilities.inSubNetwork((RightInputAdapterNode)sink, originalLt)) continue;
                RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
                RiaPathMemory pmem = riaMem.getRiaPathMemory();
                smem.getPathMemories().add(pmem);
                pmem.getSegmentMemories()[smem.getPos()] = smem;
                continue;
            }
            if (!NodeTypeEnums.isTerminalNode(sink)) continue;
            PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
            smem.getPathMemories().add(pmem);
            pmem.getSegmentMemories()[smem.getPos()] = smem;
            if (!smem.isSegmentLinked()) continue;
            smem.notifyRuleLinkSegment(wm);
        }
    }

    public static void initialiseRtnMemory(LeftTupleSource lt, InternalWorkingMemory wm) {
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                SegmentUtilities.initialiseRtnMemory((LeftTupleSource)((Object)sink), wm);
                continue;
            }
            if (!NodeTypeEnums.isTerminalNode(sink)) continue;
            PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)sink));
        }
    }

    public static boolean parentInSameSegment(LeftTupleSource lt, Rule removingRule) {
        LeftTupleSource parentLt = lt.getLeftTupleSource();
        int size = parentLt.getSinkPropagator().size();
        if (removingRule != null && size == 2 && parentLt.getAssociations().containsKey(removingRule)) {
            LeftTupleSinkNode first = parentLt.getSinkPropagator().getFirstLeftTupleSink();
            LeftTupleSinkNode last = parentLt.getSinkPropagator().getLastLeftTupleSink();
            if (first.getAssociations().size() == 1 && first.getAssociations().containsKey(removingRule)) {
                return true;
            }
            return last.getAssociations().size() == 1 && last.getAssociations().containsKey(removingRule);
        }
        return size == 1;
    }

    public static ObjectTypeNode getQueryOtn(LeftTupleSource lts) {
        while (!(lts instanceof LeftInputAdapterNode)) {
            lts = lts.getLeftTupleSource();
        }
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)lts;
        ObjectSource os = liaNode.getObjectSource();
        while (!(os instanceof EntryPointNode)) {
            os = os.getParentObjectSource();
        }
        return ((EntryPointNode)os).getQueryNode();
    }

    public static LeftInputAdapterNode getQueryLiaNode(String queryName, ObjectTypeNode queryOtn) {
        if (queryOtn.getSinkPropagator() instanceof CompositeObjectSinkAdapter) {
            CompositeObjectSinkAdapter sink = (CompositeObjectSinkAdapter)queryOtn.getSinkPropagator();
            if (sink.getHashableSinks() != null) {
                for (AlphaNode alphaNode = (AlphaNode)sink.getHashableSinks().getFirst(); alphaNode != null; alphaNode = (AlphaNode)alphaNode.getNextObjectSinkNode()) {
                    QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
                    if (!queryName.equals(nameConstraint.getQueryName())) continue;
                    return (LeftInputAdapterNode)alphaNode.getSinkPropagator().getSinks()[0];
                }
            }
            Iterator it = sink.getHashedSinkMap().iterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                AlphaNode alphaNode = (AlphaNode)entry.getValue();
                QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
                if (queryName.equals(nameConstraint.getQueryName())) {
                    return (LeftInputAdapterNode)alphaNode.getSinkPropagator().getSinks()[0];
                }
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        } else {
            AlphaNode alphaNode = (AlphaNode)queryOtn.getSinkPropagator().getSinks()[0];
            QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
            if (queryName.equals(nameConstraint.getQueryName())) {
                return (LeftInputAdapterNode)alphaNode.getSinkPropagator().getSinks()[0];
            }
            return (LeftInputAdapterNode)queryOtn.getSinkPropagator().getSinks()[0];
        }
        throw new RuntimeException("Unable to find query '" + queryName + "'");
    }
}

