/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.audit.KnowledgeRuntimeLoggerProviderImpl;
import org.drools.core.command.impl.CommandFactoryServiceImpl;
import org.drools.core.concurrent.ExecutorProviderImpl;
import org.drools.core.io.impl.ResourceFactoryServiceImpl;
import org.drools.core.marshalling.impl.MarshallerProviderImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.KieCommands;
import org.kie.api.concurrent.KieExecutors;
import org.kie.api.io.KieResources;
import org.kie.api.logger.KieLoggers;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.io.ResourceFactoryService;
import org.kie.internal.utils.ServiceRegistryImpl;

public class KieServicesImpl
implements KieServices {
    private ResourceFactoryService resourceFactory;
    private volatile KieContainerImpl classpathKContainer;
    private final Object lock = new Object();

    public ResourceFactoryService getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new ResourceFactoryServiceImpl();
        }
        return this.resourceFactory;
    }

    public KieRepository getRepository() {
        return KieRepositoryImpl.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieContainer getKieClasspathContainer() {
        if (this.classpathKContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classpathKContainer == null) {
                    this.classpathKContainer = new KieContainerImpl(new ClasspathKieProject(), null);
                }
            }
        }
        return this.classpathKContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullKieClasspathContainer() {
        Object object = this.lock;
        synchronized (object) {
            this.classpathKContainer = null;
        }
    }

    public KieContainer newKieContainer(ReleaseId releaseId) {
        InternalKieModule kieModule = (InternalKieModule)this.getRepository().getKieModule(releaseId);
        if (kieModule == null) {
            throw new RuntimeException("Cannot find KieModule: " + releaseId);
        }
        KieModuleKieProject kProject = new KieModuleKieProject(kieModule);
        return new KieContainerImpl(kProject, this.getRepository());
    }

    public KieBuilder newKieBuilder(File file) {
        return file.isDirectory() ? new KieBuilderImpl(file) : this.newKieBuilder(new KieFileSystemImpl(MemoryFileSystem.readFromJar(file)));
    }

    public KieBuilder newKieBuilder(KieFileSystem kieFileSystem) {
        return new KieBuilderImpl(kieFileSystem);
    }

    public KieScanner newKieScanner(KieContainer kieContainer) {
        InternalKieScanner scanner = (InternalKieScanner)ServiceRegistryImpl.getInstance().get(KieScanner.class);
        scanner.setKieContainer(kieContainer);
        return scanner;
    }

    public KieResources getResources() {
        return new ResourceFactoryServiceImpl();
    }

    public KieCommands getCommands() {
        return new CommandFactoryServiceImpl();
    }

    public KieMarshallers getMarshallers() {
        return new MarshallerProviderImpl();
    }

    public KieLoggers getLoggers() {
        return new KnowledgeRuntimeLoggerProviderImpl();
    }

    public KieExecutors getExecutors() {
        return new ExecutorProviderImpl();
    }

    public KieStoreServices getStoreServices() {
        return (KieStoreServices)ServiceRegistryImpl.getInstance().get(KieStoreServices.class);
    }

    public ReleaseId newReleaseId(String groupId, String artifactId, String version) {
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    public KieModuleModel newKieModuleModel() {
        return new KieModuleModelImpl();
    }

    public KieFileSystem newKieFileSystem() {
        return new KieFileSystemImpl();
    }
}

