/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.kie.api.KieServices;
import org.kie.api.Service;
import org.kie.api.builder.KieScanner;
import org.kie.api.concurrent.KieExecutors;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.utils.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final ServiceRegistry instance = new ServiceRegistryImpl();
    protected static final transient Logger logger = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final Map<String, Callable<?>> registry = new HashMap();
    private final Map<String, Callable<?>> defaultServices = new HashMap();

    public static synchronized ServiceRegistry getInstance() {
        return instance;
    }

    public ServiceRegistryImpl() {
        this.init();
    }

    @Override
    public synchronized void registerLocator(Class cls, Callable cal) {
        this.registry.put(cls.getName(), cal);
    }

    @Override
    public synchronized void unregisterLocator(Class cls) {
        this.registry.remove(cls.getName());
    }

    synchronized void registerInstance(Service service, Map map) {
        String[] values;
        logger.info("regInstance : " + map);
        for (String v : values = (String[])map.get("objectClass")) {
            logger.info(v);
        }
        this.registry.put(service.getClass().getInterfaces()[0].getName(), new ReturnInstance(service));
    }

    synchronized void unregisterInstance(Service service, Map map) {
        logger.info("unregister : " + map);
        String name = service.getClass().getInterfaces()[0].getName();
        this.registry.remove(name);
        this.registry.put(name, this.defaultServices.get(name));
    }

    @Override
    public synchronized <T> T get(Class<T> cls) {
        Callable<?> cal = this.registry.get(cls.getName());
        if (cal != null) {
            try {
                return cls.cast(cal.call());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
            }
        }
        cal = this.defaultServices.get(cls.getName());
        try {
            return cls.cast(cal.call());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
        }
    }

    private void init() {
        this.addDefault("org.kie.internal.builder.KnowledgeBuilderFactoryService", "org.drools.compiler.builder.impl.KnowledgeBuilderFactoryServiceImpl");
        this.addDefault("org.kie.api.builder.KnowledgeContainerFactoryService", "org.drools.core.builder.impl.KnowledgeContainerFactoryServiceImpl");
        this.addDefault("org.kie.internal.KnowledgeBaseFactoryService", "org.drools.core.impl.KnowledgeBaseFactoryServiceImpl");
        this.addDefault("org.kie.internal.io.ResourceFactoryService", "org.drools.core.io.impl.ResourceFactoryServiceImpl");
        this.addDefault("org.kie.internal.SystemEventListenerService", "org.drools.core.impl.SystemEventListenerServiceImpl");
        this.addDefault(KieMarshallers.class, "org.drools.core.marshalling.impl.MarshallerProviderImpl");
        this.addDefault(KieExecutors.class, "org.drools.core.concurrent.ExecutorProviderImpl");
        this.addDefault(KieServices.class, "org.drools.compiler.kie.builder.impl.KieServicesImpl");
        this.addDefault(KieScanner.class, "org.kie.scanner.KieRepositoryScannerImpl");
        this.addDefault(KieStoreServices.class, "org.drools.persistence.jpa.KnowledgeStoreServiceImpl");
        this.addDefault(CorrelationKeyFactory.class, "org.jbpm.persistence.correlation.JPACorrelationKeyFactory");
    }

    @Override
    public synchronized void addDefault(Class cls, String impl) {
        this.addDefault(cls.getName(), impl);
    }

    private synchronized void addDefault(String service, String impl) {
        ReflectionInstantiator resourceRi = new ReflectionInstantiator(impl);
        this.defaultServices.put(service, resourceRi);
    }

    static class ReturnInstance<V>
    implements Callable<V> {
        private final Service service;

        public ReturnInstance(Service service) {
            this.service = service;
        }

        @Override
        public V call() throws Exception {
            return (V)this.service;
        }
    }

    static class ReflectionInstantiator<V>
    implements Callable<V> {
        private final String name;

        public ReflectionInstantiator(String name) {
            this.name = name;
        }

        @Override
        public V call() throws Exception {
            return (V)ReflectionInstantiator.newInstance(this.name);
        }

        static <T> T newInstance(String name) {
            try {
                Class<?> cls = Class.forName(name);
                return (T)cls.newInstance();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Unable to instantiate '" + name + "'", e2);
            }
        }
    }
}

