/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.cashflow;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.examples.cashflow.Account;
import org.drools.examples.cashflow.AccountPeriod;
import org.drools.examples.cashflow.CashFlow;
import org.drools.examples.cashflow.CashFlowType;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class CashFlowMain {
    public static void main(String[] args) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        KieSession ksession = kc.newKieSession("CashFlowKS");
        AccountPeriod acp = new AccountPeriod(CashFlowMain.date("2013-01-01"), CashFlowMain.date("2013-03-31"));
        Account ac = new Account(1, 0);
        CashFlow cf1 = new CashFlow(CashFlowMain.date("2013-01-12"), 100, CashFlowType.CREDIT, 1);
        CashFlow cf2 = new CashFlow(CashFlowMain.date("2013-02-2"), 200, CashFlowType.DEBIT, 1);
        CashFlow cf3 = new CashFlow(CashFlowMain.date("2013-05-18"), 50, CashFlowType.CREDIT, 1);
        CashFlow cf4 = new CashFlow(CashFlowMain.date("2013-03-07"), 75, CashFlowType.CREDIT, 1);
        FactHandle fh = ksession.insert(acp);
        ksession.insert(ac);
        ksession.insert(cf1);
        ksession.insert(cf2);
        ksession.insert(cf3);
        ksession.insert(cf4);
        ksession.fireAllRules();
        acp.setStart(CashFlowMain.date("2013-04-01"));
        acp.setEnd(CashFlowMain.date("2013-06-31"));
        ksession.update(fh, acp);
        ksession.fireAllRules();
    }

    public static Date date(String str) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(str);
    }
}

