/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.simple;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.simple.SimpleBeliefSet;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedListEntry;

public class SimpleBeliefSystem
implements BeliefSystem {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public SimpleBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(node.getJustifierEntry());
        if (empty) {
            InternalFactHandle handle = beliefSet.getFactHandle();
            this.ep.insert(handle, handle.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf, null);
        }
    }

    @Override
    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getJustifierEntry());
    }

    @Override
    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        SimpleBeliefSet sBeliefSet = (SimpleBeliefSet)beliefSet;
        beliefSet.remove(node.getJustifierEntry());
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (beliefSet.isEmpty() && (context.getType() != 1 && context.getType() != 2 || context.getFactHandle() != bfh)) {
            ((NamedEntryPoint)bfh.getEntryPoint()).delete(bfh, context.getRuleOrigin(), node.getJustifier());
        } else if (!beliefSet.isEmpty() && beliefSet.getFactHandle().getObject() == node.getObject()) {
            ((NamedEntryPoint)bfh.getEntryPoint()).getObjectStore().updateHandle(bfh, ((LogicalDependency)((LinkedListEntry)beliefSet.getFirst()).getObject()).getObject());
            ((NamedEntryPoint)bfh.getEntryPoint()).update(bfh, true, bfh.getObject(), Long.MAX_VALUE, Object.class, null);
        }
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new SimpleBeliefSet(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(Activation activation, BeliefSet beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, beliefSet, object, value);
    }
}

