/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.ActivationGroupImpl;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.AgendaGroupFactory;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.ActivationGroup;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.ConsequenceException;
import org.drools.core.spi.ConsequenceExceptionHandler;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.LinkedList;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.LeftTupleList;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgenda
implements Externalizable,
InternalAgenda {
    protected static transient Logger log = LoggerFactory.getLogger(DefaultAgenda.class);
    private static final long serialVersionUID = 510L;
    protected InternalWorkingMemory workingMemory;
    private Map<String, InternalAgendaGroup> agendaGroups;
    private Map<String, ActivationGroup> activationGroups;
    private java.util.LinkedList<AgendaGroup> focusStack;
    private InternalAgendaGroup currentModule;
    private InternalAgendaGroup main;
    private java.util.LinkedList<RuleAgendaItem> eager;
    private AgendaGroupFactory agendaGroupFactory;
    protected KnowledgeHelper knowledgeHelper;
    private ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private org.kie.api.runtime.rule.ConsequenceExceptionHandler consequenceExceptionHandler;
    protected volatile AtomicBoolean halt = new AtomicBoolean(false);
    protected int activationCounter;
    private boolean declarativeAgenda;
    private ObjectTypeConf activationObjectTypeConf;
    private ActivationsFilter activationsFilter;
    private volatile boolean isFiringActivation = false;
    private volatile boolean mustNotifyHalt = false;
    private volatile boolean fireUntilHalt = false;

    public DefaultAgenda() {
    }

    public DefaultAgenda(InternalRuleBase rb) {
        this(rb, true);
    }

    public DefaultAgenda(InternalRuleBase rb, boolean initMain) {
        this.agendaGroups = new HashMap<String, InternalAgendaGroup>();
        this.activationGroups = new HashMap<String, ActivationGroup>();
        this.focusStack = new java.util.LinkedList();
        this.agendaGroupFactory = rb.getConfiguration().getAgendaGroupFactory();
        if (initMain) {
            this.main = this.agendaGroupFactory.createAgendaGroup("MAIN", rb);
            this.agendaGroups.put("MAIN", this.main);
            this.focusStack.add(this.main);
        }
        this.eager = new java.util.LinkedList();
        Object object = ClassUtils.instantiateObject(rb.getConfiguration().getConsequenceExceptionHandler(), rb.getConfiguration().getClassLoader());
        if (object instanceof ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (org.kie.api.runtime.rule.ConsequenceExceptionHandler)object;
        }
        this.declarativeAgenda = rb.getConfiguration().isDeclarativeAgenda();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.agendaGroups = (Map)in.readObject();
        this.activationGroups = (Map)in.readObject();
        this.focusStack = (java.util.LinkedList)in.readObject();
        this.currentModule = (InternalAgendaGroup)in.readObject();
        this.main = (InternalAgendaGroup)in.readObject();
        this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        this.knowledgeHelper = (KnowledgeHelper)in.readObject();
        this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)in.readObject();
        this.declarativeAgenda = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.agendaGroups);
        out.writeObject(this.activationGroups);
        out.writeObject(this.focusStack);
        out.writeObject(this.currentModule);
        out.writeObject(this.main);
        out.writeObject(this.agendaGroupFactory);
        out.writeObject(this.knowledgeHelper);
        out.writeObject(this.legacyConsequenceExceptionHandler);
        out.writeBoolean(this.declarativeAgenda);
    }

    @Override
    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory rs, TerminalNode rtn) {
        String agendaGroupName = rtn.getRule().getAgendaGroup();
        String ruleFlowGroupName = rtn.getRule().getRuleFlowGroup();
        RuleAgendaItem lazyAgendaItem = !StringUtils.isEmpty(ruleFlowGroupName) ? new RuleAgendaItem(this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)this.getAgendaGroup(ruleFlowGroupName)) : new RuleAgendaItem(this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)((Object)this.getRuleFlowGroup(agendaGroupName)));
        return lazyAgendaItem;
    }

    @Override
    public long getNextActivationCounter() {
        return this.activationCounter++;
    }

    @Override
    public AgendaItem createAgendaItem(LeftTuple tuple, int salience, PropagationContext context, TerminalNode rtn, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)tuple;
        rtnLeftTuple.init(this.activationCounter++, salience, context, ruleAgendaItem, agendaGroup);
        rtnLeftTuple.setObject(rtnLeftTuple);
        return rtnLeftTuple;
    }

    @Override
    public ScheduledAgendaItem createScheduledAgendaItem(LeftTuple tuple, PropagationContext context, TerminalNode rtn, InternalAgendaGroup agendaGroup) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        RuleBaseConfiguration rbc = ((InternalRuleBase)this.workingMemory.getRuleBase()).getConfiguration();
        this.knowledgeHelper = rbc.isSequential() ? rbc.getComponentFactory().getKnowledgeHelperFactory().newSequentialKnowledgeHelper(this.workingMemory) : rbc.getComponentFactory().getKnowledgeHelperFactory().newStatefulKnowledgeHelper(this.workingMemory);
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        if (item.isInList()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Added {} to eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.add(item);
    }

    @Override
    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        if (!item.isInList()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.remove(item);
    }

    @Override
    public void scheduleItem(ScheduledAgendaItem item, InternalWorkingMemory wm) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void addItemToActivationGroup(AgendaItem item) {
        if (item.isRuleAgendaItem()) {
            throw new UnsupportedOperationException("defensive programming, making sure this isn't called, before removing");
        }
        String group = item.getRule().getActivationGroup();
        if (group != null && group.length() > 0) {
            ActivationGroup actgroup = this.getActivationGroup(group);
            if (actgroup.getTriggeredForRecency() != 0L && actgroup.getTriggeredForRecency() >= ((InternalFactHandle)item.getPropagationContext().getFactHandle()).getRecency()) {
                return;
            }
            actgroup.addActivation(item);
        }
    }

    public ActivationGroup getStageActivationsGroup() {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void insertAndStageActivation(AgendaItem activation) {
        if (this.activationObjectTypeConf == null) {
            EntryPointId ep = this.workingMemory.getEntryPoint();
            this.activationObjectTypeConf = ((InternalWorkingMemoryEntryPoint)((Object)this.workingMemory.getWorkingMemoryEntryPoint(ep.getEntryPointId()))).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep, activation);
        }
        InternalFactHandle factHandle = this.workingMemory.getFactHandleFactory().newFactHandle(activation, this.activationObjectTypeConf, this.workingMemory, this.workingMemory);
        this.workingMemory.getEntryPointNode().assertActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        activation.setFactHandle(factHandle);
    }

    @Override
    public boolean addActivation(AgendaItem activation) {
        throw new UnsupportedOperationException("Defensive, rete only");
    }

    @Override
    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    @Override
    public void removeActivation(AgendaItem activation) {
        throw new UnsupportedOperationException("Defensive, rete only");
    }

    @Override
    public void modifyActivation(AgendaItem activation, boolean previouslyActive) {
        InternalFactHandle factHandle = activation.getFactHandle();
        if (factHandle != null) {
            this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        }
    }

    public void clearAndCancelStagedActivations() {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public int unstageActivations() {
        return 0;
    }

    public void addActivation(AgendaItem item, boolean notify) {
        throw new UnsupportedOperationException("Defensive, rete only");
    }

    @Override
    public void addAgendaItemToGroup(AgendaItem item) {
        throw new UnsupportedOperationException("Defensive");
    }

    @Override
    public void removeScheduleItem(ScheduledAgendaItem item) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), (InternalAgendaGroup)agendaGroup);
    }

    @Override
    public boolean createActivation(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, TerminalNode rtn) {
        throw new UnsupportedOperationException("defensive programming, making sure this isn't called, before removing");
    }

    @Override
    public boolean createPostponedActivation(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, TerminalNode rtn) {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void cancelActivation(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Activation activation, TerminalNode rtn) {
        AgendaItem item = (AgendaItem)activation;
        item.removeAllBlockersAndBlocked(this);
        if (this.isDeclarativeAgenda() && activation.getFactHandle() == null) {
            return;
        }
        if (this.isDeclarativeAgenda()) {
            workingMemory.getEntryPointNode().retractActivation(activation.getFactHandle(), activation.getPropagationContext(), workingMemory);
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
        }
        if (activation.isQueued() && (context.getType() != 5 || context.getFactHandleOrigin() == null)) {
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
            leftTuple.decreaseActivationCountForEvents();
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, MatchCancelledCause.WME_MODIFY);
        }
        if (item.getActivationUnMatchListener() != null) {
            item.getActivationUnMatchListener().unMatch((RuleRuntime)workingMemory.getKnowledgeRuntime(), (Match)item);
        }
        TruthMaintenanceSystemHelper.removeLogicalDependencies(activation, context, rtn.getRule());
    }

    @Override
    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            InternalAgendaGroup igroup = (InternalAgendaGroup)agendaGroup;
            igroup.setActive(true);
            igroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(String name) {
        this.setFocus(null, name);
    }

    public void setFocus(PropagationContext ctx, String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        agendaGroup.setAutoFocusActivator(ctx);
        this.setFocus(agendaGroup);
    }

    @Override
    public AgendaGroup getFocus() {
        return this.focusStack.getLast();
    }

    @Override
    public InternalAgendaGroup getNextFocus() {
        InternalAgendaGroup agendaGroup;
        while ((agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isAutoDeactivate()) {
            boolean empty = agendaGroup.isEmpty();
            if (empty && this.focusStack.size() > 1) {
                agendaGroup.setActive(false);
                this.focusStack.removeLast();
                if (agendaGroup.isAutoDeactivate() && !agendaGroup.getNodeInstances().isEmpty()) {
                    this.innerDeactiveRuleFlowGroup((InternalRuleFlowGroup)agendaGroup);
                }
                EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
                eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
                continue;
            }
            agendaGroup = empty ? null : agendaGroup;
            break;
        }
        if (agendaGroup != null && !agendaGroup.isActive()) {
            agendaGroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    @Override
    public RuleAgendaItem peekNextRule() {
        return (RuleAgendaItem)((InternalAgendaGroup)this.focusStack.peek()).peek();
    }

    public void setCurrentAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.currentModule = agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    @Override
    public AgendaGroup getAgendaGroup(String name) {
        return this.getAgendaGroup(name, this.workingMemory == null ? null : (InternalRuleBase)this.workingMemory.getRuleBase());
    }

    @Override
    public AgendaGroup getAgendaGroup(String name, InternalRuleBase ruleBase) {
        String groupName = name == null || name.length() == 0 ? "MAIN" : name;
        InternalAgendaGroup agendaGroup = this.agendaGroups.get(groupName);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, ruleBase);
            this.addAgendaGroup(agendaGroup);
        }
        agendaGroup.setWorkingMemory((InternalWorkingMemory)this.getWorkingMemory());
        return agendaGroup;
    }

    @Override
    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    @Override
    public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
        return this.agendaGroups;
    }

    public InternalAgendaGroup getMainAgendaGroup() {
        if (this.main == null) {
            this.main = (InternalAgendaGroup)this.getAgendaGroup("MAIN");
        }
        return this.main;
    }

    @Override
    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    @Override
    public java.util.LinkedList<AgendaGroup> getStackList() {
        return this.focusStack;
    }

    @Override
    public void addAgendaGroupOnStack(AgendaGroup agendaGroup) {
        if (this.focusStack.isEmpty() || this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
        }
    }

    @Override
    public Map<String, ActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    @Override
    public ActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl(name);
            this.activationGroups.put(name, activationGroup);
        }
        return activationGroup;
    }

    @Override
    public RuleFlowGroup getRuleFlowGroup(String name) {
        return (RuleFlowGroup)((Object)this.getAgendaGroup(name));
    }

    @Override
    public void activateRuleFlowGroup(String name) {
        InternalRuleFlowGroup group = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(group, -1L, null);
    }

    @Override
    public void activateRuleFlowGroup(String name, long processInstanceId, String nodeInstanceId) {
        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(ruleFlowGroup, processInstanceId, nodeInstanceId);
    }

    public void activateRuleFlowGroup(InternalRuleFlowGroup group, long processInstanceId, String nodeInstanceId) {
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupActivated(group, this.workingMemory);
        group.setActive(true);
        group.hasRuleFlowListener(true);
        if (!StringUtils.isEmpty(nodeInstanceId)) {
            group.addNodeInstance(processInstanceId, nodeInstanceId);
            group.setActive(true);
        }
        this.setFocus(group);
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupActivated(group, this.workingMemory);
    }

    @Override
    public void deactivateRuleFlowGroup(String name) {
        this.deactivateRuleFlowGroup((InternalRuleFlowGroup)this.getRuleFlowGroup(name));
    }

    public void deactivateRuleFlowGroup(InternalRuleFlowGroup group) {
        if (!group.isRuleFlowListener()) {
            return;
        }
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(group, this.workingMemory);
        while (this.focusStack.remove(group)) {
        }
        group.setActive(false);
        this.innerDeactiveRuleFlowGroup(group);
    }

    private void innerDeactiveRuleFlowGroup(InternalRuleFlowGroup group) {
        group.hasRuleFlowListener(false);
        group.getNodeInstances().clear();
        ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(group, this.workingMemory);
    }

    @Override
    public int focusStackSize() {
        int size = 0;
        for (AgendaGroup group : this.focusStack) {
            size += group.size();
        }
        return size;
    }

    @Override
    public int agendaSize() {
        int size = 0;
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            size += internalAgendaGroup.size();
        }
        return size;
    }

    @Override
    public Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            for (Match activation : agendaGroup.getActivations()) {
                list.add((Activation)activation);
            }
        }
        return list.toArray(new Activation[list.size()]);
    }

    @Override
    public Activation[] getScheduledActivations() {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public LinkedList<ScheduledAgendaItem> getScheduledActivationsLinkedList() {
        throw new UnsupportedOperationException("rete only");
    }

    @Override
    public void clear() {
        this.focusStack.clear();
        this.focusStack.add(this.getMainAgendaGroup());
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            for (Activation a : internalAgendaGroup.getActivations()) {
                if (!a.isRuleAgendaItem()) continue;
                ((RuleAgendaItem)a).getRuleExecutor().reEvaluateNetwork(this.workingMemory, new LinkedList<StackEntry>(), false);
            }
            internalAgendaGroup.clear();
        }
        for (ActivationGroup activationGroup : this.activationGroups.values()) {
            activationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            activationGroup.clear();
        }
    }

    @Override
    public void clearAndCancel() {
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            this.clearAndCancelAgendaGroup(internalAgendaGroup);
        }
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        this.clearAndCancelStagedActivations();
        for (ActivationGroup group : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(group);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(String name) {
        AgendaGroup agendaGroup = this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(AgendaGroup agendaGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        ((InternalAgendaGroup)agendaGroup).setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        ArrayList<RuleAgendaItem> lazyItems = new ArrayList<RuleAgendaItem>();
        for (Activation aQueueable : ((InternalAgendaGroup)agendaGroup).getAndClear()) {
            AgendaItem item = (AgendaItem)aQueueable;
            if (item == null) continue;
            if (item.isRuleAgendaItem()) {
                lazyItems.add((RuleAgendaItem)item);
                ((RuleAgendaItem)item).getRuleExecutor().cancel(this.workingMemory, eventsupport);
                continue;
            }
            item.setQueued(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, MatchCancelledCause.CLEAR);
        }
        for (RuleAgendaItem lazyItem : lazyItems) {
            ((InternalAgendaGroup)agendaGroup).add(lazyItem);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(String name) {
        ActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(ActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        activationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isQueued()) continue;
            activation.setQueued(false);
            activation.remove();
            RuleExecutor ruleExec = ((RuleTerminalNodeLeftTuple)activation).getRuleAgendaItem().getRuleExecutor();
            ruleExec.removeLeftTuple((LeftTuple)((Object)activation));
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory, MatchCancelledCause.CLEAR);
        }
        activationGroup.clear();
    }

    @Override
    public void clearAndCancelRuleFlowGroup(String name) {
        this.clearAndCancelAgendaGroup(this.agendaGroups.get(name));
    }

    @Override
    public void clearAndCancelAndCancel(RuleFlowGroup ruleFlowGroup) {
        this.clearAndCancelAgendaGroup((InternalAgendaGroup)((Object)ruleFlowGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fireNextItem(AgendaFilter filter, int fireCount, int fireLimit) throws ConsequenceException {
        int localFireCount = 0;
        try {
            boolean tryagain;
            do {
                RuleAgendaItem item;
                this.evaluateEagerList();
                this.workingMemory.prepareToFireActivation();
                tryagain = false;
                InternalAgendaGroup group = this.getNextFocus();
                if (group == null) continue;
                if (((InternalRuleBase)this.workingMemory.getRuleBase()).getConfiguration().isSequential()) {
                    item = (RuleAgendaItem)group.remove();
                    item.setBlocked(true);
                } else {
                    item = (RuleAgendaItem)group.peek();
                }
                if (item != null && (localFireCount = item.getRuleExecutor().evaluateNetworkAndFire(this.workingMemory, filter, fireCount, fireLimit)) == 0) {
                    tryagain = true;
                    this.workingMemory.executeQueuedActions();
                }
                if ((AgendaItem)group.peek() != null && ((AgendaItem)group.peek()).getTerminalNode().isFireDirect()) continue;
                this.unstageActivations();
            } while (tryagain);
        }
        finally {
            this.workingMemory.activationFired();
        }
        return localFireCount;
    }

    @Override
    public void evaluateEagerList() {
        while (!this.eager.isEmpty()) {
            RuleAgendaItem item = this.eager.removeFirst();
            item.getRuleExecutor().evaluateNetwork(this.workingMemory);
        }
    }

    @Override
    public int sizeOfRuleFlowGroup(String name) {
        InternalAgendaGroup group = this.agendaGroups.get(name);
        if (group == null) {
            return 0;
        }
        int count = 0;
        for (Activation item : group.getActivations()) {
            if (((RuleAgendaItem)item).getRuleExecutor().getLeftTupleList().isEmpty()) continue;
            count += ((RuleAgendaItem)item).getRuleExecutor().getLeftTupleList().size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void fireActivation(Activation activation) throws ConsequenceException {
        this.workingMemory.startOperation();
        this.isFiringActivation = true;
        try {
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation, this.workingMemory);
            if (activation.getActivationGroupNode() != null) {
                ActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
                activationGroup.removeActivation(activation);
                this.clearAndCancelActivationGroup(activationGroup);
            }
            activation.setQueued(false);
            try {
                this.knowledgeHelper.setActivation(activation);
                if (log.isTraceEnabled()) {
                    log.trace("Fire \"{}\" \n{}", (Object)activation.getRule().getName(), (Object)activation.getTuple());
                }
                activation.getConsequence().evaluate(this.knowledgeHelper, this.workingMemory);
                this.knowledgeHelper.cancelRemainingPreviousLogicalDependencies();
                this.knowledgeHelper.reset();
            }
            catch (Exception e) {
                if (this.legacyConsequenceExceptionHandler != null) {
                    this.legacyConsequenceExceptionHandler.handleException(activation, this.workingMemory, e);
                }
                if (this.consequenceExceptionHandler != null) {
                    this.consequenceExceptionHandler.handleException((Match)activation, (RuleRuntime)this.workingMemory.getKnowledgeRuntime(), e);
                }
                throw new RuntimeException(e);
            }
            finally {
                if (activation.getFactHandle() != null) {
                    InternalFactHandle factHandle = activation.getFactHandle();
                    this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                    activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                }
                for (LeftTuple tuple = activation.getTuple(); tuple != null; tuple = tuple.getParent()) {
                    if (!tuple.getLastHandle().isEvent()) continue;
                    EventFactHandle handle = (EventFactHandle)tuple.getLastHandle();
                    handle.decreaseActivationsCount();
                    if (!handle.isExpired() || handle.getActivationsCount() > 0L) continue;
                    handle.getEntryPoint().retract((FactHandle)handle);
                }
            }
            eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation, this.workingMemory);
            this.unstageActivations();
        }
        finally {
            this.isFiringActivation = false;
            if (this.mustNotifyHalt) {
                this.mustNotifyHalt = false;
                this.notifyHalt();
            }
            this.workingMemory.endOperation();
        }
    }

    @Override
    public synchronized boolean fireTimedActivation(Activation activation, boolean saveForLater) throws ConsequenceException {
        if (!this.halt.get()) {
            this.fireActivation(activation);
            return !this.halt.get();
        }
        return false;
    }

    @Override
    public boolean isRuleInstanceAgendaItem(String ruleflowGroupName, String ruleName, long processInstanceId) {
        Activation[] matches;
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        for (Activation match : matches = ((InternalAgendaGroup)((Object)systemRuleFlowGroup)).getActivations()) {
            Activation act = match;
            if (act.isRuleAgendaItem()) {
                RuleAgendaItem ruleAgendaItem = (RuleAgendaItem)act;
                ruleAgendaItem.getRuleExecutor().evaluateNetwork(this.workingMemory);
                LeftTupleList list = ruleAgendaItem.getRuleExecutor().getLeftTupleList();
                for (RuleTerminalNodeLeftTuple lt = (RuleTerminalNodeLeftTuple)list.getFirst(); lt != null; lt = (RuleTerminalNodeLeftTuple)lt.getNext()) {
                    if (!ruleName.equals(lt.getRule().getName()) || !this.checkProcessInstance(lt, processInstanceId)) continue;
                    return true;
                }
                continue;
            }
            if (!ruleName.equals(act.getRule().getName()) || !this.checkProcessInstance(act, processInstanceId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessInstance(Activation activation, long processInstanceId) {
        Map<String, Declaration> declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue(this.workingMemory, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == processInstanceId;
        }
        return true;
    }

    @Override
    public String getFocusName() {
        return this.getFocus().getName();
    }

    @Override
    public boolean isFireUntilHalt() {
        return this.fireUntilHalt;
    }

    @Override
    public void stageLeftTuple(RuleAgendaItem ruleAgendaItem, AgendaItem justified) {
        if (!ruleAgendaItem.isQueued()) {
            ruleAgendaItem.getRuleExecutor().getPathMemory().queueRuleAgendaItem(this.workingMemory);
        }
        ruleAgendaItem.getRuleExecutor().addLeftTuple(justified.getTuple());
    }

    @Override
    public void fireUntilHalt() {
        this.fireUntilHalt = true;
        this.fireUntilHalt(null);
    }

    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.halt.set(false);
        if (log.isTraceEnabled()) {
            log.trace("Starting fireUntilHalt");
        }
        while (this.continueFiring(-1)) {
            boolean fired = this.fireNextItem(agendaFilter, 0, -1) >= 0 || !((AbstractWorkingMemory)this.workingMemory).getActionQueue().isEmpty();
            this.workingMemory.executeQueuedActions();
            if (!fired) {
                Thread.yield();
                continue;
            }
            this.workingMemory.executeQueuedActions();
        }
        if (log.isTraceEnabled()) {
            log.trace("Ending fireUntilHalt");
        }
        this.fireUntilHalt = false;
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.unstageActivations();
        this.halt.set(false);
        int fireCount = 0;
        int returnedFireCount = 0;
        do {
            returnedFireCount = this.fireNextItem(agendaFilter, fireCount, fireLimit);
            this.workingMemory.executeQueuedActions();
        } while (this.continueFiring(0) && returnedFireCount != 0 && (fireLimit == -1 || (fireCount += returnedFireCount) < fireLimit));
        if (this.focusStack.size() == 1 && this.getMainAgendaGroup().isEmpty()) {
            this.getMainAgendaGroup().setActive(false);
        }
        return fireCount;
    }

    @Override
    public boolean continueFiring(int fireLimit) {
        return !this.halt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyHalt() {
        AtomicBoolean atomicBoolean = this.halt;
        synchronized (atomicBoolean) {
            this.halt.notifyAll();
        }
    }

    @Override
    public void halt() {
        this.halt.set(true);
        this.notifyHalt();
    }

    public ConsequenceExceptionHandler getConsequenceExceptionHandler() {
        return this.legacyConsequenceExceptionHandler;
    }

    @Override
    public void setActivationsFilter(ActivationsFilter filter) {
        this.activationsFilter = filter;
    }

    @Override
    public ActivationsFilter getActivationsFilter() {
        return this.activationsFilter;
    }
}

