/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.beans.IntrospectionException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.BaseKnowledgeBuilderResultImpl;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.ConfigurableSeverityResult;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DeprecatedResourceTypeWarning;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DisabledPropertyReactiveWarning;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.DroolsErrorWrapper;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.compiler.compiler.DroolsWarningWrapper;
import org.drools.compiler.compiler.DuplicateFunction;
import org.drools.compiler.compiler.DuplicateRule;
import org.drools.compiler.compiler.FunctionError;
import org.drools.compiler.compiler.GlobalError;
import org.drools.compiler.compiler.PMMLCompiler;
import org.drools.compiler.compiler.PMMLCompilerFactory;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageBuilderResults;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.ParserError;
import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.compiler.ProcessLoadError;
import org.drools.compiler.compiler.ResourceTypeBuilder;
import org.drools.compiler.compiler.ResourceTypeBuilderRegistry;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.compiler.ScoreCardFactory;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.compiler.xml.XmlPackageReader;
import org.drools.compiler.lang.ExpanderException;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.EnumLiteralDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.DialectError;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.compiler.runtime.pipeline.impl.DroolsJaxbHelperProviderImpl;
import org.drools.core.PackageIntegrationException;
import org.drools.core.RuleBase;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.TypeResolver;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.impl.KnowledgePackageImp;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassBuilder;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.EnumClassDefinition;
import org.drools.core.factmodel.EnumLiteralDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.io.impl.DescrResource;
import org.drools.core.io.impl.ReaderResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.rule.Function;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.Rule;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.type.DateFormats;
import org.drools.core.type.DateFormatsImpl;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.DeepCloneable;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.HierarchySorter;
import org.drools.core.util.StringUtils;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.core.xml.XmlChangeSetReader;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.type.ClassReactive;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.definition.type.Role;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.ChangeSet;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.ScoreCardConfiguration;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.definition.KnowledgePackage;
import org.xml.sax.SAXException;

public class PackageBuilder
implements DeepCloneable<PackageBuilder> {
    private final Map<String, PackageRegistry> pkgRegistryMap;
    private List<KnowledgeBuilderResult> results;
    private final PackageBuilderConfiguration configuration;
    public static final RuleBuilder ruleBuilder = new RuleBuilder();
    private ReteooRuleBase ruleBase;
    private final String defaultDialect;
    private ClassLoader rootClassLoader;
    private final Map<String, Class<?>> globals;
    private Resource resource;
    private List<DSLTokenizedMappingFile> dslFiles;
    private TimeIntervalParser timeParser;
    protected DateFormats dateFormats;
    private final ProcessBuilder processBuilder;
    private IllegalArgumentException processBuilderCreationFailure;
    private PMMLCompiler pmmlCompiler;
    private final Map<String, TypeDeclaration> builtinTypes;
    private Map<String, TypeDeclaration> cacheTypes;
    private final Map<String, Map<String, AttributeDescr>> packageAttributes = new HashMap<String, Map<String, AttributeDescr>>();
    private final Map<String, List<PackageDescr>> packages = new HashMap<String, List<PackageDescr>>();
    private final Set<String> generatedTypes = new HashSet<String>();
    private final Stack<List<Resource>> buildResources = new Stack();
    private int currentRulePackage = 0;

    public PackageBuilder() {
        this((RuleBase)null, null);
    }

    public PackageBuilder(org.drools.core.rule.Package pkg) {
        this(pkg, null);
    }

    public PackageBuilder(RuleBase ruleBase) {
        this(ruleBase, null);
    }

    public PackageBuilder(PackageBuilderConfiguration configuration) {
        this((RuleBase)null, configuration);
    }

    public PackageBuilder(org.drools.core.rule.Package pkg, PackageBuilderConfiguration configuration) {
        this.configuration = configuration == null ? new PackageBuilderConfiguration() : configuration;
        this.dateFormats = null;
        if (this.dateFormats == null) {
            this.dateFormats = new DateFormatsImpl();
        }
        this.rootClassLoader = this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.pkgRegistryMap = new LinkedHashMap<String, PackageRegistry>();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        PackageRegistry pkgRegistry = new PackageRegistry(this, pkg);
        pkgRegistry.setDialect(this.defaultDialect);
        this.pkgRegistryMap.put(pkg.getName(), pkgRegistry);
        for (ImportDeclaration implDecl : pkg.getImports().values()) {
            pkgRegistry.addImport(new ImportDescr(implDecl.getTarget()));
        }
        this.globals = new HashMap();
        this.processBuilder = this.createProcessBuilder();
        this.builtinTypes = new HashMap<String, TypeDeclaration>();
        this.initBuiltinTypeDeclarations();
    }

    public PackageBuilder(RuleBase ruleBase, PackageBuilderConfiguration configuration) {
        this.configuration = configuration == null ? new PackageBuilderConfiguration() : configuration;
        this.rootClassLoader = ruleBase != null ? ((InternalRuleBase)ruleBase).getRootClassLoader() : this.configuration.getClassLoader();
        this.dateFormats = null;
        if (this.dateFormats == null) {
            this.dateFormats = new DateFormatsImpl();
        }
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.pkgRegistryMap = new LinkedHashMap<String, PackageRegistry>();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.ruleBase = (ReteooRuleBase)ruleBase;
        this.globals = new HashMap();
        this.processBuilder = this.createProcessBuilder();
        this.builtinTypes = new HashMap<String, TypeDeclaration>();
        this.initBuiltinTypeDeclarations();
    }

    public PackageBuilder deepClone() {
        PackageBuilder clone = new PackageBuilder(this.configuration);
        clone.rootClassLoader = this.rootClassLoader;
        for (Map.Entry<String, PackageRegistry> entry : this.pkgRegistryMap.entrySet()) {
            clone.pkgRegistryMap.put(entry.getKey(), entry.getValue().clonePackage(this.rootClassLoader));
        }
        clone.results.addAll(this.results);
        clone.ruleBase = (ReteooRuleBase)ClassUtils.deepClone((Externalizable)this.ruleBase, (ClassLoader)this.rootClassLoader);
        clone.globals.putAll(this.globals);
        if (this.dslFiles != null) {
            clone.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
            clone.dslFiles.addAll(this.dslFiles);
        }
        if (this.cacheTypes != null) {
            clone.cacheTypes = new HashMap<String, TypeDeclaration>();
            clone.cacheTypes.putAll(this.cacheTypes);
        }
        clone.packageAttributes.putAll(this.packageAttributes);
        for (Map.Entry<String, Object> entry : this.packages.entrySet()) {
            clone.packages.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        clone.packages.putAll(this.packages);
        clone.currentRulePackage = this.currentRulePackage;
        return clone;
    }

    private void initBuiltinTypeDeclarations() {
        TypeDeclaration colType = new TypeDeclaration("Collection");
        colType.setTypesafe(false);
        colType.setTypeClass(Collection.class);
        this.builtinTypes.put("java.util.Collection", colType);
        TypeDeclaration mapType = new TypeDeclaration("Map");
        mapType.setTypesafe(false);
        mapType.setTypeClass(Map.class);
        this.builtinTypes.put("java.util.Map", mapType);
        TypeDeclaration activationType = new TypeDeclaration("Match");
        activationType.setTypesafe(false);
        activationType.setTypeClass(Match.class);
        this.builtinTypes.put(Match.class.getCanonicalName(), activationType);
        TypeDeclaration thingType = new TypeDeclaration(Thing.class.getSimpleName());
        thingType.setKind(TypeDeclaration.Kind.TRAIT);
        thingType.setTypeClass(Thing.class);
        this.builtinTypes.put(Thing.class.getCanonicalName(), thingType);
    }

    private ProcessBuilder createProcessBuilder() {
        try {
            return ProcessBuilderFactory.newProcessBuilder(this);
        }
        catch (IllegalArgumentException e) {
            this.processBuilderCreationFailure = e;
            return null;
        }
    }

    private PMMLCompiler getPMMLCompiler() {
        if (this.pmmlCompiler == null) {
            this.pmmlCompiler = PMMLCompilerFactory.getPMMLCompiler();
        }
        return this.pmmlCompiler;
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        this.addPackageFromDrl(reader, (Resource)new ReaderResource(reader, ResourceType.DRL));
    }

    public void addPackageFromDrl(Reader reader, Resource sourceResource) throws DroolsParserException, IOException {
        this.resource = sourceResource;
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(sourceResource, reader);
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add(new ParserError(sourceResource, "Parser returned a null Package", 0, 0));
        }
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDecisionTable(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.decisionTableToPackageDescr(resource, configuration));
        this.resource = null;
    }

    PackageDescr decisionTableToPackageDescr(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        DecisionTableConfiguration dtableConfiguration = (DecisionTableConfiguration)configuration;
        String string = DecisionTableFactory.loadFromInputStream(resource.getInputStream(), dtableConfiguration);
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(resource, (Reader)new StringReader(string));
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add(new ParserError(resource, "Parser returned a null Package", 0, 0));
        }
        return parser.hasErrors() ? null : pkg;
    }

    public void addPackageFromScoreCard(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.scoreCardToPackageDescr(resource, configuration));
        this.resource = null;
    }

    PackageDescr scoreCardToPackageDescr(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        ScoreCardConfiguration scardConfiguration = (ScoreCardConfiguration)configuration;
        String string = ScoreCardFactory.loadFromInputStream(resource.getInputStream(), scardConfiguration);
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(resource, (Reader)new StringReader(string));
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add(new ParserError(resource, "Parser returned a null Package", 0, 0));
        }
        return parser.hasErrors() ? null : pkg;
    }

    public void addPackageFromDrl(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.drlToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr drlToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        PackageDescr pkg;
        boolean hasErrors = false;
        if (resource instanceof DescrResource) {
            pkg = (PackageDescr)((DescrResource)resource).getDescr();
        } else {
            DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
            pkg = parser.parse(resource);
            this.results.addAll(parser.getErrors());
            if (pkg == null) {
                this.results.add(new ParserError(resource, "Parser returned a null Package", 0, 0));
            }
            hasErrors = parser.hasErrors();
        }
        if (pkg != null) {
            pkg.setResource(resource);
        }
        return hasErrors ? null : pkg;
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(reader, ResourceType.XDRL);
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader(this.rootClassLoader);
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
        this.resource = null;
    }

    public void addPackageFromXml(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.xmlToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr xmlToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader(this.rootClassLoader);
        Reader reader = null;
        try {
            reader = resource.getReader();
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return xmlReader.getPackageDescr();
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(source, ResourceType.DSLR);
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDslr(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.dslrToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr dslrToPackageDescr(Resource resource) throws DroolsParserException {
        boolean hasErrors;
        PackageDescr pkg;
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        DefaultExpander expander = this.getDslExpander();
        Reader reader = null;
        try {
            if (expander == null) {
                expander = new DefaultExpander();
            }
            reader = resource.getReader();
            String str = expander.expand(reader);
            if (expander.hasErrors()) {
                for (ExpanderException error : expander.getErrors()) {
                    error.setResource(resource);
                    this.results.add(error);
                }
            }
            pkg = parser.parse(resource, str);
            this.results.addAll(parser.getErrors());
            hasErrors = parser.hasErrors();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return hasErrors ? null : pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDsl(Resource resource) throws IOException {
        this.resource = resource;
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        Reader reader = null;
        try {
            reader = resource.getReader();
            if (!file.parseAndLoad(reader)) {
                this.results.addAll(file.getErrors());
            }
            if (this.dslFiles == null) {
                this.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
            }
            this.dslFiles.add(file);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            this.resource = null;
        }
    }

    public void addRuleFlow(Reader processSource) {
        this.addProcessFromXml(processSource);
    }

    public void addProcessFromXml(Resource resource) {
        if (this.processBuilder == null) {
            throw new RuntimeException("Unable to instantiate a process builder", this.processBuilderCreationFailure);
        }
        if (ResourceType.DRF.equals((Object)resource.getResourceType())) {
            this.results.add(new DeprecatedResourceTypeWarning(resource, "RF"));
        }
        this.resource = resource;
        try {
            this.results.addAll(this.processBuilder.addProcessFromXml(resource));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.results.add(new ProcessLoadError(resource, "Unable to load process.", e));
        }
        this.results = this.getResults(this.results);
        this.resource = null;
    }

    public void addProcessFromXml(Reader processSource) {
        this.addProcessFromXml((Resource)new ReaderResource(processSource, ResourceType.DRF));
    }

    public void addKnowledgeResource(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        try {
            ((InternalResource)resource).setResourceType(type);
            if (ResourceType.DRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.GDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.RDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.DESCR.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.DSLR.equals((Object)type)) {
                this.addPackageFromDslr(resource);
            } else if (ResourceType.RDSLR.equals((Object)type)) {
                this.addPackageFromDslr(resource);
            } else if (ResourceType.DSL.equals((Object)type)) {
                this.addDsl(resource);
            } else if (ResourceType.XDRL.equals((Object)type)) {
                this.addPackageFromXml(resource);
            } else if (ResourceType.DRF.equals((Object)type)) {
                this.addProcessFromXml(resource);
            } else if (ResourceType.BPMN2.equals((Object)type)) {
                BPMN2ProcessFactory.configurePackageBuilder(this);
                this.addProcessFromXml(resource);
            } else if (ResourceType.DTABLE.equals((Object)type)) {
                this.addPackageFromDecisionTable(resource, configuration);
            } else if (ResourceType.PKG.equals((Object)type)) {
                this.addPackageFromInputStream(resource);
            } else if (ResourceType.CHANGE_SET.equals((Object)type)) {
                this.addPackageFromChangeSet(resource);
            } else if (ResourceType.XSD.equals((Object)type)) {
                this.addPackageFromXSD(resource, (JaxbConfigurationImpl)configuration);
            } else if (ResourceType.PMML.equals((Object)type)) {
                this.addPackageFromPMML(resource, type, configuration);
            } else if (ResourceType.SCARD.equals((Object)type)) {
                this.addPackageFromScoreCard(resource, configuration);
            } else {
                this.addPackageForExternalType(resource, type, configuration);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void addPackageForExternalType(Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        ResourceTypeBuilder builder = ResourceTypeBuilderRegistry.getInstance().getResourceTypeBuilder(type);
        if (builder == null) {
            throw new RuntimeException("Unknown resource type: " + type);
        }
        builder.setPackageBuilder(this);
        builder.addKnowledgeResource(resource, type, configuration);
    }

    public void addPackageFromPMML(Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        PMMLCompiler compiler = this.getPMMLCompiler();
        if (compiler != null) {
            this.resource = resource;
            this.addPackage(this.pmmlModelToPackageDescr(compiler, resource));
            this.resource = null;
        } else {
            this.addPackageForExternalType(resource, type, configuration);
        }
    }

    PackageDescr pmmlModelToPackageDescr(PMMLCompiler compiler, Resource resource) throws DroolsParserException, IOException {
        String theory = compiler.compile(resource.getInputStream(), this.getPackageRegistry());
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(resource, (Reader)new StringReader(theory));
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add(new ParserError(resource, "Parser returned a null Package", 0, 0));
            return pkg;
        }
        return parser.hasErrors() ? null : pkg;
    }

    void addPackageFromXSD(Resource resource, JaxbConfigurationImpl configuration) throws IOException {
        String[] classes;
        for (String cls : classes = DroolsJaxbHelperProviderImpl.addXsdModel(resource, this, configuration.getXjcOpts(), configuration.getSystemId())) {
            configuration.getClasses().add(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPackageFromChangeSet(Resource resource) throws SAXException, IOException {
        XmlChangeSetReader reader = new XmlChangeSetReader(this.configuration.getSemanticModules());
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), ((ClassPathResource)resource).getClazz());
        } else {
            reader.setClassLoader(this.configuration.getClassLoader(), null);
        }
        Reader resourceReader = null;
        try {
            resourceReader = resource.getReader();
            ChangeSet changeSet = reader.read(resourceReader);
            if (changeSet == null) {
                // empty if block
            }
            for (Resource nestedResource : changeSet.getResourcesAdded()) {
                InternalResource iNestedResourceResource = (InternalResource)nestedResource;
                if (iNestedResourceResource.isDirectory()) {
                    for (Resource childResource : iNestedResourceResource.listResources()) {
                        if (((InternalResource)childResource).isDirectory()) continue;
                        ((InternalResource)childResource).setResourceType(iNestedResourceResource.getResourceType());
                        this.addKnowledgeResource(childResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
                    }
                    continue;
                }
                this.addKnowledgeResource((Resource)iNestedResourceResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
            }
        }
        finally {
            if (resourceReader != null) {
                resourceReader.close();
            }
        }
    }

    void addPackageFromInputStream(final Resource resource) throws IOException, ClassNotFoundException {
        InputStream is = resource.getInputStream();
        Object object = DroolsStreamUtils.streamIn((InputStream)is, (ClassLoader)this.configuration.getClassLoader());
        is.close();
        if (object instanceof Collection) {
            Collection pkgs = (Collection)object;
            for (KnowledgePackage kpkg : pkgs) {
                this.overrideReSource(((KnowledgePackageImp)kpkg).pkg, resource);
                this.addPackage(((KnowledgePackageImp)kpkg).pkg);
            }
        } else if (object instanceof KnowledgePackageImp) {
            KnowledgePackageImp kpkg = (KnowledgePackageImp)object;
            this.overrideReSource(kpkg.pkg, resource);
            this.addPackage(kpkg.pkg);
        } else if (object instanceof org.drools.core.rule.Package) {
            org.drools.core.rule.Package pkg = (org.drools.core.rule.Package)object;
            this.overrideReSource(pkg, resource);
            this.addPackage(pkg);
        } else if (object instanceof org.drools.core.rule.Package[]) {
            org.drools.core.rule.Package[] pkgs;
            for (org.drools.core.rule.Package pkg : pkgs = (org.drools.core.rule.Package[])object) {
                this.overrideReSource(pkg, resource);
                this.addPackage(pkg);
            }
        } else {
            this.results.add(new DroolsError(resource){

                @Override
                public String getMessage() {
                    return "Unknown binary format trying to load resource " + resource.toString();
                }

                @Override
                public int[] getLines() {
                    return new int[0];
                }
            });
        }
    }

    private void overrideReSource(org.drools.core.rule.Package pkg, Resource res) {
        for (Rule r : pkg.getRules()) {
            if (!this.isSwappable(r.getResource(), res)) continue;
            r.setResource(res);
        }
        for (TypeDeclaration d : pkg.getTypeDeclarations().values()) {
            if (!this.isSwappable(d.getResource(), res)) continue;
            d.setResource(res);
        }
        for (Function f : pkg.getFunctions().values()) {
            if (!this.isSwappable(f.getResource(), res)) continue;
            f.setResource(res);
        }
        for (Process p : pkg.getRuleFlows().values()) {
            if (!this.isSwappable(p.getResource(), res)) continue;
            p.setResource(res);
        }
    }

    private boolean isSwappable(Resource original, Resource source) {
        return original == null || original instanceof ReaderResource && ((ReaderResource)original).getReader() == null;
    }

    public void addPackage(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.initPackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return;
        }
        this.currentRulePackage = this.pkgRegistryMap.size() - 1;
        this.mergePackage(pkgRegistry, packageDescr);
        this.compileAllRules(packageDescr, pkgRegistry);
    }

    void compileAllRules(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        pkgRegistry.setDialect(this.getPackageDialect(packageDescr));
        if (!this.hasErrors()) {
            this.compileRules(packageDescr, pkgRegistry);
        }
        this.compileAll();
        try {
            this.reloadAll();
        }
        catch (Exception e) {
            this.results.add(new DialectError(null, "Unable to wire compiled classes, probably related to compilation failures:" + e.getMessage()));
        }
        this.updateResults();
        if (!this.hasErrors() && this.ruleBase != null) {
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                pkgRegistry = this.pkgRegistryMap.get(ruleDescr.getNamespace());
                this.ruleBase.addRule(pkgRegistry.getPackage(), pkgRegistry.getPackage().getRule(ruleDescr.getName()));
            }
        }
    }

    PackageRegistry initPackageRegistry(PackageDescr packageDescr) {
        if (packageDescr == null) {
            return null;
        }
        if (this.isEmpty(packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getDefaultPackageName());
        }
        this.validateUniqueRuleNames(packageDescr);
        if (!this.checkNamespace(packageDescr.getNamespace())) {
            return null;
        }
        this.initPackage(packageDescr);
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        if (pkgRegistry == null) {
            pkgRegistry = this.newPackage(packageDescr);
        }
        return pkgRegistry;
    }

    private void compileRules(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        List<FunctionDescr> functions = packageDescr.getFunctions();
        if (!functions.isEmpty()) {
            for (FunctionDescr functionDescr : functions) {
                if (this.isEmpty(functionDescr.getNamespace())) {
                    functionDescr.setNamespace(packageDescr.getNamespace());
                }
                functionDescr.setDialect("java");
                this.preCompileAddFunction(functionDescr);
            }
            for (FunctionDescr functionDescr : functions) {
                this.addFunction(functionDescr);
            }
            this.compileAll();
            for (FunctionDescr functionDescr : functions) {
                this.postCompileAddFunction(functionDescr);
            }
        }
        this.sortRulesByDependency(packageDescr);
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            if (this.isEmpty(ruleDescr.getNamespace())) {
                ruleDescr.setNamespace(packageDescr.getNamespace());
            }
            Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
            this.inheritPackageAttributes(pkgAttributes, ruleDescr);
            if (this.isEmpty(ruleDescr.getDialect())) {
                ruleDescr.addAttribute(new AttributeDescr("dialect", pkgRegistry.getDialect()));
            }
            this.addRule(ruleDescr);
        }
    }

    private void sortRulesByDependency(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        org.drools.core.rule.Package pkg = pkgRegistry.getPackage();
        LinkedList<RuleDescr> roots = new LinkedList<RuleDescr>();
        HashMap<String, List<RuleDescr>> children = new HashMap<String, List<RuleDescr>>();
        LinkedHashMap<String, RuleDescr> sorted = new LinkedHashMap<String, RuleDescr>();
        ArrayList<RuleDescr> queries = new ArrayList<RuleDescr>();
        for (RuleDescr ruleDescr : packageDescr.getRules()) {
            if (ruleDescr.isQuery()) {
                queries.add(ruleDescr);
                continue;
            }
            if (!ruleDescr.hasParent()) {
                roots.add(ruleDescr);
                continue;
            }
            if (pkg.getRule(ruleDescr.getParentName()) != null) {
                sorted.put(ruleDescr.getName(), ruleDescr);
                continue;
            }
            ArrayList<RuleDescr> childz = (ArrayList<RuleDescr>)children.get(ruleDescr.getParentName());
            if (childz == null) {
                childz = new ArrayList<RuleDescr>();
                children.put(ruleDescr.getParentName(), childz);
            }
            childz.add(ruleDescr);
        }
        if (children.isEmpty()) {
            if (!queries.isEmpty()) {
                packageDescr.getRules().removeAll(queries);
                packageDescr.getRules().addAll(0, queries);
            }
            return;
        }
        while (!roots.isEmpty()) {
            RuleDescr root = (RuleDescr)roots.remove(0);
            sorted.put(root.getName(), root);
            List childz = (List)children.remove(root.getName());
            if (childz == null) continue;
            roots.addAll(childz);
        }
        this.reportHierarchyErrors(children, sorted);
        packageDescr.getRules().clear();
        packageDescr.getRules().addAll(queries);
        for (RuleDescr descr : sorted.values()) {
            packageDescr.getRules().add(descr);
        }
    }

    private void reportHierarchyErrors(Map<String, List<RuleDescr>> parents, Map<String, RuleDescr> sorted) {
        boolean circularDep = false;
        for (List<RuleDescr> rds : parents.values()) {
            for (RuleDescr ruleDescr : rds) {
                if (parents.get(ruleDescr.getParentName()) != null && (sorted.containsKey(ruleDescr.getName()) || parents.containsKey(ruleDescr.getName()))) {
                    circularDep = true;
                    this.results.add(new RuleBuildError(new Rule(ruleDescr.getName()), (BaseDescr)ruleDescr, null, "Circular dependency in rules hierarchy"));
                    break;
                }
                this.manageUnresolvedExtension(ruleDescr, sorted.values());
            }
            if (!circularDep) continue;
            break;
        }
    }

    private void manageUnresolvedExtension(RuleDescr ruleDescr, Collection<RuleDescr> candidates) {
        LinkedList<String> candidateRules = new LinkedList<String>();
        for (RuleDescr r : candidates) {
            if (!(StringUtils.stringSimilarity((String)ruleDescr.getParentName(), (String)r.getName(), (StringUtils.SIMILARITY_STRATS)StringUtils.SIMILARITY_STRATS.DICE) >= 0.75)) continue;
            candidateRules.add(r.getName());
        }
        String msg = "Unresolved parent name " + ruleDescr.getParentName();
        if (candidateRules.size() > 0) {
            msg = msg + " >> did you mean any of :" + candidateRules;
        }
        this.results.add(new RuleBuildError(new Rule(ruleDescr.getName()), (BaseDescr)ruleDescr, (Object)msg, "Unable to resolve parent rule, please check that both rules are in the same package"));
    }

    private void initPackage(PackageDescr packageDescr) {
        List<PackageDescr> packageDescrsForPackage = this.packages.get(packageDescr.getName());
        if (packageDescrsForPackage == null) {
            packageDescrsForPackage = new ArrayList<PackageDescr>();
            this.packages.put(packageDescr.getName(), packageDescrsForPackage);
        }
        packageDescrsForPackage.add(packageDescr);
        HashSet<ImportDescr> imports = new HashSet<ImportDescr>();
        for (PackageDescr pd : packageDescrsForPackage) {
            imports.addAll(pd.getImports());
        }
        for (PackageDescr pd : packageDescrsForPackage) {
            pd.getImports().clear();
            pd.addAllImports(imports);
        }
        if (!packageDescr.getAttributes().isEmpty()) {
            Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
            if (pkgAttributes == null) {
                pkgAttributes = new HashMap<String, AttributeDescr>();
                this.packageAttributes.put(packageDescr.getNamespace(), pkgAttributes);
            }
            for (AttributeDescr attr : packageDescr.getAttributes()) {
                pkgAttributes.put(attr.getName(), attr);
            }
        }
    }

    private String getPackageDialect(PackageDescr packageDescr) {
        String dialectName = this.defaultDialect;
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        return dialectName;
    }

    private boolean checkNamespace(String newName) {
        if (this.configuration == null) {
            return true;
        }
        if (!this.pkgRegistryMap.isEmpty() && !this.pkgRegistryMap.containsKey(newName)) {
            return this.configuration.isAllowMultipleNamespaces();
        }
        return true;
    }

    public boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void updateResults() {
        this.updateResults(this.results);
    }

    public void updateResults(List<KnowledgeBuilderResult> results) {
        this.results = this.getResults(results);
    }

    public void compileAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.compileAll();
        }
    }

    public void reloadAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
        }
    }

    private List<KnowledgeBuilderResult> getResults(List<KnowledgeBuilderResult> results) {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            results = pkgRegistry.getDialectCompiletimeRegistry().addResults(results);
        }
        return results;
    }

    public synchronized void addPackage(org.drools.core.rule.Package newPkg) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(newPkg.getName());
        org.drools.core.rule.Package pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (pkg == null) {
            PackageDescr packageDescr = new PackageDescr(newPkg.getName());
            pkgRegistry = this.newPackage(packageDescr);
            this.mergePackage(this.pkgRegistryMap.get(packageDescr.getNamespace()), packageDescr);
            pkg = pkgRegistry.getPackage();
        }
        pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
        if (newPkg.getFunctions() != null) {
            for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                if (pkg.getFunctions().containsKey(entry.getKey())) {
                    this.results.add(new DuplicateFunction((Function)entry.getValue(), (KnowledgeBuilderConfiguration)this.configuration));
                }
                pkg.addFunction((Function)entry.getValue());
            }
        }
        pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
        pkg.getDialectRuntimeRegistry().onBeforeExecute();
        TypeDeclaration lastType = null;
        try {
            if (newPkg.getTypeDeclarations() != null) {
                Iterator i$ = newPkg.getTypeDeclarations().values().iterator();
                while (i$.hasNext()) {
                    TypeDeclaration type;
                    lastType = type = (TypeDeclaration)i$.next();
                    type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
        }
        this.mergePackage(pkg, newPkg);
    }

    private void mergePackage(org.drools.core.rule.Package pkg, org.drools.core.rule.Package newPkg) {
        Rule[] newRules;
        Map imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        String lastType = null;
        try {
            if (newPkg.getGlobals() != null && newPkg.getGlobals() != Collections.EMPTY_MAP) {
                Map globals = pkg.getGlobals();
                for (Map.Entry entry : newPkg.getGlobals().entrySet()) {
                    String type;
                    String identifier = (String)entry.getKey();
                    lastType = type = (String)entry.getValue();
                    if (globals.containsKey(identifier) && !((String)globals.get(identifier)).equals(type)) {
                        throw new PackageIntegrationException(pkg);
                    }
                    pkg.addGlobal(identifier, this.rootClassLoader.loadClass(type));
                    this.globals.put(identifier, this.rootClassLoader.loadClass(type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + lastType + "'");
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        for (Rule newRule : newRules = newPkg.getRules()) {
            pkg.addRule(newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map flows = newPkg.getRuleFlows();
            for (Object o : flows.values()) {
                Process flow = (Process)o;
                pkg.addProcess(flow);
            }
        }
    }

    private void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> names = new HashSet<String>();
        PackageRegistry packageRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        org.drools.core.rule.Package pkg = null;
        if (packageRegistry != null) {
            pkg = packageRegistry.getPackage();
        }
        for (RuleDescr rule : packageDescr.getRules()) {
            Rule duplicatedRule;
            this.validateRule(packageDescr, rule);
            String name = rule.getName();
            if (names.contains(name)) {
                this.results.add(new ParserError(rule.getResource(), "Duplicate rule name: " + name, rule.getLine(), rule.getColumn(), packageDescr.getNamespace()));
            }
            if (pkg != null && (duplicatedRule = pkg.getRule(name)) != null) {
                Resource resource = rule.getResource();
                Resource duplicatedResource = duplicatedRule.getResource();
                if (resource == null || duplicatedResource == null || duplicatedResource.getSourcePath() == null || duplicatedResource.getSourcePath().equals(resource.getSourcePath())) {
                    this.results.add(new DuplicateRule(rule, packageDescr, this.configuration));
                } else {
                    this.results.add(new ParserError(rule.getResource(), "Duplicate rule name: " + name, rule.getLine(), rule.getColumn(), packageDescr.getNamespace()));
                }
            }
            names.add(name);
        }
    }

    private void validateRule(PackageDescr packageDescr, RuleDescr rule) {
        if (rule.hasErrors()) {
            for (String error : rule.getErrors()) {
                this.results.add(new ParserError(rule.getResource(), error + " in rule " + rule.getName(), rule.getLine(), rule.getColumn(), packageDescr.getNamespace()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageRegistry newPackage(PackageDescr packageDescr) {
        org.drools.core.rule.Package pkg;
        if (this.ruleBase == null || (pkg = this.ruleBase.getPackage(packageDescr.getName())) == null) {
            pkg = new org.drools.core.rule.Package(packageDescr.getName());
            pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.rootClassLoader));
            if (this.ruleBase != null) {
                this.ruleBase.lock();
                try {
                    this.ruleBase.addPackage(pkg);
                    pkg = this.ruleBase.getPackage(packageDescr.getName());
                }
                finally {
                    this.ruleBase.unlock();
                }
            } else {
                pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
            }
        }
        PackageRegistry pkgRegistry = new PackageRegistry(this, pkg);
        pkgRegistry.addImport(new ImportDescr(packageDescr.getNamespace() + ".*"));
        this.pkgRegistryMap.put(packageDescr.getName(), pkgRegistry);
        return pkgRegistry;
    }

    private void mergePackage(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (ImportDescr importDescr : packageDescr.getImports()) {
            pkgRegistry.addImport(importDescr);
        }
        this.processEntryPointDeclarations(pkgRegistry, packageDescr);
        this.processUnresolvedTypes(pkgRegistry, this.processTypeDeclarations(pkgRegistry, packageDescr, new ArrayList<TypeDefinition>()));
        this.processOtherDeclarations(pkgRegistry, packageDescr);
    }

    void processOtherDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        this.processWindowDeclarations(pkgRegistry, packageDescr);
        this.processFunctions(pkgRegistry, packageDescr);
        this.processGlobals(pkgRegistry, packageDescr);
        org.drools.core.rule.Package current = this.getPackage();
        this.pkgRegistryMap.remove(packageDescr.getName());
        this.pkgRegistryMap.put(packageDescr.getName(), pkgRegistry);
        if (!current.getName().equals(packageDescr.getName())) {
            this.currentRulePackage = this.pkgRegistryMap.size() - 1;
        }
    }

    private void processGlobals(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (GlobalDescr global : packageDescr.getGlobals()) {
            String identifier = global.getIdentifier();
            String className = global.getType();
            while (className.indexOf(60) >= 0) {
                className = className.replaceAll("<[^<>]+?>", "");
            }
            try {
                Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
                pkgRegistry.getPackage().addGlobal(identifier, clazz);
                this.globals.put(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new GlobalError(global));
                e.printStackTrace();
            }
        }
    }

    private void processFunctions(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (FunctionDescr function : packageDescr.getFunctions()) {
            Function existingFunc = (Function)pkgRegistry.getPackage().getFunctions().get(function.getName());
            if (existingFunc == null || !function.getNamespace().equals(existingFunc.getNamespace())) continue;
            this.results.add(new DuplicateFunction(function, (KnowledgeBuilderConfiguration)this.configuration));
        }
        for (FunctionImportDescr functionImport : packageDescr.getFunctionImports()) {
            String importEntry = functionImport.getTarget();
            pkgRegistry.addStaticImport(functionImport);
            pkgRegistry.getPackage().addStaticImport(importEntry);
        }
    }

    void processUnresolvedTypes(PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions) {
        if (unresolvedTypeDefinitions != null) {
            for (TypeDefinition typeDef : unresolvedTypeDefinitions) {
                this.processUnresolvedType(pkgRegistry, typeDef);
            }
        }
    }

    void processUnresolvedType(PackageRegistry pkgRegistry, TypeDefinition unresolvedTypeDefinition) {
        this.processTypeFields(pkgRegistry, unresolvedTypeDefinition.typeDescr, unresolvedTypeDefinition.type, false);
    }

    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.getCachedTypeDeclaration(cls);
        if (typeDeclaration != null) {
            this.registerTypeDeclaration(packageName, typeDeclaration);
            return typeDeclaration;
        }
        typeDeclaration = this.getExistingTypeDeclaration(cls);
        if (typeDeclaration != null) {
            this.initTypeDeclaration(cls, typeDeclaration);
            return typeDeclaration;
        }
        typeDeclaration = this.createTypeDeclarationForBean(cls);
        this.initTypeDeclaration(cls, typeDeclaration);
        this.registerTypeDeclaration(packageName, typeDeclaration);
        return typeDeclaration;
    }

    private void registerTypeDeclaration(String packageName, TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION || packageName.equals(typeDeclaration.getTypeClass().getPackage().getName())) {
            PackageRegistry packageRegistry = this.pkgRegistryMap.get(packageName);
            if (packageRegistry != null) {
                packageRegistry.getPackage().addTypeDeclaration(typeDeclaration);
            } else {
                this.newPackage(new PackageDescr(packageName, ""));
                this.pkgRegistryMap.get(packageName).getPackage().addTypeDeclaration(typeDeclaration);
            }
        }
    }

    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        if (cls.isPrimitive() || cls.isArray()) {
            return null;
        }
        TypeDeclaration tdecl = this.getCachedTypeDeclaration(cls);
        return tdecl != null ? tdecl : this.createTypeDeclaration(cls);
    }

    private TypeDeclaration createTypeDeclaration(Class<?> cls) {
        TypeDeclaration typeDeclaration = this.getExistingTypeDeclaration(cls);
        if (typeDeclaration == null) {
            typeDeclaration = this.createTypeDeclarationForBean(cls);
        }
        this.initTypeDeclaration(cls, typeDeclaration);
        return typeDeclaration;
    }

    private TypeDeclaration getCachedTypeDeclaration(Class<?> cls) {
        if (this.cacheTypes == null) {
            this.cacheTypes = new HashMap<String, TypeDeclaration>();
            return null;
        }
        return this.cacheTypes.get(cls.getName());
    }

    private TypeDeclaration getExistingTypeDeclaration(Class<?> cls) {
        PackageRegistry pkgReg;
        TypeDeclaration typeDeclaration = this.builtinTypes.get(cls.getName());
        if (typeDeclaration == null && (pkgReg = this.pkgRegistryMap.get(ClassUtils.getPackage(cls))) != null) {
            String className = cls.getName();
            String typeName = className.substring(className.lastIndexOf(".") + 1);
            typeDeclaration = pkgReg.getPackage().getTypeDeclaration(typeName);
        }
        return typeDeclaration;
    }

    private void initTypeDeclaration(Class<?> cls, TypeDeclaration typeDeclaration) {
        ClassDefinition clsDef = typeDeclaration.getTypeClassDef();
        if (clsDef == null) {
            clsDef = new ClassDefinition();
            typeDeclaration.setTypeClassDef(clsDef);
        }
        if (typeDeclaration.isPropertyReactive()) {
            this.processModifiedProps(cls, clsDef);
        }
        this.processFieldsPosition(cls, clsDef);
        LinkedHashSet<TypeDeclaration> tdecls = new LinkedHashSet<TypeDeclaration>();
        tdecls.add(typeDeclaration);
        this.buildTypeDeclarations(cls, tdecls);
        TypeDeclaration[] tarray = tdecls.toArray(new TypeDeclaration[tdecls.size()]);
        for (int i = tarray.length - 1; i >= 0; --i) {
            TypeDeclaration currentTDecl = tarray[i];
            if (!BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)1L) && BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)1L)) {
                typeDeclaration.setRole(currentTDecl.getRole());
            }
            if (!BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)4L) && BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)4L)) {
                typeDeclaration.setFormat(currentTDecl.getFormat());
            }
            if (BitMaskUtil.isSet((long)typeDeclaration.getSetMask(), (long)2L) || !BitMaskUtil.isSet((long)currentTDecl.getSetMask(), (long)2L)) continue;
            typeDeclaration.setTypesafe(currentTDecl.isTypesafe());
        }
        this.cacheTypes.put(cls.getName(), typeDeclaration);
    }

    private TypeDeclaration createTypeDeclarationForBean(Class<?> cls) {
        TypeDeclaration typeDeclaration = new TypeDeclaration(cls);
        PropertySpecificOption propertySpecificOption = this.configuration.getOption(PropertySpecificOption.class);
        boolean propertyReactive = propertySpecificOption.isPropSpecific(cls.isAnnotationPresent(PropertyReactive.class), cls.isAnnotationPresent(ClassReactive.class));
        this.setPropertyReactive(null, typeDeclaration, propertyReactive);
        Role role = cls.getAnnotation(Role.class);
        if (role != null && role.value() == Role.Type.EVENT) {
            typeDeclaration.setRole(TypeDeclaration.Role.EVENT);
        }
        return typeDeclaration;
    }

    private void processModifiedProps(Class<?> cls, ClassDefinition clsDef) {
        for (Method method : cls.getDeclaredMethods()) {
            Modifies modifies = method.getAnnotation(Modifies.class);
            if (modifies == null) continue;
            String[] props = modifies.value();
            ArrayList<String> properties = new ArrayList<String>(props.length);
            for (String prop : props) {
                properties.add(prop.trim());
            }
            clsDef.addModifiedPropsByMethod(method, properties);
        }
    }

    private void processFieldsPosition(Class<?> cls, ClassDefinition clsDef) {
        LinkedList fields = new LinkedList();
        for (Class<?> tempKlass = cls; tempKlass != null && tempKlass != Object.class; tempKlass = tempKlass.getSuperclass()) {
            Collections.addAll(fields, tempKlass.getDeclaredFields());
        }
        ArrayList<FieldDefinition> orderedFields = new ArrayList<FieldDefinition>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            orderedFields.add(null);
        }
        for (Field field : fields) {
            Position pos = field.getAnnotation(Position.class);
            if (pos == null) continue;
            FieldDefinition fldDef = clsDef.getField(field.getName());
            if (fldDef == null) {
                fldDef = new FieldDefinition(field.getName(), field.getType().getName());
            }
            fldDef.setIndex(pos.value());
            orderedFields.set(pos.value(), fldDef);
        }
        for (FieldDefinition fieldDefinition : orderedFields) {
            if (fieldDefinition == null) continue;
            clsDef.addField(fieldDefinition);
        }
    }

    public void buildTypeDeclarations(Class<?> cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            this.buildTypeDeclarationInterfaces(intf, tdecls);
        }
        for (cls = cls.getSuperclass(); cls != null && cls != Object.class && this.buildTypeDeclarationInterfaces(cls, tdecls); cls = cls.getSuperclass()) {
        }
    }

    public boolean buildTypeDeclarationInterfaces(Class cls, Set<TypeDeclaration> tdecls) {
        Class<?>[] intfs;
        PackageRegistry pkgReg;
        TypeDeclaration tdecl = this.builtinTypes.get(cls.getName());
        if (tdecl == null && (pkgReg = this.pkgRegistryMap.get(ClassUtils.getPackage((Class)cls))) != null) {
            tdecl = pkgReg.getPackage().getTypeDeclaration(cls.getSimpleName());
        }
        if (tdecl != null && !tdecls.add(tdecl)) {
            return false;
        }
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            pkgReg = this.pkgRegistryMap.get(ClassUtils.getPackage(intf));
            if (pkgReg != null) {
                tdecl = pkgReg.getPackage().getTypeDeclaration(intf.getSimpleName());
            }
            if (tdecl == null) continue;
            tdecls.add(tdecl);
        }
        for (Class<?> intf : intfs) {
            if (this.buildTypeDeclarationInterfaces(intf, tdecls)) continue;
            return false;
        }
        return true;
    }

    private String resolveType(String sup, PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        for (ImportDescr id : packageDescr.getImports()) {
            if (!id.getTarget().endsWith("." + sup)) continue;
            return id.getTarget();
        }
        if (pkgRegistry != null) {
            for (String declaredName : pkgRegistry.getPackage().getTypeDeclarations().keySet()) {
                if (!declaredName.equals(sup)) continue;
                sup = pkgRegistry.getPackage().getTypeDeclaration(declaredName).getTypeClass().getName();
            }
        }
        if (sup != null && !sup.contains(".") && packageDescr.getNamespace() != null && !packageDescr.getNamespace().isEmpty()) {
            for (AbstractClassTypeDeclarationDescr td : packageDescr.getClassAndEnumDeclarationDescrs()) {
                if (!sup.equals(td.getTypeName())) continue;
                sup = packageDescr.getNamespace() + "." + sup;
            }
        }
        return sup;
    }

    private void fillSuperType(TypeDeclarationDescr typeDescr, PackageDescr packageDescr) {
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            int separator;
            boolean qualified;
            String declaredSuperType = qname.getFullName();
            if (declaredSuperType == null || (qualified = (separator = declaredSuperType.lastIndexOf(".")) > 0)) continue;
            declaredSuperType = this.resolveType(declaredSuperType, packageDescr, this.pkgRegistryMap.get(typeDescr.getNamespace()));
            separator = (declaredSuperType = this.typeName2ClassName(declaredSuperType)).lastIndexOf(".");
            if (separator < 0) {
                this.results.add(new TypeDeclarationError(typeDescr, "Cannot resolve supertype '" + declaredSuperType + "'"));
                qname.setName(null);
                qname.setNamespace(null);
                continue;
            }
            qname.setName(declaredSuperType.substring(separator + 1));
            qname.setNamespace(declaredSuperType.substring(0, separator));
        }
    }

    private String typeName2ClassName(String type) {
        Class<?> cls = this.getClassForType(type);
        return cls != null ? cls.getName() : type;
    }

    private Class<?> getClassForType(String type) {
        Class<?> cls = null;
        String superType = type;
        while (true) {
            try {
                cls = Class.forName(superType, true, this.rootClassLoader);
            }
            catch (ClassNotFoundException e) {
                int separator = superType.lastIndexOf(46);
                if (separator < 0) break;
                superType = superType.substring(0, separator) + "$" + superType.substring(separator + 1);
                continue;
            }
            break;
        }
        return cls;
    }

    private void fillFieldTypes(AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr) {
        for (TypeFieldDescr field : typeDescr.getFields().values()) {
            int separator;
            boolean qualified;
            String declaredType = field.getPattern().getObjectType();
            if (declaredType == null || (qualified = (separator = declaredType.lastIndexOf(".")) > 0)) continue;
            declaredType = this.resolveType(declaredType, packageDescr, this.pkgRegistryMap.get(typeDescr.getNamespace()));
            field.getPattern().setObjectType(declaredType);
        }
    }

    private boolean mergeInheritedFields(TypeDeclarationDescr typeDescr) {
        if (typeDescr.getSuperTypes().isEmpty()) {
            return false;
        }
        boolean merge = false;
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            String simpleSuperTypeName = qname.getName();
            String superTypePackageName = qname.getNamespace();
            String fullSuper = qname.getFullName();
            merge = merge || this.mergeInheritedFields(simpleSuperTypeName, superTypePackageName, fullSuper, typeDescr);
        }
        return merge;
    }

    private boolean mergeInheritedFields(String simpleSuperTypeName, String superTypePackageName, String fullSuper, TypeDeclarationDescr typeDescr) {
        TypeFieldDescr inheritedFlDescr;
        LinkedHashMap<String, TypeFieldDescr> fieldMap = new LinkedHashMap<String, TypeFieldDescr>();
        PackageRegistry registry = this.pkgRegistryMap.get(superTypePackageName);
        if (registry == null) {
            this.results.add(new TypeDeclarationError(typeDescr, "Cannot extend supertype '" + fullSuper + "' (not a declared type)"));
            typeDescr.setType(null, null);
            return false;
        }
        org.drools.core.rule.Package pack = registry.getPackage();
        boolean isSuperClassTagged = false;
        boolean isSuperClassDeclared = true;
        if (pack != null) {
            TypeDeclaration superTypeDeclaration = pack.getTypeDeclaration(simpleSuperTypeName);
            if (superTypeDeclaration != null) {
                ClassDefinition classDef = superTypeDeclaration.getTypeClassDef();
                for (FactField fld : classDef.getFields()) {
                    inheritedFlDescr = this.buildInheritedFieldDescrFromDefinition(fld);
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
                isSuperClassTagged = !superTypeDeclaration.isNovel();
            } else {
                isSuperClassDeclared = false;
            }
        } else {
            isSuperClassDeclared = false;
        }
        if (!isSuperClassDeclared || isSuperClassTagged) {
            try {
                Class superKlass = registry.getTypeResolver().resolveType(fullSuper);
                ClassFieldInspector inspector = new ClassFieldInspector(superKlass);
                for (String name : inspector.getGetterMethods().keySet()) {
                    if (!inspector.getSetterMethods().containsKey(name) || inspector.isNonGetter(name) || "class".equals(name)) continue;
                    inheritedFlDescr = new TypeFieldDescr(name, new PatternDescr(((Class)inspector.getFieldTypes().get(name)).getName()));
                    inheritedFlDescr.setInherited(!Modifier.isAbstract(((Method)inspector.getGetterMethods().get(name)).getModifiers()));
                    inheritedFlDescr.setIndex(inspector.getFieldNames().size() + (Integer)inspector.getFieldNames().get(name));
                    if (fieldMap.containsKey(inheritedFlDescr.getFieldName())) continue;
                    fieldMap.put(inheritedFlDescr.getFieldName(), inheritedFlDescr);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeDroolsException("Unable to resolve Type Declaration superclass '" + fullSuper + "'");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (String fieldName : typeDescr.getFields().keySet()) {
            if (fieldMap.containsKey(fieldName)) {
                String type1 = ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().getObjectType();
                String type2 = typeDescr.getFields().get(fieldName).getPattern().getObjectType();
                if (type2.lastIndexOf(".") < 0) {
                    try {
                        TypeResolver typeResolver = this.pkgRegistryMap.get(pack.getName()).getTypeResolver();
                        type1 = typeResolver.resolveType(type1).getName();
                        type2 = typeResolver.resolveType(type2).getName();
                        ((TypeFieldDescr)fieldMap.get(fieldName)).getPattern().setObjectType(type1);
                        typeDescr.getFields().get(fieldName).getPattern().setObjectType(type2);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                if (!type1.equals(type2)) {
                    this.results.add(new TypeDeclarationError(typeDescr, "Cannot redeclare field '" + fieldName + " from " + type1 + " to " + type2));
                    typeDescr.setType(null, null);
                    return false;
                }
                String initVal = ((TypeFieldDescr)fieldMap.get(fieldName)).getInitExpr();
                if (typeDescr.getFields().get(fieldName).getInitExpr() == null) {
                    typeDescr.getFields().get(fieldName).setInitExpr(initVal);
                }
                typeDescr.getFields().get(fieldName).setInherited(((TypeFieldDescr)fieldMap.get(fieldName)).isInherited());
                for (String key : ((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotationNames()) {
                    if (typeDescr.getFields().get(fieldName).getAnnotation(key) != null) continue;
                    typeDescr.getFields().get(fieldName).addAnnotation(((TypeFieldDescr)fieldMap.get(fieldName)).getAnnotation(key));
                }
                if (typeDescr.getFields().get(fieldName).getIndex() < 0) {
                    typeDescr.getFields().get(fieldName).setIndex(((TypeFieldDescr)fieldMap.get(fieldName)).getIndex());
                }
            }
            fieldMap.put(fieldName, typeDescr.getFields().get(fieldName));
        }
        typeDescr.setFields(fieldMap);
        return true;
    }

    protected TypeFieldDescr buildInheritedFieldDescrFromDefinition(FactField fld) {
        PatternDescr fldType = new PatternDescr();
        TypeFieldDescr inheritedFldDescr = new TypeFieldDescr();
        inheritedFldDescr.setFieldName(fld.getName());
        fldType.setObjectType(((FieldDefinition)fld).getFieldAccessor().getExtractToClassName());
        inheritedFldDescr.setPattern(fldType);
        if (fld.isKey()) {
            inheritedFldDescr.getAnnotations().put("key", new AnnotationDescr("key"));
        }
        inheritedFldDescr.setIndex(fld.getIndex());
        inheritedFldDescr.setInherited(true);
        inheritedFldDescr.setInitExpr(((FieldDefinition)fld).getInitExpr());
        return inheritedFldDescr;
    }

    void processEntryPointDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (EntryPointDeclarationDescr epDescr : packageDescr.getEntryPointDeclarations()) {
            pkgRegistry.getPackage().addEntryPointId(epDescr.getEntryPointId());
        }
    }

    private void processWindowDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        for (WindowDeclarationDescr wd : packageDescr.getWindowDeclarations()) {
            WindowDeclaration window = new WindowDeclaration(wd.getName(), packageDescr.getName());
            org.drools.core.rule.Package pkg = pkgRegistry.getPackage();
            DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
            RuleDescr dummy = new RuleDescr(wd.getName() + " Window Declaration");
            dummy.addAttribute(new AttributeDescr("dialect", "java"));
            RuleBuildContext context = new RuleBuildContext(this, dummy, ctr, pkg, ctr.getDialect(pkgRegistry.getDialect()));
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(wd.getPattern().getClass());
            if (builder == null) {
                throw new RuntimeDroolsException("BUG: builder not found for descriptor class " + wd.getPattern().getClass());
            }
            Pattern pattern = (Pattern)builder.build(context, wd.getPattern(), null);
            window.setPattern(pattern);
            if (!context.getErrors().isEmpty()) {
                for (DroolsError error : context.getErrors()) {
                    this.results.add(error);
                }
                continue;
            }
            pkgRegistry.getPackage().addWindowDeclaration(window);
        }
    }

    void registerGeneratedType(AbstractClassTypeDeclarationDescr typeDescr) {
        String fullName = typeDescr.getType().getFullName();
        this.generatedTypes.add(fullName);
    }

    List<TypeDefinition> processTypeDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr, List<TypeDefinition> unresolvedTypes) {
        for (AbstractClassTypeDeclarationDescr typeDescr : packageDescr.getClassAndEnumDeclarationDescrs()) {
            PackageRegistry pkgReg;
            String className;
            int dotPos;
            String qName = typeDescr.getType().getFullName();
            Class<?> typeClass = this.getClassForType(qName);
            if (typeClass == null) {
                typeClass = this.getClassForType(typeDescr.getTypeName());
            }
            if (typeClass == null) {
                for (ImportDescr id : packageDescr.getImports()) {
                    int separator;
                    String imp = id.getTarget();
                    String tail = imp.substring((separator = imp.lastIndexOf(46)) + 1);
                    if (tail.equals(typeDescr.getTypeName())) {
                        typeDescr.setNamespace(imp.substring(0, separator));
                        typeClass = this.getClassForType(typeDescr.getType().getFullName());
                        break;
                    }
                    if (!tail.equals("*") || (typeClass = this.getClassForType(imp.substring(0, imp.length() - 1) + typeDescr.getType().getName())) == null) continue;
                    typeDescr.setNamespace(imp.substring(0, separator));
                    break;
                }
            }
            if ((dotPos = (className = typeClass != null ? typeClass.getName() : qName).lastIndexOf(46)) >= 0) {
                typeDescr.setNamespace(className.substring(0, dotPos));
                typeDescr.setTypeName(className.substring(dotPos + 1));
            }
            if (this.isEmpty(typeDescr.getNamespace()) && typeDescr.getFields().isEmpty() && (pkgReg = this.pkgRegistryMap.get(packageDescr.getName())) != null) {
                try {
                    Class clz = pkgReg.getTypeResolver().resolveType(typeDescr.getTypeName());
                    Package pkg = clz.getPackage();
                    if (pkg != null) {
                        typeDescr.setNamespace(pkg.getName());
                        int index = typeDescr.getNamespace() != null && !typeDescr.getNamespace().isEmpty() ? typeDescr.getNamespace().length() + 1 : 0;
                        typeDescr.setTypeName(clz.getCanonicalName().substring(index));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.isEmpty(typeDescr.getNamespace())) {
                typeDescr.setNamespace(packageDescr.getNamespace());
            }
            if (typeDescr instanceof TypeDeclarationDescr) {
                this.fillSuperType((TypeDeclarationDescr)typeDescr, packageDescr);
            }
            this.fillFieldTypes(typeDescr, packageDescr);
            if (typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            PackageDescr altDescr = new PackageDescr(typeDescr.getNamespace());
            if (typeDescr instanceof TypeDeclarationDescr) {
                altDescr.addTypeDeclaration((TypeDeclarationDescr)typeDescr);
            } else if (typeDescr instanceof EnumDeclarationDescr) {
                altDescr.addEnumDeclaration((EnumDeclarationDescr)typeDescr);
            }
            for (ImportDescr imp : packageDescr.getImports()) {
                altDescr.addImport(imp);
            }
            if (!this.getPackageRegistry().containsKey(altDescr.getNamespace())) {
                this.newPackage(altDescr);
            }
            this.mergePackage(this.pkgRegistryMap.get(altDescr.getNamespace()), altDescr);
        }
        Collection<AbstractClassTypeDeclarationDescr> sortedTypeDescriptors = this.sortByHierarchy(packageDescr.getClassAndEnumDeclarationDescrs());
        for (AbstractClassTypeDeclarationDescr typeDescr : sortedTypeDescriptors) {
            this.registerGeneratedType(typeDescr);
        }
        for (AbstractClassTypeDeclarationDescr typeDescr : sortedTypeDescriptors) {
            String className;
            String kind;
            String format;
            String typesafe;
            AnnotationDescr annotationDescr;
            String role;
            PackageRegistry sup;
            if (!typeDescr.getNamespace().equals(packageDescr.getNamespace())) continue;
            if (typeDescr instanceof TypeDeclarationDescr) {
                TypeDeclarationDescr tDescr = (TypeDeclarationDescr)typeDescr;
                block9: for (QualifiedName qname : tDescr.getSuperTypes()) {
                    if (!this.mergeInheritedFields(tDescr)) continue;
                    for (AbstractClassTypeDeclarationDescr descr : sortedTypeDescriptors) {
                        if (qname.equals(descr.getType())) {
                            typeDescr.getAnnotations().putAll(descr.getAnnotations());
                            continue block9;
                        }
                        if (!typeDescr.getType().equals(descr.getType())) continue;
                        continue block9;
                    }
                }
            }
            TypeDeclaration type = new TypeDeclaration(typeDescr.getTypeName());
            if (typeDescr.getResource() == null) {
                typeDescr.setResource(this.resource);
            }
            type.setResource(typeDescr.getResource());
            TypeDeclaration parent = null;
            if (!typeDescr.getSuperTypes().isEmpty() && (sup = this.pkgRegistryMap.get(typeDescr.getSuperTypeNamespace())) != null && (parent = sup.getPackage().getTypeDeclaration(typeDescr.getSuperTypeName())).getNature() == TypeDeclaration.Nature.DECLARATION && this.ruleBase != null) {
                parent = ((org.drools.core.rule.Package)this.ruleBase.getPackagesMap().get(typeDescr.getSuperTypeNamespace())).getTypeDeclaration(typeDescr.getSuperTypeName());
            }
            String string = role = (annotationDescr = typeDescr.getAnnotation("role")) != null ? annotationDescr.getSingleValue() : null;
            if (role != null) {
                type.setRole(TypeDeclaration.Role.parseRole((String)role));
            } else if (parent != null) {
                type.setRole(parent.getRole());
            }
            annotationDescr = typeDescr.getAnnotation("typesafe");
            String string2 = typesafe = annotationDescr != null ? annotationDescr.getSingleValue() : null;
            if (typesafe != null) {
                type.setTypesafe(Boolean.parseBoolean(typesafe));
            } else if (parent != null) {
                type.setTypesafe(parent.isTypesafe());
            }
            annotationDescr = typeDescr.getAnnotation("format");
            String string3 = format = annotationDescr != null ? annotationDescr.getSingleValue() : null;
            if (format != null) {
                type.setFormat(TypeDeclaration.Format.parseFormat((String)format));
            }
            String string4 = kind = (annotationDescr = typeDescr.getAnnotation("kind")) != null ? annotationDescr.getSingleValue() : null;
            if (kind != null) {
                type.setKind(TypeDeclaration.Kind.parseKind((String)kind));
            }
            if (typeDescr instanceof EnumDeclarationDescr) {
                type.setKind(TypeDeclaration.Kind.ENUM);
            }
            String string5 = className = (annotationDescr = typeDescr.getAnnotation("class")) != null ? annotationDescr.getSingleValue() : null;
            if (StringUtils.isEmpty((CharSequence)className)) {
                className = type.getTypeName();
            }
            try {
                this.generateDeclaredBean(typeDescr, type, pkgRegistry, unresolvedTypes);
                Class clazz = pkgRegistry.getTypeResolver().resolveType(typeDescr.getType().getFullName());
                type.setTypeClass(clazz);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new TypeDeclarationError(typeDescr, "Class '" + className + "' not found for type declaration of '" + type.getTypeName() + "'"));
                continue;
            }
            if (this.processTypeFields(pkgRegistry, typeDescr, type, true)) continue;
            unresolvedTypes.add(new TypeDefinition(type, typeDescr));
        }
        return unresolvedTypes;
    }

    private boolean processTypeFields(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, boolean firstAttempt) {
        String expiration;
        String duration;
        AnnotationDescr annotationDescr;
        String timestamp;
        if (type.getTypeClassDef() != null) {
            try {
                this.buildFieldAccessors(type, pkgRegistry);
            }
            catch (Throwable e) {
                if (!firstAttempt) {
                    this.results.add(new TypeDeclarationError(typeDescr, "Error creating field accessors for TypeDeclaration '" + type.getTypeName() + "' for type '" + type.getTypeName() + "'"));
                }
                return false;
            }
        }
        String string = timestamp = (annotationDescr = typeDescr.getAnnotation("timestamp")) != null ? annotationDescr.getSingleValue() : null;
        if (timestamp != null) {
            MVELAnalysisResult results;
            type.setTimestampAttribute(timestamp);
            org.drools.core.rule.Package pkg = pkgRegistry.getPackage();
            MVELDialect dialect = (MVELDialect)pkgRegistry.getDialectCompiletimeRegistry().getDialect("mvel");
            PackageBuildContext context = new PackageBuildContext();
            context.init(this, pkg, typeDescr, pkgRegistry.getDialectCompiletimeRegistry(), dialect, null);
            if (!type.isTypesafe()) {
                context.setTypesafe(false);
            }
            if ((results = (MVELAnalysisResult)context.getDialect().analyzeExpression(context, typeDescr, timestamp, new BoundIdentifiers(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, type.getTypeClass()))) != null) {
                InternalReadAccessor reader = pkg.getClassFieldAccessorStore().getMVELReader(ClassUtils.getPackage((Class)type.getTypeClass()), type.getTypeClass().getName(), timestamp, type.isTypesafe(), results.getReturnType());
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
                data.addCompileable((MVELCompileable)reader);
                ((MVELCompileable)reader).compile(data);
                type.setTimestampExtractor(reader);
            } else {
                this.results.add(new TypeDeclarationError(typeDescr, "Error creating field accessors for timestamp field '" + timestamp + "' for type '" + type.getTypeName() + "'"));
            }
        }
        String string2 = duration = (annotationDescr = typeDescr.getAnnotation("duration")) != null ? annotationDescr.getSingleValue() : null;
        if (duration != null) {
            MVELAnalysisResult results;
            type.setDurationAttribute(duration);
            org.drools.core.rule.Package pkg = pkgRegistry.getPackage();
            MVELDialect dialect = (MVELDialect)pkgRegistry.getDialectCompiletimeRegistry().getDialect("mvel");
            PackageBuildContext context = new PackageBuildContext();
            context.init(this, pkg, typeDescr, pkgRegistry.getDialectCompiletimeRegistry(), dialect, null);
            if (!type.isTypesafe()) {
                context.setTypesafe(false);
            }
            if ((results = (MVELAnalysisResult)context.getDialect().analyzeExpression(context, typeDescr, duration, new BoundIdentifiers(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, type.getTypeClass()))) != null) {
                InternalReadAccessor reader = pkg.getClassFieldAccessorStore().getMVELReader(ClassUtils.getPackage((Class)type.getTypeClass()), type.getTypeClass().getName(), duration, type.isTypesafe(), results.getReturnType());
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
                data.addCompileable((MVELCompileable)reader);
                ((MVELCompileable)reader).compile(data);
                type.setDurationExtractor(reader);
            } else {
                this.results.add(new TypeDeclarationError(typeDescr, "Error processing @duration for TypeDeclaration '" + type.getFullName() + "': cannot access the field '" + duration + "'"));
            }
        }
        String string3 = expiration = (annotationDescr = typeDescr.getAnnotation("expires")) != null ? annotationDescr.getSingleValue() : null;
        if (expiration != null) {
            if (this.timeParser == null) {
                this.timeParser = new TimeIntervalParser();
            }
            type.setExpirationOffset(this.timeParser.parse(expiration)[0].longValue());
        }
        boolean dynamic = typeDescr.getAnnotationNames().contains("propertyChangeSupport");
        type.setDynamic(dynamic);
        PropertySpecificOption propertySpecificOption = this.configuration.getOption(PropertySpecificOption.class);
        boolean propertyReactive = propertySpecificOption.isPropSpecific(typeDescr.getAnnotationNames().contains("propertyReactive"), typeDescr.getAnnotationNames().contains("classReactive"));
        this.setPropertyReactive(typeDescr.getResource(), type, propertyReactive);
        if (type.isValid()) {
            if (type.getNature() == TypeDeclaration.Nature.DEFINITION) {
                pkgRegistry.getPackage().addTypeDeclaration(type);
            } else {
                TypeDeclaration oldType = pkgRegistry.getPackage().getTypeDeclaration(type.getTypeName());
                if (oldType == null) {
                    pkgRegistry.getPackage().addTypeDeclaration(type);
                } else {
                    if (type.getRole() == TypeDeclaration.Role.EVENT) {
                        oldType.setRole(TypeDeclaration.Role.EVENT);
                    }
                    if (type.isPropertyReactive()) {
                        oldType.setPropertyReactive(true);
                    }
                }
            }
        }
        return true;
    }

    private void setPropertyReactive(Resource resource, TypeDeclaration type, boolean propertyReactive) {
        if (propertyReactive && type.getSettableProperties().size() >= 64) {
            this.results.add(new DisabledPropertyReactiveWarning(resource, type.getTypeName()));
            type.setPropertyReactive(false);
        } else {
            type.setPropertyReactive(propertyReactive);
        }
    }

    private void updateTraitDefinition(TypeDeclaration type, Class concrete) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(concrete);
            Map methods = inspector.getGetterMethods();
            Map setters = inspector.getSetterMethods();
            int j = 0;
            for (String fieldName : methods.keySet()) {
                if ("core".equals(fieldName) || "fields".equals(fieldName) || inspector.isNonGetter(fieldName) || !setters.keySet().contains(fieldName)) continue;
                Class<?> ret = ((Method)methods.get(fieldName)).getReturnType();
                FieldDefinition field = new FieldDefinition();
                field.setName(fieldName);
                field.setTypeName(ret.getName());
                field.setIndex(j++);
                type.getTypeClassDef().addField(field);
            }
            HashSet<String> interfaces = new HashSet<String>();
            Collections.addAll(interfaces, type.getTypeClassDef().getInterfaces());
            for (Class<?> iKlass : concrete.getInterfaces()) {
                interfaces.add(iKlass.getName());
            }
            type.getTypeClassDef().setInterfaces(interfaces.toArray(new String[interfaces.size()]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isNovelClass(AbstractClassTypeDeclarationDescr typeDescr) {
        return this.getExistingDeclarationClass(typeDescr) == null;
    }

    private Class<?> getExistingDeclarationClass(AbstractClassTypeDeclarationDescr typeDescr) {
        PackageRegistry reg = this.pkgRegistryMap.get(typeDescr.getNamespace());
        if (reg == null) {
            return null;
        }
        String availableName = typeDescr.getType().getFullName();
        try {
            return reg.getTypeResolver().resolveType(availableName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Class resolveAnnotation(String annotation, TypeResolver resolver) {
        if ("format".equals(annotation)) {
            return null;
        }
        if ("class".equals(annotation)) {
            return null;
        }
        try {
            return resolver.resolveType(annotation.substring(0, 1).toUpperCase() + annotation.substring(1));
        }
        catch (ClassNotFoundException e) {
            if ("role".equals(annotation)) {
                return Role.class;
            }
            if ("key".equals(annotation)) {
                return Key.class;
            }
            if ("position".equals(annotation)) {
                return Position.class;
            }
            return null;
        }
    }

    private void buildFieldAccessors(TypeDeclaration type, PackageRegistry pkgRegistry) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, IOException, IntrospectionException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        ClassDefinition cd = type.getTypeClassDef();
        ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
        for (FieldDefinition attrDef : cd.getFieldsDefinitions()) {
            ClassFieldAccessor accessor = store.getAccessor(cd.getDefinedClass().getName(), attrDef.getName());
            attrDef.setReadWriteAccessor(accessor);
        }
    }

    private void generateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, List<TypeDefinition> unresolvedTypeDefinitions) {
        Class<?> existingDeclarationClass;
        ClassDefinition def;
        String fullName = typeDescr.getType().getFullName();
        if (type.getKind().equals((Object)TypeDeclaration.Kind.CLASS)) {
            TypeDeclarationDescr tdescr = (TypeDeclarationDescr)typeDescr;
            if (tdescr.getSuperTypes().size() > 1) {
                this.results.add(new TypeDeclarationError(typeDescr, "Declared class " + fullName + "  - has more than one supertype;"));
                return;
            }
            if (tdescr.getSuperTypes().isEmpty()) {
                tdescr.addSuperType("java.lang.Object");
            }
        }
        boolean traitable = typeDescr.getAnnotation(Traitable.class.getSimpleName()) != null;
        String[] fullSuperTypes = new String[typeDescr.getSuperTypes().size() + 1];
        int j = 0;
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            fullSuperTypes[j++] = qname.getFullName();
        }
        fullSuperTypes[j] = Thing.class.getName();
        ArrayList<String> interfaceList = new ArrayList<String>();
        interfaceList.add(traitable ? Externalizable.class.getName() : Serializable.class.getName());
        if (traitable) {
            interfaceList.add(TraitableBean.class.getName());
        }
        String[] interfaces = interfaceList.toArray(new String[interfaceList.size()]);
        switch (type.getKind()) {
            case TRAIT: {
                def = new ClassDefinition(fullName, "java.lang.Object", fullSuperTypes);
                break;
            }
            case ENUM: {
                def = new EnumClassDefinition(fullName, fullSuperTypes[0], null);
                break;
            }
            default: {
                def = new ClassDefinition(fullName, fullSuperTypes[0], interfaces);
                def.setTraitable(traitable);
            }
        }
        for (String annotationName : typeDescr.getAnnotationNames()) {
            Class annotation = this.resolveAnnotation(annotationName, pkgRegistry.getTypeResolver());
            if (annotation != null) {
                try {
                    AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)annotation, typeDescr.getAnnotations().get(annotationName).getValueMap(), (TypeResolver)pkgRegistry.getTypeResolver());
                    def.addAnnotation(annotationDefinition);
                }
                catch (NoSuchMethodException nsme) {
                    this.results.add(new TypeDeclarationError(typeDescr, "Annotated type " + fullName + "  - undefined property in @annotation " + annotationName + ": " + nsme.getMessage() + ";"));
                }
            }
            if (annotation != null && annotation != Role.class) continue;
            def.addMetaData(annotationName, (Object)typeDescr.getAnnotation(annotationName).getSingleValue());
        }
        if (type.getKind() == TypeDeclaration.Kind.ENUM) {
            for (EnumLiteralDescr lit : ((EnumDeclarationDescr)typeDescr).getLiterals()) {
                ((EnumClassDefinition)def).addLiteral(new EnumLiteralDefinition(lit.getName(), lit.getConstructorArgs()));
            }
        }
        if (!typeDescr.getFields().isEmpty()) {
            PriorityQueue<FieldDefinition> fieldDefs = this.sortFields(typeDescr.getFields(), pkgRegistry);
            while (!fieldDefs.isEmpty()) {
                FieldDefinition fld = fieldDefs.poll();
                if (unresolvedTypeDefinitions != null) {
                    for (TypeDefinition typeDef : unresolvedTypeDefinitions) {
                        if (!fld.getTypeName().equals(typeDef.getTypeClassName())) continue;
                        fld.setRecursive(true);
                        break;
                    }
                }
                def.addField(fld);
            }
        }
        type.setNovel((existingDeclarationClass = this.getExistingDeclarationClass(typeDescr)) == null);
        type.setTypeClassDef(def);
        if (!type.isNovel()) {
            TypeDeclaration previousTypeDeclaration = this.pkgRegistryMap.get(typeDescr.getNamespace()).getPackage().getTypeDeclaration(typeDescr.getTypeName());
            try {
                if (!type.getTypeClassDef().getFields().isEmpty()) {
                    type.setNature(TypeDeclaration.Nature.DEFINITION);
                } else {
                    type.setNature(TypeDeclaration.Nature.DECLARATION);
                }
                if (previousTypeDeclaration == null) {
                    if (!(this.configuration.isPreCompiled() || GeneratedFact.class.isAssignableFrom(existingDeclarationClass) || type.getTypeClassDef().getFields().isEmpty())) {
                        type.setValid(false);
                        this.results.add(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " can't declare new fields"));
                    }
                } else {
                    int typeComparisonResult = this.compareTypeDeclarations(previousTypeDeclaration, type);
                    if (typeComparisonResult < 0) {
                        this.results.add(new TypeDeclarationError(typeDescr, typeDescr.getType().getFullName() + " declares more fields than the already existing version"));
                        type.setValid(false);
                    } else if (typeComparisonResult > 0 && !type.getTypeClassDef().getFields().isEmpty()) {
                        this.results.add(new TypeDeclarationError(typeDescr, typeDescr.getType().getFullName() + " declares less fields than the already existing version"));
                        type.setValid(false);
                    }
                    if (type.getNature() == TypeDeclaration.Nature.DECLARATION) {
                        this.mergeTypeDeclarations(previousTypeDeclaration, type);
                    }
                }
            }
            catch (IncompatibleClassChangeError error) {
                this.results.add(new TypeDeclarationError(typeDescr, error.getMessage()));
            }
        } else {
            type.setNature(TypeDeclaration.Nature.DEFINITION);
        }
        this.generateDeclaredBean(typeDescr, type, pkgRegistry, this.expandImportsInFieldInitExpr(def, pkgRegistry));
    }

    private ClassDefinition expandImportsInFieldInitExpr(ClassDefinition def, PackageRegistry pkgRegistry) {
        TypeResolver typeResolver = pkgRegistry.getPackage().getTypeResolver();
        for (FieldDefinition field : def.getFieldsDefinitions()) {
            field.setInitExpr(this.rewriteInitExprWithImports(field.getInitExpr(), typeResolver));
        }
        return def;
    }

    private String rewriteInitExprWithImports(String expr, TypeResolver typeResolver) {
        if (expr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        boolean inTypeName = false;
        boolean afterDot = false;
        int typeStart = 0;
        for (int i = 0; i < expr.length(); ++i) {
            char ch = expr.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                if (!(inTypeName || inQuotes || afterDot)) {
                    typeStart = i;
                    inTypeName = true;
                }
            } else if (!Character.isJavaIdentifierPart(ch)) {
                if (ch == '\"') {
                    inQuotes = !inQuotes;
                } else if (ch == '.' && !inQuotes) {
                    afterDot = true;
                } else if (!Character.isSpaceChar(ch)) {
                    afterDot = false;
                }
                if (inTypeName) {
                    inTypeName = false;
                    String type = expr.substring(typeStart, i);
                    sb.append(this.getFullTypeName(type, typeResolver));
                }
            }
            if (inTypeName) continue;
            sb.append(ch);
        }
        if (inTypeName) {
            String type = expr.substring(typeStart);
            sb.append(this.getFullTypeName(type, typeResolver));
        }
        return sb.toString();
    }

    private String getFullTypeName(String type, TypeResolver typeResolver) {
        if (type.equals("new")) {
            return type;
        }
        try {
            return typeResolver.getFullTypeName(type);
        }
        catch (ClassNotFoundException e) {
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDeclaredBean(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry, ClassDefinition def) {
        block30: {
            Class resolvedType;
            String availableName;
            PackageRegistry reg;
            if (typeDescr.getAnnotation(Traitable.class.getSimpleName()) != null || !type.getKind().equals((Object)TypeDeclaration.Kind.TRAIT) && this.pkgRegistryMap.containsKey(def.getSuperClass()) && this.pkgRegistryMap.get(def.getSuperClass()).getTraitRegistry().getTraitables().containsKey(def.getSuperClass())) {
                if (!this.isNovelClass(typeDescr)) {
                    try {
                        reg = this.pkgRegistryMap.get(typeDescr.getNamespace());
                        availableName = typeDescr.getType().getFullName();
                        resolvedType = reg.getTypeResolver().resolveType(availableName);
                        this.updateTraitDefinition(type, resolvedType);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                pkgRegistry.getTraitRegistry().addTraitable(def);
            } else if (type.getKind().equals((Object)TypeDeclaration.Kind.TRAIT) || typeDescr.getAnnotation(Trait.class.getSimpleName()) != null) {
                if (!type.isNovel()) {
                    try {
                        reg = this.pkgRegistryMap.get(typeDescr.getNamespace());
                        availableName = typeDescr.getType().getFullName();
                        resolvedType = reg.getTypeResolver().resolveType(availableName);
                        if (!Thing.class.isAssignableFrom(resolvedType)) {
                            this.updateTraitDefinition(type, resolvedType);
                            String target = typeDescr.getTypeName() + "_Trait__Extension";
                            TypeDeclarationDescr tempDescr = new TypeDeclarationDescr();
                            tempDescr.setNamespace(typeDescr.getNamespace());
                            tempDescr.setFields(typeDescr.getFields());
                            tempDescr.setType(target, typeDescr.getNamespace());
                            tempDescr.addSuperType(typeDescr.getType());
                            TypeDeclaration tempDeclr = new TypeDeclaration(target);
                            tempDeclr.setKind(TypeDeclaration.Kind.TRAIT);
                            tempDeclr.setTypesafe(type.isTypesafe());
                            tempDeclr.setNovel(true);
                            tempDeclr.setTypeClassName(tempDescr.getType().getFullName());
                            tempDeclr.setResource(type.getResource());
                            ClassDefinition tempDef = new ClassDefinition(target);
                            tempDef.setClassName(tempDescr.getType().getFullName());
                            tempDef.setTraitable(false);
                            for (FieldDefinition fld : def.getFieldsDefinitions()) {
                                tempDef.addField(fld);
                            }
                            tempDef.setInterfaces(def.getInterfaces());
                            tempDef.setSuperClass(def.getClassName());
                            tempDef.setDefinedClass(resolvedType);
                            tempDef.setAbstrakt(true);
                            tempDeclr.setTypeClassDef(tempDef);
                            type.setKind(TypeDeclaration.Kind.CLASS);
                            this.generateDeclaredBean((AbstractClassTypeDeclarationDescr)tempDescr, tempDeclr, pkgRegistry, tempDef);
                            try {
                                Class clazz = pkgRegistry.getTypeResolver().resolveType(tempDescr.getType().getFullName());
                                tempDeclr.setTypeClass(clazz);
                                break block30;
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.results.add(new TypeDeclarationError(typeDescr, "Internal Trait extension Class '" + target + "' could not be generated correctly'"));
                                break block30;
                            }
                            finally {
                                pkgRegistry.getPackage().addTypeDeclaration(tempDeclr);
                            }
                        }
                        this.updateTraitDefinition(type, resolvedType);
                        pkgRegistry.getTraitRegistry().addTrait(def);
                    }
                    catch (ClassNotFoundException cnfe) {}
                } else if (def.getClassName().endsWith("_Trait__Extension")) {
                    pkgRegistry.getTraitRegistry().addTrait(def.getClassName().replace("_Trait__Extension", ""), def);
                } else {
                    pkgRegistry.getTraitRegistry().addTrait(def);
                }
            }
        }
        if (type.isNovel()) {
            String fullName = typeDescr.getType().getFullName();
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            switch (type.getKind()) {
                case TRAIT: {
                    try {
                        this.buildClass(def, fullName, dialect, this.configuration.getClassBuilderFactory().getTraitBuilder());
                    }
                    catch (Exception e) {
                        this.results.add(new TypeDeclarationError(typeDescr, "Unable to compile declared trait " + fullName + ": " + e.getMessage() + ";"));
                    }
                    break;
                }
                case ENUM: {
                    try {
                        this.buildClass(def, fullName, dialect, (ClassBuilder)this.configuration.getClassBuilderFactory().getEnumClassBuilder());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.results.add(new TypeDeclarationError(typeDescr, "Unable to compile declared enum " + fullName + ": " + e.getMessage() + ";"));
                    }
                    break;
                }
                default: {
                    try {
                        this.buildClass(def, fullName, dialect, this.configuration.getClassBuilderFactory().getBeanClassBuilder());
                        break;
                    }
                    catch (Exception e) {
                        this.results.add(new TypeDeclarationError(typeDescr, "Unable to create a class for declared type " + fullName + ": " + e.getMessage() + ";"));
                    }
                }
            }
        }
    }

    private void buildClass(ClassDefinition def, String fullName, JavaDialectRuntimeData dialect, ClassBuilder cb) throws Exception {
        byte[] bytecode = cb.buildClass(def);
        String resourceName = JavaDialectRuntimeData.convertClassToResourcePath((String)fullName);
        dialect.putClassDefinition(resourceName, bytecode);
        if (this.ruleBase != null) {
            this.ruleBase.registerAndLoadTypeDefinition(fullName, bytecode);
        } else if (this.rootClassLoader instanceof ProjectClassLoader) {
            ((ProjectClassLoader)this.rootClassLoader).defineClass(fullName, resourceName, bytecode);
        } else {
            dialect.write(resourceName, bytecode);
        }
    }

    private PriorityQueue<FieldDefinition> sortFields(Map<String, TypeFieldDescr> flds, PackageRegistry pkgRegistry) {
        PriorityQueue<FieldDefinition> queue = new PriorityQueue<FieldDefinition>();
        int last = 0;
        for (TypeFieldDescr field : flds.values()) {
            last = Math.max(last, field.getIndex());
        }
        for (TypeFieldDescr field : flds.values()) {
            if (field.getIndex() < 0) {
                field.setIndex(++last);
            }
            try {
                String typeName = field.getPattern().getObjectType();
                String fullFieldType = this.generatedTypes.contains(typeName) ? typeName : pkgRegistry.getTypeResolver().resolveType(typeName).getName();
                FieldDefinition fieldDef = new FieldDefinition(field.getFieldName(), fullFieldType);
                boolean isKey = field.getAnnotation("key") != null;
                fieldDef.setKey(isKey);
                fieldDef.setIndex(field.getIndex());
                fieldDef.setInherited(field.isInherited());
                fieldDef.setInitExpr(field.getInitExpr());
                for (String annotationName : field.getAnnotationNames()) {
                    Class annotation = this.resolveAnnotation(annotationName, pkgRegistry.getTypeResolver());
                    if (annotation != null) {
                        try {
                            AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)annotation, field.getAnnotations().get(annotationName).getValueMap(), (TypeResolver)pkgRegistry.getTypeResolver());
                            fieldDef.addAnnotation(annotationDefinition);
                        }
                        catch (NoSuchMethodException nsme) {
                            this.results.add(new TypeDeclarationError(field, "Annotated field " + field.getFieldName() + "  - undefined property in @annotation " + annotationName + ": " + nsme.getMessage() + ";"));
                        }
                    }
                    if (annotation != null && annotation != Key.class && annotation != Position.class) continue;
                    fieldDef.addMetaData(annotationName, (Object)field.getAnnotation(annotationName).getSingleValue());
                }
                queue.add(fieldDef);
            }
            catch (ClassNotFoundException cnfe) {
                this.results.add(new TypeDeclarationError(field, cnfe.getMessage()));
            }
        }
        return queue;
    }

    private void addFunction(FunctionDescr functionDescr) {
        functionDescr.setResource(this.resource);
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.addFunction(functionDescr, pkgRegistry.getTypeResolver(), this.resource);
    }

    private void preCompileAddFunction(FunctionDescr functionDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.preCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void postCompileAddFunction(FunctionDescr functionDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.postCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRule(RuleDescr ruleDescr) {
        if (ruleDescr.getResource() == null) {
            ruleDescr.setResource(this.resource);
        }
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(ruleDescr.getNamespace());
        org.drools.core.rule.Package pkg = pkgRegistry.getPackage();
        DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
        RuleBuildContext context = new RuleBuildContext(this, ruleDescr, ctr, pkg, ctr.getDialect(pkgRegistry.getDialect()));
        ruleBuilder.build(context);
        this.results.addAll(context.getErrors());
        context.getRule().setResource(ruleDescr.getResource());
        context.getDialect().addRule(context);
        if (this.ruleBase != null && pkg.getRule(ruleDescr.getName()) != null) {
            this.ruleBase.lock();
            try {
                this.ruleBase.removeRule(pkg, pkg.getRule(ruleDescr.getName()));
            }
            finally {
                this.ruleBase.unlock();
            }
        }
        pkg.addRule(context.getRule());
    }

    public org.drools.core.rule.Package getPackage() {
        PackageRegistry pkgRegistry = null;
        if (!this.pkgRegistryMap.isEmpty()) {
            pkgRegistry = (PackageRegistry)this.pkgRegistryMap.values().toArray()[this.currentRulePackage];
        }
        org.drools.core.rule.Package pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (this.hasErrors() && pkg != null) {
            pkg.setError(this.getErrors().toString());
        }
        return pkg;
    }

    public org.drools.core.rule.Package[] getPackages() {
        org.drools.core.rule.Package[] pkgs = new org.drools.core.rule.Package[this.pkgRegistryMap.size()];
        String errors = null;
        if (!this.getErrors().isEmpty()) {
            errors = this.getErrors().toString();
        }
        int i = 0;
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            org.drools.core.rule.Package pkg = pkgRegistry.getPackage();
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            if (errors != null) {
                pkg.setError(errors);
            }
            pkgs[i++] = pkg;
        }
        return pkgs;
    }

    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.configuration;
    }

    public PackageRegistry getPackageRegistry(String name) {
        return this.pkgRegistryMap.get(name);
    }

    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryMap;
    }

    public DateFormats getDateFormats() {
        return this.dateFormats;
    }

    public Collection<String> getPackageNames() {
        return this.pkgRegistryMap.keySet();
    }

    public List<PackageDescr> getPackageDescrs(String packageName) {
        return this.packages.get(packageName);
    }

    public DefaultExpander getDslExpander() {
        DefaultExpander expander = new DefaultExpander();
        if (this.dslFiles == null || this.dslFiles.isEmpty()) {
            return null;
        }
        for (DSLTokenizedMappingFile file : this.dslFiles) {
            expander.addDSLMapping(file.getMapping());
        }
        return expander;
    }

    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public boolean hasErrors() {
        return !this.getErrorList().isEmpty();
    }

    public KnowledgeBuilderResults getProblems(ResultSeverity ... problemTypes) {
        List<KnowledgeBuilderResult> problems = this.getResultList(problemTypes);
        return new PackageBuilderResults(problems.toArray(new BaseKnowledgeBuilderResultImpl[problems.size()]));
    }

    private List<KnowledgeBuilderResult> getResultList(ResultSeverity ... severities) {
        List<ResultSeverity> typesToFetch = Arrays.asList(severities);
        ArrayList<KnowledgeBuilderResult> problems = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (!typesToFetch.contains(problem.getSeverity())) continue;
            problems.add(problem);
        }
        return problems;
    }

    public boolean hasProblems(ResultSeverity ... problemTypes) {
        return !this.getResultList(problemTypes).isEmpty();
    }

    private List<DroolsError> getErrorList() {
        ArrayList<DroolsError> errors = new ArrayList<DroolsError>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.ERROR) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                errors.add(new DroolsErrorWrapper(problem));
                continue;
            }
            errors.add((DroolsError)problem);
        }
        return errors;
    }

    public boolean hasWarnings() {
        return !this.getWarningList().isEmpty();
    }

    public boolean hasInfo() {
        return !this.getInfoList().isEmpty();
    }

    public List<DroolsWarning> getWarningList() {
        ArrayList<DroolsWarning> warnings = new ArrayList<DroolsWarning>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.WARNING) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                warnings.add(new DroolsWarningWrapper(problem));
                continue;
            }
            warnings.add((DroolsWarning)problem);
        }
        return warnings;
    }

    private List<KnowledgeBuilderResult> getInfoList() {
        return this.getResultList(ResultSeverity.INFO);
    }

    public PackageBuilderErrors getErrors() {
        List<DroolsError> errors = this.getErrorList();
        return new PackageBuilderErrors(errors.toArray(new DroolsError[errors.size()]));
    }

    protected void resetErrors() {
        this.resetProblemType(ResultSeverity.ERROR);
    }

    protected void resetWarnings() {
        this.resetProblemType(ResultSeverity.WARNING);
    }

    private void resetProblemType(ResultSeverity problemType) {
        ArrayList<KnowledgeBuilderResult> toBeDeleted = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problemType == null || !problemType.equals((Object)problem.getSeverity())) continue;
            toBeDeleted.add(problem);
        }
        this.results.removeAll(toBeDeleted);
    }

    protected void resetProblems() {
        this.results.clear();
    }

    public String getDefaultDialect() {
        return this.defaultDialect;
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public Collection<AbstractClassTypeDeclarationDescr> sortByHierarchy(List<AbstractClassTypeDeclarationDescr> typeDeclarations) {
        HierarchySorter sorter = new HierarchySorter();
        HashMap<QualifiedName, Collection<QualifiedName>> taxonomy = new HashMap<QualifiedName, Collection<QualifiedName>>();
        HashMap<QualifiedName, AbstractClassTypeDeclarationDescr> cache = new HashMap<QualifiedName, AbstractClassTypeDeclarationDescr>();
        for (AbstractClassTypeDeclarationDescr tdescr : typeDeclarations) {
            QualifiedName name = tdescr.getType();
            cache.put(name, tdescr);
            if (taxonomy.get(name) == null) {
                taxonomy.put(name, new ArrayList());
            } else {
                this.results.add(new TypeDeclarationError(tdescr, "Found duplicate declaration for type " + tdescr.getTypeName()));
            }
            Collection supers = (Collection)taxonomy.get(name);
            boolean circular = false;
            for (QualifiedName sup : tdescr.getSuperTypes()) {
                if (Object.class.getName().equals(name.getFullName())) continue;
                if (!this.hasCircularDependency(tdescr.getType(), sup, taxonomy)) {
                    supers.add(sup);
                    continue;
                }
                circular = true;
                this.results.add(new TypeDeclarationError(tdescr, "Found circular dependency for type " + tdescr.getTypeName()));
                break;
            }
            if (circular) {
                tdescr.getSuperTypes().clear();
            }
            for (TypeFieldDescr field : tdescr.getFields().values()) {
                QualifiedName typeName = new QualifiedName(field.getPattern().getObjectType());
                if (this.hasCircularDependency(name, typeName, taxonomy)) continue;
                supers.add(typeName);
            }
        }
        List sorted = sorter.sort(taxonomy);
        ArrayList<AbstractClassTypeDeclarationDescr> list = new ArrayList<AbstractClassTypeDeclarationDescr>(sorted.size());
        for (QualifiedName name : sorted) {
            list.add((AbstractClassTypeDeclarationDescr)cache.get(name));
        }
        return list;
    }

    private boolean hasCircularDependency(QualifiedName name, QualifiedName typeName, Map<QualifiedName, Collection<QualifiedName>> taxonomy) {
        if (name.equals(typeName)) {
            return true;
        }
        if (taxonomy.containsKey(typeName)) {
            Collection<QualifiedName> parents = taxonomy.get(typeName);
            if (parents.contains(name)) {
                return true;
            }
            for (QualifiedName ancestor : parents) {
                if (!this.hasCircularDependency(name, ancestor, taxonomy)) continue;
                return true;
            }
        }
        return false;
    }

    private void inheritPackageAttributes(Map<String, AttributeDescr> pkgAttributes, RuleDescr ruleDescr) {
        if (pkgAttributes == null) {
            return;
        }
        for (AttributeDescr attrDescr : pkgAttributes.values()) {
            String name = attrDescr.getName();
            AttributeDescr ruleAttrDescr = ruleDescr.getAttributes().get(name);
            if (ruleAttrDescr != null) continue;
            ruleDescr.getAttributes().put(name, attrDescr);
        }
    }

    private int compareTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) throws IncompatibleClassChangeError {
        if (!oldDeclaration.getFormat().equals((Object)newDeclaration.getFormat())) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " format that its previous definition: " + newDeclaration.getFormat() + "!=" + oldDeclaration.getFormat());
        }
        if (!(oldDeclaration.getTypeClassDef().getSuperClass().equals(newDeclaration.getTypeClassDef().getSuperClass()) || oldDeclaration.getNature() == TypeDeclaration.Nature.DEFINITION && newDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION && Object.class.getName().equals(newDeclaration.getTypeClassDef().getSuperClass()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " superclass that its previous definition: " + newDeclaration.getTypeClassDef().getSuperClass() + " != " + oldDeclaration.getTypeClassDef().getSuperClass());
        }
        if (!this.nullSafeEqualityComparison((Comparable)((Object)oldDeclaration.getDurationAttribute()), (Comparable)((Object)newDeclaration.getDurationAttribute()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " duration: " + newDeclaration.getDurationAttribute() + " != " + oldDeclaration.getDurationAttribute());
        }
        if (newDeclaration.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && oldDeclaration.getSetMask() != newDeclaration.getSetMask()) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " is incompatible with" + " the previous definition: " + newDeclaration + " != " + oldDeclaration);
        }
        List oldFields = oldDeclaration.getTypeClassDef().getFields();
        HashMap<String, FactField> newFieldsMap = new HashMap<String, FactField>();
        for (FactField factField : newDeclaration.getTypeClassDef().getFields()) {
            newFieldsMap.put(factField.getName(), factField);
        }
        boolean allFieldsInOldDeclarationAreStillPresent = true;
        for (FactField oldFactField : oldFields) {
            FactField newFactField = (FactField)newFieldsMap.get(oldFactField.getName());
            if (newFactField != null) {
                String newFactType = ((FieldDefinition)newFactField).getTypeName();
                if (newFactType.equals(oldFactField.getType().getCanonicalName())) continue;
                throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + "." + newFactField.getName() + " has a different" + " type that its previous definition: " + newFactType + " != " + oldFactField.getType().getCanonicalName());
            }
            allFieldsInOldDeclarationAreStillPresent = false;
        }
        if (oldFields.size() < newFieldsMap.size()) {
            return -1;
        }
        if (oldFields.size() > newFieldsMap.size()) {
            return 1;
        }
        if (allFieldsInOldDeclarationAreStillPresent) {
            return 0;
        }
        throw new IncompatibleClassChangeError(newDeclaration.getTypeName() + " introduces" + " fields that are not present in its previous version.");
    }

    private void mergeTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) {
        if (oldDeclaration == null) {
            return;
        }
        for (FieldDefinition oldFactField : oldDeclaration.getTypeClassDef().getFieldsDefinitions()) {
            FieldDefinition newFactField = newDeclaration.getTypeClassDef().getField(oldFactField.getName());
            if (newFactField != null) continue;
            newDeclaration.getTypeClassDef().addField(oldFactField);
        }
        newDeclaration.setTypeClass(oldDeclaration.getTypeClass());
    }

    private boolean nullSafeEqualityComparison(Comparable c1, Comparable c2) {
        if (c1 == null) {
            return c2 == null;
        }
        return c2 != null && c1.compareTo(c2) == 0;
    }

    public void registerBuildResource(final Resource resource) {
        this.buildResources.push((List<Resource>)new ArrayList<Resource>(){
            {
                this.add(resource);
            }
        });
    }

    public void registerBuildResources(List<Resource> resources) {
        this.buildResources.push(resources);
    }

    public void undo() {
        if (this.buildResources.isEmpty()) {
            return;
        }
        for (Resource resource : this.buildResources.pop()) {
            this.removeObjectsGeneratedFromResource(resource);
        }
    }

    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        Iterator<KnowledgeBuilderResult> i;
        boolean modified = false;
        if (this.pkgRegistryMap != null) {
            for (PackageRegistry packageRegistry : this.pkgRegistryMap.values()) {
                modified = packageRegistry.removeObjectsGeneratedFromResource(resource) || modified;
            }
        }
        if (this.results != null) {
            i = this.results.iterator();
            while (i.hasNext()) {
                if (!resource.equals(i.next().getResource())) continue;
                i.remove();
            }
        }
        if (this.processBuilder != null && this.processBuilder.getErrors() != null) {
            i = this.processBuilder.getErrors().iterator();
            while (i.hasNext()) {
                if (!resource.equals(i.next().getResource())) continue;
                i.remove();
            }
        }
        if (this.results.size() == 0) {
            for (PackageRegistry packageRegistry : this.pkgRegistryMap.values()) {
                packageRegistry.getPackage().resetErrors();
            }
        }
        if (this.cacheTypes != null) {
            ArrayList typesToBeRemoved = new ArrayList();
            for (Map.Entry<String, TypeDeclaration> type : this.cacheTypes.entrySet()) {
                if (!resource.equals(type.getValue().getResource())) continue;
                typesToBeRemoved.add(type.getKey());
            }
            for (Map.Entry<String, TypeDeclaration> type : typesToBeRemoved) {
                this.cacheTypes.remove(type);
            }
        }
        for (List list : this.packages.values()) {
            for (PackageDescr pkgDescr : list) {
                pkgDescr.removeObjectsGeneratedFromResource(resource);
            }
        }
        if (this.ruleBase != null) {
            this.ruleBase.removeObjectsGeneratedFromResource(resource);
        }
        return modified;
    }

    static class TypeDefinition {
        private final AbstractClassTypeDeclarationDescr typeDescr;
        private final TypeDeclaration type;

        private TypeDefinition(TypeDeclaration type, AbstractClassTypeDeclarationDescr typeDescr) {
            this.type = type;
            this.typeDescr = typeDescr;
        }

        public String getTypeClassName() {
            return this.type.getTypeClassName();
        }

        public String getNamespace() {
            return this.typeDescr.getNamespace();
        }
    }

    public static class SrcError
    extends DroolsError {
        private Object object;
        private String message;
        private int[] errorLines = new int[0];

        public SrcError(Object object, String message) {
            super(null);
            this.object = object;
            this.message = message;
        }

        public Object getObject() {
            return this.object;
        }

        @Override
        public int[] getLines() {
            return this.errorLines;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.message);
            buf.append(" : ");
            buf.append("\n");
            if (this.object instanceof CompilationProblem[]) {
                CompilationProblem[] problem;
                for (CompilationProblem aProblem : problem = (CompilationProblem[])this.object) {
                    buf.append("\t");
                    buf.append(aProblem);
                    buf.append("\n");
                }
            } else if (this.object != null) {
                buf.append(this.object);
            }
            return buf.toString();
        }
    }

    public static class SrcErrorHandler
    extends ErrorHandler {
        public SrcErrorHandler(String message) {
            this.message = message;
        }

        @Override
        public DroolsError getError() {
            return new SrcError(this.collectCompilerProblems(), this.message);
        }
    }

    public static class FunctionErrorHandler
    extends ErrorHandler {
        private FunctionDescr descr;

        public FunctionErrorHandler(FunctionDescr functionDescr, String message) {
            this.descr = functionDescr;
            this.message = message;
        }

        @Override
        public DroolsError getError() {
            return new FunctionError(this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static class RuleInvokerErrorHandler
    extends RuleErrorHandler {
        public RuleInvokerErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            super(ruleDescr, rule, message);
        }
    }

    public static class RuleErrorHandler
    extends ErrorHandler {
        private BaseDescr descr;
        private Rule rule;

        public RuleErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            this.descr = ruleDescr;
            this.rule = rule;
            this.message = message;
        }

        @Override
        public DroolsError getError() {
            return new RuleBuildError(this.rule, this.descr, (Object)this.collectCompilerProblems(), this.message);
        }
    }

    public static abstract class ErrorHandler {
        private final List errors = new ArrayList();
        protected String message;
        private boolean inError = false;

        public boolean isInError() {
            return this.inError;
        }

        public void addError(CompilationProblem err) {
            this.errors.add(err);
            this.inError = true;
        }

        public abstract DroolsError getError();

        protected CompilationProblem[] collectCompilerProblems() {
            if (this.errors.isEmpty()) {
                return null;
            }
            CompilationProblem[] list = new CompilationProblem[this.errors.size()];
            this.errors.toArray(list);
            return list;
        }
    }

    public static class PackageMergeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 400L;

        public PackageMergeException(String message) {
            super(message);
        }
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 510L;

        public MissingPackageNameException(String message) {
            super(message);
        }
    }
}

