/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.lang.reflect.Method;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ValueType;

public abstract class BaseLongClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 510L;

    public BaseLongClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseLongClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.setLongValue(bean, value == null ? 0L : ((Number)value).longValue());
    }

    @Override
    public void setBooleanValue(Object bean, boolean value) {
        throw new RuntimeDroolsException("Conversion to long not supported from boolean");
    }

    @Override
    public void setByteValue(Object bean, byte value) {
        this.setLongValue(bean, value);
    }

    @Override
    public void setCharValue(Object bean, char value) {
        throw new RuntimeDroolsException("Conversion to long not supported from char");
    }

    @Override
    public void setDoubleValue(Object bean, double value) {
        this.setLongValue(bean, (long)value);
    }

    @Override
    public void setFloatValue(Object bean, float value) {
        this.setLongValue(bean, (long)value);
    }

    @Override
    public void setIntValue(Object bean, int value) {
        this.setLongValue(bean, value);
    }

    @Override
    public abstract void setLongValue(Object var1, long var2);

    @Override
    public void setShortValue(Object bean, short value) {
        this.setLongValue(bean, value);
    }

    @Override
    public Method getNativeWriteMethod() {
        try {
            return this.getClass().getDeclaredMethod("setLongValue", Object.class, Long.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

