/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.defeasible;

import java.util.Arrays;
import java.util.List;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.core.beliefsystem.defeasible.DefeasibleLogicalDependency;
import org.drools.core.beliefsystem.defeasible.DefeasibleRuleNature;
import org.drools.core.beliefsystem.defeasible.Defeats;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.rule.Rule;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;
import org.kie.api.runtime.rule.FactHandle;

public class DefeasibleBeliefSet
implements JTMSBeliefSet {
    private BeliefSystem beliefSystem;
    public static final String DEFEATS = Defeats.class.getSimpleName();
    private static final FastIterator iterator = new IteratorImpl();
    private InternalFactHandle rootHandle;
    private InternalFactHandle positiveFactHandle;
    private InternalFactHandle negativeFactHandle;
    private LinkedListEntry<DefeasibleLogicalDependency> rootUndefeated;
    private LinkedListEntry<DefeasibleLogicalDependency> tailUndefeated;
    private int definitelyPosCount;
    private int definitelyNegCount;
    private int defeasiblyPosCount;
    private int defeasiblyNegCount;
    private int defeatedlyPosCount;
    private int defeatedlyNegCount;
    private static final int DEFINITELY_POS_BIT = 1;
    private static final int DEFINITELY_NEG_BIT = 2;
    private static final int DEFEASIBLY_POS_BIT = 4;
    private static final int DEFEASIBLY_NEG_BIT = 8;
    private static final int DEFEATEDLY_POS_BIT = 16;
    private static final int DEFEATEDLY_NEG_BIT = 32;
    private static final int POS_MASK = 21;
    private static final int NEG_MASK = 42;
    private static final int WEAK_POS_MASK = 20;
    private static final int WEAK_NEG_MASK = 40;
    private int statusMask = 0;
    private DefeasibilityStatus status;

    public DefeasibleBeliefSet(BeliefSystem beliefSystem, InternalFactHandle rootHandle) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    @Override
    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    @Override
    public LinkedListEntry<DefeasibleLogicalDependency> getFirst() {
        return this.rootUndefeated;
    }

    @Override
    public LinkedListEntry<DefeasibleLogicalDependency> getLast() {
        return this.tailUndefeated;
    }

    @Override
    public InternalFactHandle getPositiveFactHandle() {
        return this.positiveFactHandle;
    }

    @Override
    public void setPositiveFactHandle(InternalFactHandle positiveFactHandle) {
        this.positiveFactHandle = positiveFactHandle;
    }

    @Override
    public InternalFactHandle getNegativeFactHandle() {
        return this.negativeFactHandle;
    }

    @Override
    public void setNegativeFactHandle(InternalFactHandle negativeFactHandle) {
        this.negativeFactHandle = negativeFactHandle;
    }

    @Override
    public void add(LinkedListNode node) {
        DefeasibleLogicalDependency existingDep;
        DefeasibleLogicalDependency newDep = (DefeasibleLogicalDependency)((LinkedListEntry)node).getObject();
        newDep.setStatus(this.resolveStatus(newDep));
        Rule rule = newDep.getJustifier().getRule();
        boolean wasDefeated = false;
        for (LinkedListEntry existingNode = this.rootUndefeated; existingNode != null && !(wasDefeated = this.checkAndApplyIsDefeated(newDep, rule, existingDep = existingNode.getObject())); existingNode = (LinkedListEntry)existingNode.getNext()) {
        }
        if (!wasDefeated) {
            LinkedListEntry<DefeasibleLogicalDependency> stagedDeps = null;
            LinkedListEntry existingNode = this.rootUndefeated;
            while (existingNode != null) {
                LinkedListEntry next = (LinkedListEntry)existingNode.getNext();
                DefeasibleLogicalDependency existingDep2 = existingNode.getObject();
                if (this.checkAndApplyIsDefeated(existingDep2, existingDep2.getJustifier().getRule(), newDep)) {
                    this.removeUndefeated(existingDep2, existingNode);
                    if (existingDep2.getRootDefeated() != null) {
                        if (stagedDeps == null) {
                            stagedDeps = existingDep2.getRootDefeated();
                        } else {
                            stagedDeps.setPrevious((DefeasibleLogicalDependency)((Object)existingDep2.getTailDefeated()));
                            stagedDeps = existingDep2.getRootDefeated();
                        }
                    }
                    existingDep2.clearDefeated();
                }
                existingNode = next;
            }
            this.addUndefeated(newDep, (LinkedListEntry)node);
            this.reprocessDefeated(stagedDeps);
        }
        this.updateStatus();
    }

    private void reprocessDefeated(LinkedListEntry<DefeasibleLogicalDependency> deps) {
        LinkedListEntry dep = deps;
        while (dep != null) {
            LinkedListEntry next = (LinkedListEntry)dep.getNext();
            dep.nullPrevNext();
            this.add(dep);
            dep = next;
        }
    }

    @Override
    public void remove(LinkedListNode node) {
        DefeasibleLogicalDependency dep = (DefeasibleLogicalDependency)((LinkedListEntry)node).getObject();
        if (dep.getDefeatedBy() != null) {
            DefeasibleLogicalDependency defeater = dep.getDefeatedBy();
            defeater.removeDefeated(dep);
        } else {
            this.removeUndefeated(dep, (LinkedListEntry)node);
            if (dep.getRootDefeated() != null) {
                this.reprocessDefeated(dep.getRootDefeated());
            }
        }
        this.updateStatus();
    }

    private boolean checkAndApplyIsDefeated(DefeasibleLogicalDependency potentialInferior, Rule rule, DefeasibleLogicalDependency potentialSuperior) {
        if (potentialSuperior.getDefeats() == null) {
            return false;
        }
        if (potentialSuperior.getStatus() == DefeasibilityStatus.DEFINITELY && potentialInferior.getStatus() != DefeasibilityStatus.DEFINITELY) {
            potentialSuperior.addDefeated(potentialInferior);
            return true;
        }
        if (Arrays.binarySearch(potentialSuperior.getDefeats(), rule.getName()) >= 0 || Arrays.binarySearch(potentialSuperior.getDefeats(), rule.getPackage() + "." + rule.getName()) >= 0) {
            potentialSuperior.addDefeated(potentialInferior);
            return true;
        }
        return false;
    }

    public void addUndefeated(DefeasibleLogicalDependency dep, LinkedListEntry<DefeasibleLogicalDependency> node) {
        boolean pos = dep.getValue() == null || JTMSBeliefSetImpl.MODE.POSITIVE.getId().equals(dep.getValue().toString());
        switch (dep.getStatus()) {
            case DEFINITELY: {
                if (pos) {
                    ++this.definitelyPosCount;
                    this.statusMask |= 1;
                    break;
                }
                ++this.definitelyNegCount;
                this.statusMask |= 2;
                break;
            }
            case DEFEASIBLY: {
                if (pos) {
                    ++this.defeasiblyPosCount;
                    this.statusMask |= 4;
                    break;
                }
                ++this.defeasiblyNegCount;
                this.statusMask |= 8;
                break;
            }
            case DEFEATEDLY: {
                if (pos) {
                    ++this.defeatedlyPosCount;
                    this.statusMask |= 0x10;
                    break;
                }
                ++this.defeatedlyNegCount;
                this.statusMask |= 0x20;
                break;
            }
            case UNDECIDABLY: {
                throw new IllegalStateException("Individual logical dependencies cannot be undecidably");
            }
        }
        if (this.rootUndefeated == null) {
            this.rootUndefeated = node;
            this.tailUndefeated = node;
        } else if (dep.getStatus() == DefeasibilityStatus.DEFINITELY) {
            this.rootUndefeated.setPrevious((DefeasibleLogicalDependency)((Object)node));
            node.setNext((DefeasibleLogicalDependency)((Object)this.rootUndefeated));
            this.rootUndefeated = node;
        } else {
            this.tailUndefeated.setNext((DefeasibleLogicalDependency)((Object)node));
            node.setPrevious((DefeasibleLogicalDependency)((Object)this.tailUndefeated));
            this.tailUndefeated = node;
        }
    }

    public void removeUndefeated(DefeasibleLogicalDependency dep, LinkedListEntry<DefeasibleLogicalDependency> node) {
        boolean pos = dep.getValue() == null || JTMSBeliefSetImpl.MODE.POSITIVE.getId().equals(dep.getValue().toString());
        switch (dep.getStatus()) {
            case DEFINITELY: {
                if (pos) {
                    --this.definitelyPosCount;
                    if (this.definitelyPosCount != 0) break;
                    this.statusMask ^= 1;
                    break;
                }
                --this.definitelyNegCount;
                if (this.definitelyNegCount != 0) break;
                this.statusMask ^= 2;
                break;
            }
            case DEFEASIBLY: {
                if (pos) {
                    --this.defeasiblyPosCount;
                    if (this.defeasiblyPosCount != 0) break;
                    this.statusMask ^= 4;
                    break;
                }
                --this.defeasiblyNegCount;
                if (this.defeasiblyNegCount != 0) break;
                this.statusMask ^= 8;
                break;
            }
            case DEFEATEDLY: {
                if (pos) {
                    --this.defeatedlyPosCount;
                    if (this.defeatedlyPosCount != 0) break;
                    this.statusMask ^= 0x10;
                    break;
                }
                --this.defeatedlyNegCount;
                if (this.defeatedlyNegCount != 0) break;
                this.statusMask ^= 0x20;
                break;
            }
            case UNDECIDABLY: {
                throw new IllegalStateException("Individual logical dependencies cannot be undecidably");
            }
        }
        if (this.rootUndefeated == node) {
            this.removeFirst();
        } else if (this.tailUndefeated == node) {
            this.removeLast();
        } else {
            ((LinkedListEntry)node.getPrevious()).setNext(node.getNext());
            node.getNext().setPrevious(node.getPrevious());
            node.nullPrevNext();
        }
    }

    public LinkedListNode removeFirst() {
        if (this.rootUndefeated == null) {
            return null;
        }
        LinkedListEntry<DefeasibleLogicalDependency> node = this.rootUndefeated;
        this.rootUndefeated = (LinkedListEntry)node.getNext();
        node.setNext(null);
        if (this.rootUndefeated != null) {
            this.rootUndefeated.setPrevious(null);
        } else {
            this.tailUndefeated = null;
        }
        return node;
    }

    public LinkedListNode removeLast() {
        if (this.tailUndefeated == null) {
            return null;
        }
        LinkedListEntry<DefeasibleLogicalDependency> node = this.tailUndefeated;
        this.tailUndefeated = (LinkedListEntry)node.getPrevious();
        node.setPrevious(null);
        if (this.tailUndefeated != null) {
            this.tailUndefeated.setNext(null);
        } else {
            this.rootUndefeated = this.tailUndefeated;
        }
        return node;
    }

    public LinkedListNode getRootUndefeated() {
        return this.rootUndefeated;
    }

    public LinkedListNode getTailUnDefeated() {
        return this.tailUndefeated;
    }

    @Override
    public boolean isEmpty() {
        return this.rootUndefeated == null;
    }

    @Override
    public int size() {
        return this.definitelyPosCount + this.definitelyNegCount + this.defeasiblyPosCount + this.defeasiblyNegCount + this.defeatedlyPosCount + this.defeatedlyNegCount;
    }

    public int undefeatdSize() {
        int i = 0;
        for (LinkedListEntry existingNode = this.rootUndefeated; existingNode != null; existingNode = (LinkedListEntry)existingNode.getNext()) {
            ++i;
        }
        return i;
    }

    @Override
    public void cancel(PropagationContext propagationContext) {
        FastIterator it = this.iterator();
        LinkedListNode node = this.getFirst();
        while (node != this.tailUndefeated) {
            LinkedListEntry temp = (LinkedListEntry)it.next(node);
            DefeasibleLogicalDependency dep = (DefeasibleLogicalDependency)((LinkedListEntry)node).getObject();
            dep.getJustifier().getLogicalDependencies().remove(dep);
            this.remove(dep);
            node = temp;
        }
        LinkedListNode last = this.getFirst();
        LogicalDependency node2 = (LogicalDependency)((LinkedListEntry)last).getObject();
        node2.getJustifier().getLogicalDependencies().remove(node2);
        this.positiveFactHandle = null;
        this.negativeFactHandle = null;
    }

    @Override
    public void clear(PropagationContext propagationContext) {
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
    }

    public boolean isDefinitelyPosProveable() {
        return (this.statusMask & 1) != 0;
    }

    public boolean isDefinitelyNegProveable() {
        return (this.statusMask & 2) != 0;
    }

    public boolean isDefeasiblyPosProveable() {
        return (this.statusMask & 4) != 0;
    }

    public boolean isDefeasiblyNegProveable() {
        return (this.statusMask & 8) != 0;
    }

    public boolean isDefeatedlyPosProveable() {
        return (this.statusMask & 0x10) != 0;
    }

    public boolean isDefeatedlyNegProveable() {
        return (this.statusMask & 0x20) != 0;
    }

    public DefeasibilityStatus getStatus() {
        return this.status;
    }

    public void updateStatus() {
        if (this.isDefinitelyPosProveable() ^ this.isDefinitelyNegProveable()) {
            this.status = DefeasibilityStatus.DEFINITELY;
            return;
        }
        if (this.isConflicting()) {
            this.status = DefeasibilityStatus.UNDECIDABLY;
            return;
        }
        if (this.isDefeasiblyPosProveable() ^ this.isDefeasiblyNegProveable()) {
            this.status = DefeasibilityStatus.DEFEASIBLY;
            return;
        }
        if (this.isDefeatedlyPosProveable() ^ this.isDefeatedlyNegProveable()) {
            this.status = DefeasibilityStatus.DEFEATEDLY;
            return;
        }
        this.status = DefeasibilityStatus.UNDECIDABLY;
    }

    @Override
    public boolean isNegated() {
        return (this.statusMask & 0x15) == 0 && (this.statusMask & 0x2A) != 0;
    }

    @Override
    public boolean isPositive() {
        return (this.statusMask & 0x15) != 0 && (this.statusMask & 0x2A) == 0;
    }

    public boolean isConflicting() {
        return (this.statusMask & 0x15) != 0 && (this.statusMask & 0x2A) != 0;
    }

    @Override
    public boolean isUndecided() {
        return this.getStatus() == DefeasibilityStatus.UNDECIDABLY || this.getStatus() == DefeasibilityStatus.DEFEATEDLY;
    }

    @Override
    public FastIterator iterator() {
        return iterator;
    }

    private DefeasibilityStatus resolveStatus(LogicalDependency node) {
        List premise = node.getJustifier().getFactHandles();
        DefeasibilityStatus status = DefeasibilityStatus.resolve(node.getValue());
        if (status == null) {
            DefeasibleRuleNature defeasibleType = DefeasibleRuleNature.STRICT;
            if (node.getJustifier().getRule().getMetaData().containsKey(DefeasibleRuleNature.DEFEASIBLE.getLabel())) {
                defeasibleType = DefeasibleRuleNature.DEFEASIBLE;
            } else if (node.getJustifier().getRule().getMetaData().containsKey(DefeasibleRuleNature.DEFEATER.getLabel())) {
                defeasibleType = DefeasibleRuleNature.DEFEATER;
            }
            switch (defeasibleType) {
                case DEFEASIBLE: {
                    status = this.checkDefeasible(premise);
                    break;
                }
                case DEFEATER: {
                    status = this.checkDefeater(premise);
                    break;
                }
                default: {
                    status = this.checkStrict(premise);
                }
            }
        }
        return status;
    }

    private DefeasibilityStatus checkDefeasible(List<? extends FactHandle> premise) {
        return DefeasibilityStatus.DEFEASIBLY;
    }

    private DefeasibilityStatus checkDefeater(List<? extends FactHandle> premise) {
        return DefeasibilityStatus.DEFEATEDLY;
    }

    private DefeasibilityStatus checkStrict(List<? extends FactHandle> premise) {
        for (FactHandle factHandle : premise) {
            DefeasibleBeliefSet bs;
            EqualityKey key = ((DefaultFactHandle)factHandle).getEqualityKey();
            if (key == null || key.getStatus() != 2 || (bs = (DefeasibleBeliefSet)key.getBeliefSet()).getStatus() == DefeasibilityStatus.DEFINITELY) continue;
            return DefeasibilityStatus.DEFEASIBLY;
        }
        return DefeasibilityStatus.DEFINITELY;
    }

    private static class IteratorImpl
    implements FastIterator {
        private IteratorImpl() {
        }

        @Override
        public Entry next(Entry object) {
            DefeasibleLogicalDependency dep = (DefeasibleLogicalDependency)object;
            if (dep.getRootDefeated() != null) {
                return dep.getRootDefeated();
            }
            if (dep.getNext() != null) {
                return dep.getNext();
            }
            if (dep.getDefeatedBy() != null) {
                return dep.getDefeatedBy().getNext();
            }
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }
    }
}

