/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;

public class PhreakJoinNode {
    public void doNode(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        RightTupleSets srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(joinNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(joinNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderLeftMemory(bm, srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderRightMemory(bm, srcRightTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(joinNode, leftTuple);
            if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            FastIterator it = joinNode.getRightIterator(rtm);
            PropagationContext context = leftTuple.getPropagationContext();
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, null, it);
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, useLeftMemory));
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm == null || ltm.size() == 0) {
                rightTuple.clearStaged();
                rightTuple = next;
                continue;
            }
            FastIterator it = joinNode.getLeftIterator(ltm);
            PropagationContext context = rightTuple.getPropagationContext();
            constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
            LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                }
                leftTuple = (LeftTuple)it.next(leftTuple);
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        RightTupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PropagationContext context = leftTuple.getPropagationContext();
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            FastIterator it = joinNode.getRightIterator(rtm);
            RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, null, it);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            if (childLeftTuple != null && rtm.isIndexed() && !it.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                while (childLeftTuple != null) {
                    childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
            }
            if (rightTuple != null) {
                this.doLeftUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public LeftTuple doLeftUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSets stagedLeftTuples, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, LeftTupleSets trgLeftTuples) {
        if (childLeftTuple == null) {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
        } else {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, childLeftTuple, null, sink, true));
                    } else {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        trgLeftTuples.addUpdate(childLeftTuple);
                        LeftTuple nextChildLeftTuple = childLeftTuple.getLeftParentNext();
                        childLeftTuple.reAddRight();
                        childLeftTuple = nextChildLeftTuple;
                    }
                } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                    childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
        }
        return childLeftTuple;
    }

    public void doRightUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            PropagationContext context = rightTuple.getPropagationContext();
            LeftTuple childLeftTuple = rightTuple.getFirstChild();
            FastIterator it = joinNode.getLeftIterator(ltm);
            LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
            constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
            if (childLeftTuple != null && ltm.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                while (childLeftTuple != null) {
                    childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                    childLeftTuple = RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
            }
            if (leftTuple != null) {
                this.doRightUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public LeftTuple doRightUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSets stagedLeftTuples, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, LeftTupleSets trgLeftTuples) {
        if (childLeftTuple == null) {
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                }
                leftTuple = (LeftTuple)it.next(leftTuple);
            }
        } else {
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, childLeftTuple, sink, true));
                        } else {
                            switch (childLeftTuple.getStagedType()) {
                                case 1: {
                                    stagedLeftTuples.removeInsert(childLeftTuple);
                                    break;
                                }
                                case 2: {
                                    stagedLeftTuples.removeUpdate(childLeftTuple);
                                }
                            }
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            trgLeftTuples.addUpdate(childLeftTuple);
                            LeftTuple nextChildLeftTuple = childLeftTuple.getRightParentNext();
                            childLeftTuple.reAddLeft();
                            childLeftTuple = nextChildLeftTuple;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        childLeftTuple = RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                leftTuple = (LeftTuple)it.next(leftTuple);
            }
        }
        return childLeftTuple;
    }

    public void doLeftDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
            }
            if (leftTuple.getFirstChild() != null) {
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        RightTupleMemory rtm = bm.getRightTupleMemory();
        RightTuple rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
            }
            if (rightTuple.getFirstChild() != null) {
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                while (childLeftTuple != null) {
                    childLeftTuple = RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }
}

