/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.SegmentMemory;

public class SegmentPropagator {
    public static void propagate(SegmentMemory sourceSegment, LeftTupleSets stagedLeftTuples, InternalWorkingMemory wm) {
        LeftTupleSource source = (LeftTupleSource)sourceSegment.getTipNode();
        if (sourceSegment.isEmpty()) {
            SegmentUtilities.createChildSegments(wm, sourceSegment, source.getSinkPropagator());
        }
        SegmentPropagator.processPeers(sourceSegment, stagedLeftTuples);
    }

    public static void processPeers(SegmentMemory sourceSegment, LeftTupleSets leftTuples) {
        LeftTupleSets stagedLeftTuples;
        LeftTuple peer;
        SegmentMemory smem;
        LeftTuple leftTuple;
        SegmentMemory firstSmem = (SegmentMemory)sourceSegment.getFirst();
        if (leftTuples.getDeleteFirst() != null) {
            for (leftTuple = leftTuples.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                smem = firstSmem.getNext();
                if (smem == null) continue;
                for (peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    stagedLeftTuples = smem.getStagedLeftTuples();
                    stagedLeftTuples.addDelete(peer);
                    smem = smem.getNext();
                }
            }
            firstSmem.getStagedLeftTuples().addAllDeletes(leftTuples);
        }
        if (leftTuples.getUpdateFirst() != null) {
            firstSmem = (SegmentMemory)sourceSegment.getFirst();
            for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                smem = firstSmem.getNext();
                if (smem == null) continue;
                for (peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    if (peer.getStagedType() == 0) {
                        stagedLeftTuples = smem.getStagedLeftTuples();
                        stagedLeftTuples.addUpdate(peer);
                    }
                    smem = smem.getNext();
                }
            }
            firstSmem.getStagedLeftTuples().addAllUpdates(leftTuples);
        }
        if (leftTuples.getInsertFirst() != null) {
            firstSmem = (SegmentMemory)sourceSegment.getFirst();
            for (leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                smem = firstSmem.getNext();
                if (smem == null) continue;
                peer = leftTuple;
                while (smem != null) {
                    peer = ((LeftTupleSink)smem.getRootNode()).createPeer(peer);
                    smem.getStagedLeftTuples().addInsert(peer);
                    smem = smem.getNext();
                }
            }
            firstSmem.getStagedLeftTuples().addAllInserts(leftTuples);
        }
    }

    public static void processPeers(LeftTupleSets leftTuples, LeftTupleSets peerLeftTuples, LeftTupleSink sink) {
        LeftTuple leftTuple;
        for (leftTuple = leftTuples.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            peerLeftTuples.addDelete(leftTuple.getPeer());
        }
        for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            peerLeftTuples.addUpdate(leftTuple.getPeer());
        }
        for (leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            peerLeftTuples.addInsert(sink.createPeer(leftTuple));
        }
    }
}

