/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.TransactionSynchronizationRegistryHelper;
import org.drools.persistence.jta.JtaTransactionSynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionManager
implements TransactionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager", System.getProperty("jbpm.tm.jndi.lookup")};
    public static final String DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME = "javax.transaction.TransactionSynchronizationRegistry";
    private static Class<?> transactionSynchronizationRegistryClass;
    UserTransaction ut;
    Object tsr;
    javax.transaction.TransactionManager tm;

    public JtaTransactionManager(Object ut, Object tsr, Object tm) {
        this.ut = ut instanceof UserTransaction ? (UserTransaction)ut : (UserTransaction)(ut != null ? ut : this.findUserTransaction());
        this.tm = tm instanceof javax.transaction.TransactionManager ? (javax.transaction.TransactionManager)tm : (javax.transaction.TransactionManager)(tm != null ? tm : this.findTransactionManager(this.ut));
        this.tsr = tsr != null ? tsr : this.findTransactionSynchronizationRegistry(this.ut, this.tm);
    }

    protected javax.transaction.TransactionManager findTransactionManager(UserTransaction ut) {
        if (ut instanceof TransactionManager) {
            this.logger.debug("JTA UserTransaction object [{}] implements TransactionManager", (Object)ut);
            return (javax.transaction.TransactionManager)ut;
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException ex) {
            this.logger.debug("Could not initialise JNDI InitialContext", (Throwable)ex);
            return null;
        }
        for (String jndiName : FALLBACK_TRANSACTION_MANAGER_NAMES) {
            if (jndiName == null) continue;
            try {
                javax.transaction.TransactionManager tm = (javax.transaction.TransactionManager)context.lookup(jndiName);
                this.logger.debug("JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName);
                return tm;
            }
            catch (NamingException ex) {
                this.logger.debug("No JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName, (Object)ex);
            }
        }
        return null;
    }

    protected UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            try {
                return (UserTransaction)InitialContext.doLookup(System.getProperty("jbpm.ut.jndi.lookup", "java:jboss/UserTransaction"));
            }
            catch (Exception e1) {
                throw new IllegalStateException("Unable to find transaction: " + ex.getMessage(), ex);
            }
        }
    }

    protected Object findTransactionSynchronizationRegistry(UserTransaction ut, javax.transaction.TransactionManager tm) {
        if (transactionSynchronizationRegistryClass == null) {
            this.logger.debug("JTA 1.1 [{}] API not available", (Object)TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
            return null;
        }
        String jndiName = DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME;
        try {
            InitialContext context = new InitialContext();
            Object tsrObject = context.lookup(jndiName);
            this.logger.debug("JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName);
            return tsrObject;
        }
        catch (NamingException ex) {
            this.logger.debug("No JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName, (Object)ex);
            if (transactionSynchronizationRegistryClass.isInstance(ut)) {
                return ut;
            }
            if (transactionSynchronizationRegistryClass.isInstance(tm)) {
                return tm;
            }
            return null;
        }
    }

    @Override
    public boolean begin() {
        if (this.getStatus() == 3) {
            try {
                this.ut.begin();
                return true;
            }
            catch (Exception e) {
                this.logger.warn("Unable to begin transaction", (Throwable)e);
                throw new RuntimeException("Unable to begin transaction", e);
            }
        }
        return false;
    }

    @Override
    public void commit(boolean transactionOwner) {
        if (transactionOwner) {
            try {
                this.ut.commit();
            }
            catch (Exception e) {
                this.logger.warn("Unable to commit transaction", (Throwable)e);
                throw new RuntimeException("Unable to commit transaction", e);
            }
        }
    }

    @Override
    public void rollback(boolean transactionOwner) {
        try {
            if (transactionOwner) {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            } else {
                this.ut.setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    @Override
    public int getStatus() {
        int s;
        try {
            s = this.ut.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to get status for transaction", e);
        }
        switch (s) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 3;
            }
        }
        return 2;
    }

    @Override
    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        if (this.tsr != null) {
            TransactionSynchronizationRegistryHelper.registerTransactionSynchronization(this.tsr, ts);
        } else if (this.tm != null) {
            try {
                this.tm.getTransaction().registerSynchronization((Synchronization)new JtaTransactionSynchronizationAdapter(ts));
            }
            catch (Exception e) {
                this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ", (Throwable)e);
            }
        } else {
            this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ");
        }
    }

    static {
        ClassLoader cl = JtaTransactionManager.class.getClassLoader();
        try {
            transactionSynchronizationRegistryClass = cl.loadClass(TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

