/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Date;
import org.drools.core.time.Trigger;
import org.kie.api.runtime.Calendars;

public class CompositeMaxDurationTrigger
implements Trigger {
    private Trigger timerTrigger;
    private Date maxDurationTimestamp;
    private Date timerCurrentDate;

    public CompositeMaxDurationTrigger(Date maxDurationTimestamp, Trigger timerTrigger, String[] calendarNames, Calendars calendars) {
        this.maxDurationTimestamp = maxDurationTimestamp;
        this.timerTrigger = timerTrigger;
        if (this.timerTrigger != null) {
            while (this.timerTrigger.hasNextFireTime() != null && this.timerTrigger.hasNextFireTime().getTime() <= this.maxDurationTimestamp.getTime()) {
                this.timerTrigger.nextFireTime();
            }
        }
    }

    @Override
    public Date hasNextFireTime() {
        if (this.maxDurationTimestamp != null) {
            return this.maxDurationTimestamp;
        }
        if (this.timerTrigger != null) {
            return this.timerTrigger.hasNextFireTime();
        }
        return null;
    }

    @Override
    public Date nextFireTime() {
        if (this.maxDurationTimestamp != null) {
            this.maxDurationTimestamp = null;
        }
        if (this.timerTrigger != null) {
            return this.timerTrigger.nextFireTime();
        }
        return null;
    }
}

