/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.kie.api.runtime.Environment;

public class JpaPersistenceContextManager
implements PersistenceContextManager {
    protected final Environment env;
    private final EntityManagerFactory emf;
    private volatile EntityManager appScopedEntityManager;
    protected final ThreadLocal<EntityManager> localInternalCmdScopedEntityManager = new ThreadLocal();
    private volatile boolean internalAppScopedEntityManagerFlag;
    private volatile boolean internalCmdScopedEntityManagerFlag;

    public JpaPersistenceContextManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @Override
    public PersistenceContext getApplicationScopedPersistenceContext() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                this.internalAppScopedEntityManagerFlag = true;
                this.appScopedEntityManager = this.emf.createEntityManager();
                this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.appScopedEntityManager);
            } else {
                this.internalAppScopedEntityManagerFlag = false;
            }
        }
        return new JpaPersistenceContext(this.appScopedEntityManager);
    }

    @Override
    public PersistenceContext getCommandScopedPersistenceContext() {
        return new JpaPersistenceContext(this.getInternalCommandScopedEntityManager());
    }

    @Override
    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager;
        boolean openInternalCSEM;
        EntityManager externalCmdScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
        EntityManager internalCmdScopedEntityManager = this.getInternalCommandScopedEntityManager();
        boolean bl = openInternalCSEM = internalCmdScopedEntityManager != null && internalCmdScopedEntityManager.isOpen();
        if (openInternalCSEM || externalCmdScopedEntityManager != null && externalCmdScopedEntityManager.isOpen()) {
            if (internalCmdScopedEntityManager != null) {
                cmdScopedEntityManager = internalCmdScopedEntityManager;
            } else {
                this.internalCmdScopedEntityManagerFlag = false;
                cmdScopedEntityManager = externalCmdScopedEntityManager;
                this.setInternalCommandScopedEntityManager(externalCmdScopedEntityManager);
            }
        } else {
            this.internalCmdScopedEntityManagerFlag = true;
            internalCmdScopedEntityManager = this.emf.createEntityManager();
            this.setInternalCommandScopedEntityManager(internalCmdScopedEntityManager);
            internalCmdScopedEntityManager.setFlushMode(FlushModeType.COMMIT);
            cmdScopedEntityManager = internalCmdScopedEntityManager;
        }
        cmdScopedEntityManager.joinTransaction();
        this.appScopedEntityManager.joinTransaction();
    }

    @Override
    public void endCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = this.getInternalCommandScopedEntityManager();
        if (this.internalCmdScopedEntityManagerFlag && cmdScopedEntityManager != null && cmdScopedEntityManager.isOpen()) {
            cmdScopedEntityManager.clear();
        }
    }

    @Override
    public void dispose() {
        if (this.internalAppScopedEntityManagerFlag) {
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
            }
            this.internalAppScopedEntityManagerFlag = false;
            this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", null);
            this.appScopedEntityManager = null;
        }
        if (this.internalCmdScopedEntityManagerFlag) {
            EntityManager cmdScopedEntityManager = this.getInternalCommandScopedEntityManager();
            if (cmdScopedEntityManager != null && cmdScopedEntityManager.isOpen()) {
                cmdScopedEntityManager.close();
            }
            this.internalCmdScopedEntityManagerFlag = false;
            this.setInternalCommandScopedEntityManager(null);
        }
    }

    protected EntityManager getInternalCommandScopedEntityManager() {
        return this.localInternalCmdScopedEntityManager.get();
    }

    protected void setInternalCommandScopedEntityManager(EntityManager entityManager) {
        this.localInternalCmdScopedEntityManager.set(entityManager);
    }
}

