/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.compiler.DroolsErrorWrapper;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.DroolsWarningWrapper;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.MVELDumper;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ConnectiveType;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.LiteralRestrictionDescr;
import org.drools.compiler.lang.descr.OperatorDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.compiler.lang.descr.ReturnValueRestrictionDescr;
import org.drools.compiler.rule.builder.ConstraintBuilder;
import org.drools.compiler.rule.builder.MVELConstraintBuilder;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.QueryElementBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.java.JavaDialect;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.IsAEvaluatorDefinition;
import org.drools.core.base.mvel.ActivationPropertyHandler;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateFieldExtractor;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.From;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Package;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.rule.Query;
import org.drools.core.rule.Rule;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.constraint.EvaluatorConstraint;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.AcceptsClassObjectType;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.time.TimeUtils;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.IndexUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.util.PropertyTools;

public class PatternBuilder
implements RuleConditionBuilder {
    private static final java.util.regex.Pattern evalRegexp = java.util.regex.Pattern.compile("^eval\\s*\\(", 8);
    private static final java.util.regex.Pattern identifierRegexp = java.util.regex.Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        boolean typeSafe = context.isTypesafe();
        try {
            RuleConditionElement ruleConditionElement = this.build(context, descr, null);
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        PropertyHandler handler;
        Pattern pattern;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        FactTemplateObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                if (!Modifier.isPublic(userProvidedClass.getModifiers())) {
                    context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "The class '" + patternDescr.getObjectType() + "' is not public"));
                    return null;
                }
                PackageRegistry pkgr = context.getPackageBuilder().getPackageRegistry(ClassUtils.getPackage((Class)userProvidedClass));
                Package pkg = pkgr == null ? context.getPkg() : pkgr.getPackage();
                boolean isEvent = pkg.isEvent(userProvidedClass);
                objectType = new ClassObjectType(userProvidedClass, isEvent);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (objectType == null) {
            RuleConditionElement rce = null;
            if (context.getRule().getName().equals(patternDescr.getObjectType())) {
                QueryElementBuilder qeBuilder = QueryElementBuilder.getInstance();
                rce = qeBuilder.build(context, descr, prefixPattern, (Query)context.getRule());
            }
            if (rce == null) {
                Rule rule = context.getPkg().getRule(patternDescr.getObjectType());
                if (rule instanceof Query) {
                    QueryElementBuilder qeBuilder = QueryElementBuilder.getInstance();
                    rce = qeBuilder.build(context, descr, prefixPattern, (Query)rule);
                }
                for (String importName : context.getDialect().getTypeResolver().getImports()) {
                    int pos = (importName = importName.trim()).indexOf(42);
                    if (pos < 0) continue;
                    String pkgName = importName.substring(0, pos - 1);
                    PackageRegistry pkgReg = context.getPackageBuilder().getPackageRegistry(pkgName);
                    if (pkgReg == null || !((rule = pkgReg.getPackage().getRule(patternDescr.getObjectType())) instanceof Query)) continue;
                    QueryElementBuilder qeBuilder = QueryElementBuilder.getInstance();
                    rce = qeBuilder.build(context, descr, prefixPattern, (Query)rule);
                    break;
                }
            }
            if (rce == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
            }
            return rce;
        }
        boolean duplicateBindings = context.getDeclarationResolver().isDuplicated(context.getRule(), patternDescr.getIdentifier(), ((ClassObjectType)objectType).getClassName());
        if (!StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier()) && !duplicateBindings) {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, patternDescr.getIdentifier(), patternDescr.isInternalFact());
            if (objectType instanceof ClassObjectType) {
                context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)pattern.getDeclaration().getExtractor());
            }
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, null);
        }
        if (ClassObjectType.Match_ObjectType.isAssignableFrom(pattern.getObjectType()) && (handler = PropertyHandlerFactory.getPropertyHandler(RuleTerminalNodeLeftTuple.class)) == null) {
            MVELCompilationUnit.PropertyHandlerFactoryFixer.getPropertyHandlerClass().put(RuleTerminalNodeLeftTuple.class, new ActivationPropertyHandler());
        }
        context.getBuildStack().push((RuleConditionElement)pattern);
        if (duplicateBindings) {
            this.processDuplicateBindings(patternDescr.isUnification(), patternDescr, pattern, patternDescr, "this", patternDescr.getIdentifier(), context);
        }
        if (objectType instanceof ClassObjectType) {
            context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)pattern);
        }
        if (pattern.getObjectType() instanceof ClassObjectType) {
            Class cls = ((ClassObjectType)pattern.getObjectType()).getClassType();
            if (cls.getPackage() != null && !cls.getPackage().getName().equals("java.lang")) {
                TypeDeclaration typeDeclr = context.getPackageBuilder().getAndRegisterTypeDeclaration(cls, cls.getPackage().getName());
                context.setTypesafe(typeDeclr == null || typeDeclr.isTypesafe());
            } else {
                context.setTypesafe(true);
            }
        }
        this.processAnnotations(context, patternDescr, pattern);
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(patternDescr.getSource().getClass());
            PatternSource source = (PatternSource)builder.build(context, patternDescr.getSource());
            if (source instanceof From) {
                ((From)source).setResultPattern(pattern);
            }
            pattern.setSource(source);
        }
        this.processConstraintsAndBinds(context, patternDescr, pattern);
        for (BehaviorDescr behaviorDescr : patternDescr.getBehaviors()) {
            if (pattern.getObjectType().isEvent()) {
                SlidingTimeWindow window;
                if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                    window = new SlidingTimeWindow(TimeUtils.parseTimeString((String)behaviorDescr.getParameters().get(0)));
                    pattern.addBehavior((Behavior)window);
                } else if (Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) {
                    window = new SlidingLengthWindow(Integer.valueOf(behaviorDescr.getParameters().get(0)).intValue());
                    pattern.addBehavior((Behavior)window);
                }
                context.setNeedStreamMode();
                continue;
            }
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "A Sliding Window can only be assigned to types declared with @role( event ). The type '" + pattern.getObjectType() + "' in '" + context.getRule().getName() + "' is not declared as an Event."));
        }
        context.getBuildStack().pop();
        return pattern;
    }

    protected void processDuplicateBindings(boolean isUnification, PatternDescr patternDescr, Pattern pattern, BaseDescr original, String leftExpression, String rightIdentifier, RuleBuildContext context) {
        if (isUnification) {
            this.build(context, patternDescr, pattern, original, leftExpression + " == " + rightIdentifier);
        } else {
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate declaration for variable '" + rightIdentifier + "' in the rule '" + context.getRule().getName() + "'"));
        }
    }

    protected void processAnnotations(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        Map<String, AnnotationDescr> annotationMap = patternDescr.getAnnotations();
        if (annotationMap == null) {
            return;
        }
        this.processListenedPropertiesAnnotation(context, patternDescr, pattern, annotationMap);
        this.processMetadataAnnotations(pattern, annotationMap);
    }

    protected void processMetadataAnnotations(Pattern pattern, Map<String, AnnotationDescr> annotationMap) {
        for (String key : annotationMap.keySet()) {
            if ("watch".equals(key)) continue;
            AnnotationDescr ann = annotationMap.get(key);
            AnnotationDefinition def = new AnnotationDefinition(key);
            for (String propKey : ann.getValues().keySet()) {
                def.getValues().put(propKey, new AnnotationDefinition.AnnotationPropertyVal(propKey, null, (Object)ann.getValue(propKey), null));
            }
            pattern.getAnnotations().put(key, def);
        }
    }

    protected void processListenedPropertiesAnnotation(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, Map<String, AnnotationDescr> annotationMap) {
        AnnotationDescr listenedProps = annotationMap.get("watch");
        if (listenedProps != null) {
            List<String> settableProperties = this.getSettableProperties(context, patternDescr, pattern);
            ArrayList<String> listenedProperties = new ArrayList<String>();
            for (String propertyName : listenedProps.getValue().toString().split(",")) {
                if ((propertyName = propertyName.trim()).equals("*") || propertyName.equals("!*")) {
                    if (listenedProperties.contains("*") || listenedProperties.contains("!*")) {
                        context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate usage of wildcard * in @watch annotation"));
                        continue;
                    }
                    listenedProperties.add(propertyName);
                    continue;
                }
                boolean isNegative = propertyName.startsWith("!");
                String string = propertyName = isNegative ? propertyName.substring(1).trim() : propertyName;
                if (settableProperties != null && !settableProperties.contains(propertyName)) {
                    context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unknown property " + propertyName + " in @" + "watch" + " annotation"));
                    continue;
                }
                if (listenedProperties.contains(propertyName) || listenedProperties.contains("!" + propertyName)) {
                    context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Duplicate property " + propertyName + " in @" + "watch" + " annotation"));
                    continue;
                }
                listenedProperties.add(isNegative ? "!" + propertyName : propertyName);
            }
            for (Constraint constr : pattern.getConstraints()) {
                EvaluatorConstraint ec;
                if (!(constr instanceof EvaluatorConstraint) || !((EvaluatorConstraint)constr).isSelf() || (ec = (EvaluatorConstraint)constr).getEvaluator().getOperator() != IsAEvaluatorDefinition.ISA && ec.getEvaluator().getOperator() != IsAEvaluatorDefinition.NOT_ISA) continue;
                listenedProperties.add("__$$dynamic_traits_map$$");
            }
            pattern.setListenedProperties(listenedProperties);
        }
    }

    protected List<String> getSettableProperties(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        ObjectType patternType = pattern.getObjectType();
        if (!(patternType instanceof ClassObjectType)) {
            return null;
        }
        Class patternClass = ((ClassObjectType)patternType).getClassType();
        TypeDeclaration typeDeclaration = this.getTypeDeclarationForPattern(context, pattern);
        if (!typeDeclaration.isPropertyReactive()) {
            context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Wrong usage of @watch annotation on class " + patternClass.getName() + " that is not annotated as @PropertyReactive"));
        }
        typeDeclaration.setTypeClass(patternClass);
        return typeDeclaration.getSettableProperties();
    }

    private TypeDeclaration getTypeDeclarationForPattern(RuleBuildContext context, Pattern pattern) {
        ObjectType patternType = pattern.getObjectType();
        if (!(patternType instanceof ClassObjectType)) {
            return null;
        }
        Class patternClass = ((ClassObjectType)patternType).getClassType();
        return context.getPackageBuilder().getTypeDeclaration(patternClass);
    }

    protected void processConstraintsAndBinds(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext().setRuleContext(context);
        for (BaseDescr baseDescr : patternDescr.getDescrs()) {
            String expression;
            boolean isPositional = false;
            if (baseDescr instanceof BindingDescr) {
                BindingDescr bind = (BindingDescr)baseDescr;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
            } else if (baseDescr instanceof ExprConstraintDescr) {
                ExprConstraintDescr descr = (ExprConstraintDescr)baseDescr;
                expression = descr.getExpression();
                isPositional = descr.getType() == ExprConstraintDescr.Type.POSITIONAL;
            } else {
                expression = baseDescr.getText();
            }
            ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, baseDescr, expression);
            if (result == null) {
                return;
            }
            if (isPositional &= result.getDescrs().size() != 1 || !(result.getDescrs().get(0) instanceof BindingDescr)) {
                this.processPositional(context, patternDescr, pattern, (ExprConstraintDescr)baseDescr);
                continue;
            }
            this.build(context, patternDescr, pattern, result, mvelCtx);
        }
        this.combineConstraints(context, pattern, mvelCtx);
    }

    private void combineConstraints(RuleBuildContext context, Pattern pattern, MVELDumper.MVELDumperContext mvelCtx) {
        List combinableConstraints = pattern.getCombinableConstraints();
        if (combinableConstraints == null || combinableConstraints.size() < 2) {
            return;
        }
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        HashSet<String> declarationNames = new HashSet<String>();
        boolean isFirst = true;
        String packageName = null;
        StringBuilder expressionBuilder = new StringBuilder(combinableConstraints.size() * 25);
        for (MvelConstraint constraint : combinableConstraints) {
            boolean isComplex;
            pattern.removeConstraint((Constraint)constraint);
            if (isFirst) {
                packageName = constraint.getPackageName();
                isFirst = false;
            } else {
                expressionBuilder.append(" && ");
            }
            String constraintExpression = constraint.getExpression();
            boolean bl = isComplex = constraintExpression.contains("&&") || constraintExpression.contains("||");
            if (isComplex) {
                expressionBuilder.append("( ");
            }
            expressionBuilder.append(constraintExpression);
            if (isComplex) {
                expressionBuilder.append(" )");
            }
            for (Declaration declaration : constraint.getRequiredDeclarations()) {
                if (!declarationNames.add(declaration.getBindingName())) continue;
                declarations.add(declaration);
            }
        }
        String expression = expressionBuilder.toString();
        MVELCompilationUnit compilationUnit = PatternBuilder.getConstraintBuilder(context).buildCompilationUnit(context, pattern, expression, mvelCtx.getAliases());
        Constraint combinedConstraint = PatternBuilder.getConstraintBuilder(context).buildMvelConstraint(packageName, expression, declarations.toArray(new Declaration[declarations.size()]), compilationUnit, IndexUtil.ConstraintType.UNKNOWN, null, null, false);
        pattern.addConstraint(combinedConstraint);
    }

    protected void processPositional(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, ExprConstraintDescr descr) {
        if (descr.getType() == ExprConstraintDescr.Type.POSITIONAL && pattern.getObjectType() instanceof ClassObjectType) {
            Class klazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration tDecl = context.getPackageBuilder().getTypeDeclaration(klazz);
            if (tDecl == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, klazz, "Unable to find @positional definitions for :" + klazz + "\n"));
                return;
            }
            ClassDefinition clsDef = tDecl.getTypeClassDef();
            if (clsDef == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n"));
                return;
            }
            FieldDefinition field = clsDef.getField(descr.getPosition());
            if (field == null) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n"));
                return;
            }
            String expr = descr.getExpression();
            boolean isSimpleIdentifier = StringUtils.isIdentifier((String)expr);
            if (isSimpleIdentifier) {
                BindingDescr binder = new BindingDescr();
                binder.setUnification(true);
                binder.setExpression(field.getName());
                binder.setVariable(descr.getExpression());
                this.buildRuleBindings(context, patternDescr, pattern, binder);
            } else {
                this.build(context, patternDescr, pattern, descr, field.getName() + " == " + descr.getExpression());
            }
        }
    }

    protected void build(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BaseDescr original, String expr) {
        ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, original, expr);
        if (result == null) {
            return;
        }
        result.copyLocation(original);
        MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext().setRuleContext(context);
        this.build(context, patternDescr, pattern, result, mvelCtx);
    }

    protected void build(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, ConstraintConnectiveDescr descr, MVELDumper.MVELDumperContext mvelCtx) {
        ArrayList<BaseDescr> initialDescrs = new ArrayList<BaseDescr>(descr.getDescrs());
        for (BaseDescr d : initialDescrs) {
            this.buildCcdDescr(context, patternDescr, pattern, d, descr, mvelCtx);
        }
        if (descr.getDescrs().size() > initialDescrs.size()) {
            ArrayList<BaseDescr> additionalDescrs = new ArrayList<BaseDescr>(descr.getDescrs());
            additionalDescrs.removeAll(initialDescrs);
            if (!additionalDescrs.isEmpty()) {
                ArrayList constraints = new ArrayList(pattern.getConstraints());
                for (Constraint c : constraints) {
                    pattern.removeConstraint(c);
                }
                for (BaseDescr d : additionalDescrs) {
                    this.buildCcdDescr(context, patternDescr, pattern, d, descr, mvelCtx);
                }
                for (Constraint c : constraints) {
                    pattern.addConstraint(c);
                }
            }
        }
    }

    protected void buildCcdDescr(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BaseDescr d, ConstraintConnectiveDescr ccd, MVELDumper.MVELDumperContext mvelCtx) {
        d.copyLocation(patternDescr);
        mvelCtx.clear();
        String expr = context.getCompilerFactory().getExpressionProcessor().dump(d, ccd, mvelCtx);
        Map<String, OperatorDescr> aliases = mvelCtx.getAliases();
        for (BindingDescr bind : mvelCtx.getBindings()) {
            this.buildRuleBindings(context, patternDescr, pattern, bind);
        }
        if (expr.length() == 0 || this.processAtomicExpression(context, pattern, d, expr, aliases)) {
            return;
        }
        this.buildExpression(context, pattern, d, expr, aliases);
    }

    protected void buildExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases) {
        RelationalExprDescr relDescr = d instanceof RelationalExprDescr ? (RelationalExprDescr)d : null;
        boolean simple = this.isSimpleExpr(relDescr);
        if (simple && !ClassObjectType.Map_ObjectType.isAssignableFrom(pattern.getObjectType()) && !ClassObjectType.Match_ObjectType.isAssignableFrom(pattern.getObjectType())) {
            this.buildRelationalExpression(context, pattern, relDescr, expr, aliases);
        } else {
            this.createAndBuildPredicate(context, pattern, d, this.rewriteOrExpressions(context, pattern, d, expr), aliases);
        }
    }

    private String rewriteOrExpressions(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr) {
        if (!(d instanceof ConstraintConnectiveDescr) || ((ConstraintConnectiveDescr)d).getConnective() != ConnectiveType.OR) {
            return expr;
        }
        List<BaseDescr> subDescrs = ((ConstraintConnectiveDescr)d).getDescrs();
        for (BaseDescr subDescr : subDescrs) {
            if (subDescr instanceof RelationalExprDescr && this.isSimpleExpr((RelationalExprDescr)subDescr)) continue;
            return expr;
        }
        String[] subExprs = expr.split("\\Q||\\E");
        if (subExprs.length != subDescrs.size()) {
            return expr;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (BaseDescr subDescr : subDescrs) {
            String normalizedExpr;
            RelationalExprDescr relDescr = (RelationalExprDescr)subDescr;
            String[] values = new String[2];
            this.findExpressionValues(relDescr, values);
            if (!this.getExprBindings(context, pattern, values[1]).isConstant()) {
                normalizedExpr = subExprs[i++];
            } else {
                InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, relDescr, pattern.getObjectType(), values[0], null, true);
                if (extractor == null) {
                    normalizedExpr = subExprs[i++];
                } else {
                    ValueType vtype = extractor.getValueType();
                    LiteralRestrictionDescr restrictionDescr = new LiteralRestrictionDescr(relDescr.getOperator(), relDescr.isNegated(), relDescr.getParameters(), values[1], 3);
                    normalizedExpr = MVELConstraintBuilder.normalizeMVELLiteralExpression(vtype, this.getFieldValue(context, vtype, restrictionDescr), subExprs[i++], values[0], relDescr.getOperator(), values[1], restrictionDescr);
                }
            }
            sb.append(normalizedExpr);
            if (i >= subExprs.length) continue;
            sb.append(" || ");
        }
        return sb.toString();
    }

    protected void buildRelationalExpression(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, Map<String, OperatorDescr> aliases) {
        String[] values = new String[2];
        boolean usesThisRef = this.findExpressionValues(relDescr, values);
        ExprBindings value1Expr = this.getExprBindings(context, pattern, values[0]);
        ExprBindings value2Expr = this.getExprBindings(context, pattern, values[1]);
        if (!usesThisRef && value1Expr.isConstant() || !this.addConstraintToPattern(context, pattern, relDescr, expr, values[0], values[1], value2Expr.isConstant())) {
            this.createAndBuildPredicate(context, pattern, relDescr, expr, aliases);
        }
    }

    private ExprBindings getExprBindings(RuleBuildContext context, Pattern pattern, String value) {
        ExprBindings value1Expr = new ExprBindings();
        this.setInputs(context, value1Expr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value);
        return value1Expr;
    }

    private boolean findExpressionValues(RelationalExprDescr relDescr, String[] values) {
        boolean usesThisRef;
        BaseDescr rdescr;
        if (relDescr.getRight() instanceof AtomicExprDescr) {
            rdescr = (AtomicExprDescr)relDescr.getRight();
            values[1] = ((AtomicExprDescr)rdescr).getRewrittenExpression().trim();
            usesThisRef = "this".equals(values[1]) || values[1].startsWith("this.");
        } else {
            rdescr = (BindingDescr)relDescr.getRight();
            values[1] = ((BindingDescr)rdescr).getExpression().trim();
            boolean bl = usesThisRef = "this".equals(values[1]) || values[1].startsWith("this.");
        }
        if (relDescr.getLeft() instanceof AtomicExprDescr) {
            AtomicExprDescr ldescr = (AtomicExprDescr)relDescr.getLeft();
            values[0] = ldescr.getRewrittenExpression();
            usesThisRef = usesThisRef || "this".equals(values[0]) || values[0].startsWith("this.");
        } else {
            values[0] = ((BindingDescr)relDescr.getLeft()).getExpression();
            usesThisRef = usesThisRef || "this".equals(values[0]) || values[0].startsWith("this.");
        }
        return usesThisRef;
    }

    protected boolean addConstraintToPattern(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, String value1, String value2, boolean isConstant) {
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, relDescr, pattern.getObjectType(), value1, null, true);
        return extractor != null && this.addConstraintToPattern(context, pattern, relDescr, expr, value1, value2, isConstant, extractor);
    }

    protected boolean addConstraintToPattern(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, String value1, String value2, boolean isConstant, InternalReadAccessor extractor) {
        String[] parts;
        Constraint constraint;
        FieldValue field;
        int dotPos = value1.indexOf(46);
        if (dotPos > 0) {
            String part0 = value1.substring(0, dotPos).trim();
            if ("this".equals(part0.trim())) {
                value1 = value1.substring(dotPos + 1);
            } else if (pattern.getDeclaration() != null && part0.equals(pattern.getDeclaration().getIdentifier())) {
                value1 = value1.substring(dotPos + 1);
                expr = expr.substring(dotPos + 1);
            }
        }
        ValueType vtype = extractor.getValueType();
        String operator = relDescr.getOperator().trim();
        LiteralRestrictionDescr restrictionDescr = this.buildLiteralRestrictionDescr(context, relDescr, value2, operator, isConstant);
        if (restrictionDescr != null && (field = this.getFieldValue(context, vtype, restrictionDescr)) != null && (constraint = PatternBuilder.getConstraintBuilder(context).buildLiteralConstraint(context, pattern, vtype, field, expr, value1, operator, value2, extractor, restrictionDescr)) != null) {
            pattern.addConstraint(constraint);
            return true;
        }
        Declaration declr = null;
        if (value2.indexOf(40) < 0 && value2.indexOf(46) < 0 && value2.indexOf(91) < 0 && (declr = context.getDeclarationResolver().getDeclaration(context.getRule(), value2)) == null) {
            Pattern thisPattern = (Pattern)context.getBuildStack().peek();
            declr = PatternBuilder.createDeclarationObject(context, value2, thisPattern);
        }
        Declaration[] declarations = null;
        if (declr == null && (parts = value2.split("\\.")).length == 2) {
            if ("this".equals(parts[0].trim())) {
                declr = PatternBuilder.createDeclarationObject(context, parts[1].trim(), (Pattern)context.getBuildStack().peek());
                value2 = parts[1].trim();
            } else {
                declr = context.getDeclarationResolver().getDeclaration(context.getRule(), parts[0].trim());
                if (declr != null) {
                    if (declr.isPatternDeclaration()) {
                        declarations = new Declaration[]{declr};
                        declr = PatternBuilder.createDeclarationObject(context, parts[1].trim(), declr.getPattern());
                        value2 = parts[1].trim();
                    } else {
                        return false;
                    }
                }
            }
        }
        if (declarations == null) {
            if (declr != null) {
                declarations = new Declaration[]{declr};
            } else {
                declarations = this.getDeclarationsForReturnValue(context, relDescr, operator, value2);
                if (declarations == null) {
                    return false;
                }
            }
        }
        pattern.addConstraint(PatternBuilder.getConstraintBuilder(context).buildVariableConstraint(context, pattern, expr, declarations, value1, relDescr.getOperatorDescr(), value2, extractor, declr, relDescr));
        return true;
    }

    private Declaration[] getDeclarationsForReturnValue(RuleBuildContext context, RelationalExprDescr relDescr, String operator, String value2) {
        Pattern pattern = (Pattern)context.getBuildStack().peek();
        ReturnValueRestrictionDescr returnValueRestrictionDescr = new ReturnValueRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParametersText(), value2);
        Map<String, Class<?>> declarationsMap = PatternBuilder.getDeclarationsMap(returnValueRestrictionDescr, context, true);
        Class thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        AnalysisResult analysis = context.getDialect().analyzeExpression(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent(), new BoundIdentifiers(declarationsMap, globals, null, thisClass));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), usedIdentifiers, factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        Declaration[] requiredDeclarations = new Declaration[previousDeclarations.length + localDeclarations.length];
        System.arraycopy(previousDeclarations, 0, requiredDeclarations, 0, previousDeclarations.length);
        System.arraycopy(localDeclarations, 0, requiredDeclarations, previousDeclarations.length, localDeclarations.length);
        Declaration[] declarations = new Declaration[requiredDeclarations.length + requiredGlobals.length];
        int i = 0;
        for (Declaration declaration : requiredDeclarations) {
            declarations[i++] = declaration;
        }
        for (String string : requiredGlobals) {
            declarations[i++] = context.getDeclarationResolver().getDeclaration(context.getRule(), string);
        }
        return declarations;
    }

    protected LiteralRestrictionDescr buildLiteralRestrictionDescr(RuleBuildContext context, RelationalExprDescr exprDescr, String rightValue, String operator, boolean isRightLiteral) {
        if (isRightLiteral) {
            return new LiteralRestrictionDescr(operator, exprDescr.isNegated(), exprDescr.getParameters(), rightValue, 3);
        }
        int dotPos = rightValue.lastIndexOf(46);
        if (dotPos >= 0) {
            String mainPart = rightValue.substring(0, dotPos);
            String lastPart = rightValue.substring(dotPos + 1);
            try {
                context.getDialect().getTypeResolver().resolveType(mainPart);
                if (lastPart.indexOf(40) < 0 && lastPart.indexOf(46) < 0 && lastPart.indexOf(91) < 0) {
                    return new LiteralRestrictionDescr(operator, exprDescr.isNegated(), exprDescr.getParameters(), rightValue, 3);
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean processAtomicExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases) {
        Matcher m;
        if (d instanceof AtomicExprDescr && (m = evalRegexp.matcher(((AtomicExprDescr)d).getExpression())).find()) {
            PredicateDescr pdescr = new PredicateDescr(context.getRuleDescr().getResource(), expr);
            pdescr.copyLocation(d);
            this.buildEval(context, pattern, pdescr, aliases, expr, true);
            return true;
        }
        return false;
    }

    protected boolean isSimpleExpr(RelationalExprDescr relDescr) {
        boolean simple = false;
        if (relDescr != null && (relDescr.getLeft() instanceof AtomicExprDescr || relDescr.getLeft() instanceof BindingDescr) && (relDescr.getRight() instanceof AtomicExprDescr || relDescr.getRight() instanceof BindingDescr)) {
            simple = true;
        }
        return simple;
    }

    protected void createAndBuildPredicate(RuleBuildContext context, Pattern pattern, BaseDescr base, String expr, Map<String, OperatorDescr> aliases) {
        Dialect dialect = context.getDialect();
        MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
        context.setDialect(mvelDialect);
        PredicateDescr pdescr = new PredicateDescr(context.getRuleDescr().getResource(), expr);
        pdescr.copyParameters(base);
        pdescr.copyLocation(base);
        this.buildEval(context, pattern, pdescr, aliases, expr, false);
        context.setDialect(dialect);
    }

    protected void setInputs(RuleBuildContext context, ExprBindings descrBranch, Class<?> thisClass, String expr) {
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
        ParserConfiguration conf = data.getParserConfiguration();
        conf.setClassLoader(context.getPackageBuilder().getRootClassLoader());
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(false);
        pctx.setStrongTyping(false);
        pctx.addInput("this", thisClass);
        pctx.addInput("empty", Boolean.TYPE);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        try {
            MVEL.analysisCompile((String)expr, (ParserContext)pctx);
        }
        catch (Exception e) {
            return;
        }
        if (!pctx.getInputs().isEmpty()) {
            for (String v : pctx.getInputs().keySet()) {
                if ("this".equals(v) || PropertyTools.getFieldOrAccessor(thisClass, (String)v) != null && expr.matches("(^|.*\\W)empty($|\\W.*)")) {
                    descrBranch.getFieldAccessors().add(v);
                    continue;
                }
                if ("empty".equals(v)) continue;
                if (!context.getPkg().getGlobals().containsKey(v)) {
                    descrBranch.getRuleBindings().add(v);
                    continue;
                }
                descrBranch.getGlobalBindings().add(v);
            }
        }
    }

    protected void buildRuleBindings(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern, BindingDescr fieldBindingDescr) {
        ObjectType patternType;
        if (context.getDeclarationResolver().isDuplicated(context.getRule(), fieldBindingDescr.getVariable(), null)) {
            this.processDuplicateBindings(fieldBindingDescr.isUnification(), patternDescr, pattern, fieldBindingDescr, fieldBindingDescr.getBindingField(), fieldBindingDescr.getVariable(), context);
            if (fieldBindingDescr.isUnification()) {
                return;
            }
        }
        Declaration declr = pattern.addDeclaration(fieldBindingDescr.getVariable());
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getBindingField(), (AcceptsReadAccessor)declr, true);
        declr.setReadAccessor(extractor);
        if (extractor instanceof ClassFieldReader && (patternType = pattern.getObjectType()) instanceof ClassObjectType) {
            Class patternClass = ((ClassObjectType)patternType).getClassType();
            TypeDeclaration typeDeclaration = context.getPackageBuilder().getTypeDeclaration(patternClass);
            String fieldName = ((ClassFieldReader)extractor).getFieldName();
            if (typeDeclaration.getSettableProperties().contains(fieldName)) {
                ArrayList<String> watchlist = pattern.getListenedProperties();
                if (watchlist == null) {
                    watchlist = new ArrayList<String>();
                    pattern.setListenedProperties(watchlist);
                }
                watchlist.add(fieldName);
            }
        }
    }

    protected void buildEval(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases, String expr, boolean isEvalExpression) {
        boolean isJavaEval;
        AnalysisResult analysis = PatternBuilder.buildAnalysis(context, pattern, predicateDescr, aliases);
        if (analysis == null) {
            return;
        }
        Declaration[][] usedDeclarations = PatternBuilder.getUsedDeclarations(context, pattern, analysis);
        Declaration[] previousDeclarations = usedDeclarations[0];
        Declaration[] localDeclarations = usedDeclarations[1];
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        String[] requiredOperators = usedIdentifiers.getOperators().keySet().toArray(new String[usedIdentifiers.getOperators().size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        boolean bl = isJavaEval = isEvalExpression && context.getDialect() instanceof JavaDialect;
        if (isJavaEval) {
            PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals, requiredOperators);
            PredicateBuilder builder = context.getDialect().getPredicateBuilder();
            builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr, analysis);
            pattern.addConstraint((Constraint)predicateConstraint);
        } else {
            MVELCompilationUnit compilationUnit = PatternBuilder.getConstraintBuilder(context).buildCompilationUnit(context, previousDeclarations, localDeclarations, predicateDescr, analysis);
            Declaration[] mvelDeclarations = new Declaration[previousDeclarations.length + localDeclarations.length + requiredGlobals.length];
            int i = 0;
            for (Declaration declaration : previousDeclarations) {
                mvelDeclarations[i++] = declaration;
            }
            for (Declaration declaration : localDeclarations) {
                mvelDeclarations[i++] = declaration;
            }
            for (String string : requiredGlobals) {
                mvelDeclarations[i++] = context.getDeclarationResolver().getDeclaration(context.getRule(), string);
            }
            boolean bl2 = requiredOperators.length > 0 || ClassObjectType.Match_ObjectType.isAssignableFrom(pattern.getObjectType()) || !((ClassObjectType)pattern.getObjectType()).getClassType().isArray() && !context.getPackageBuilder().getTypeDeclaration(((ClassObjectType)pattern.getObjectType()).getClassType()).isTypesafe();
            Constraint constraint = PatternBuilder.getConstraintBuilder(context).buildMvelConstraint(context.getPkg().getName(), expr, mvelDeclarations, compilationUnit, bl2);
            pattern.addConstraint(constraint);
        }
    }

    public static Declaration[][] getUsedDeclarations(RuleBuildContext context, Pattern pattern, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), analysis.getBoundIdentifiers(), factDeclarations);
        Declaration[][] usedDeclarations = new Declaration[][]{tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]), factDeclarations.toArray(new Declaration[factDeclarations.size()])};
        return usedDeclarations;
    }

    public static AnalysisResult buildAnalysis(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases) {
        Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(predicateDescr, context, true);
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        HashMap<String, EvaluatorWrapper> operators = aliases == null ? new HashMap<String, EvaluatorWrapper>() : PatternBuilder.buildOperators(context, pattern, predicateDescr, aliases);
        Class thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        return context.getDialect().analyzeExpression(context, predicateDescr, predicateDescr.getContent(), new BoundIdentifiers(declarations, globals, operators, thisClass));
    }

    protected static Map<String, EvaluatorWrapper> buildOperators(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases) {
        HashMap<String, EvaluatorWrapper> operators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, OperatorDescr> entry : aliases.entrySet()) {
            OperatorDescr op = entry.getValue();
            Declaration leftDecl = PatternBuilder.createDeclarationForOperator(context, pattern, op.getLeftString());
            Declaration rightDecl = PatternBuilder.createDeclarationForOperator(context, pattern, op.getRightString());
            EvaluatorDefinition.Target left = leftDecl != null && leftDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            EvaluatorDefinition.Target right = rightDecl != null && rightDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            op.setLeftIsHandle(left == EvaluatorDefinition.Target.HANDLE);
            op.setRightIsHandle(right == EvaluatorDefinition.Target.HANDLE);
            Evaluator evaluator = PatternBuilder.getConstraintBuilder(context).getEvaluator(context, predicateDescr, ValueType.OBJECT_TYPE, op.getOperator(), false, op.getParametersText(), left, right);
            EvaluatorWrapper wrapper = PatternBuilder.getConstraintBuilder(context).wrapEvaluator(evaluator, leftDecl, rightDecl);
            operators.put(entry.getKey(), wrapper);
        }
        return operators;
    }

    private static Declaration createDeclarationForOperator(RuleBuildContext context, Pattern pattern, String expr) {
        Object declaration = null;
        int dotPos = expr.indexOf(46);
        if (dotPos < 0) {
            if (!StringUtils.isIdentifier((String)expr)) {
                return null;
            }
            declaration = context.getDeclarationResolver().getDeclaration(context.getRule(), expr);
            if (declaration == null) {
                if ("this".equals(expr)) {
                    declaration = PatternBuilder.createDeclarationObject(context, "this", pattern);
                } else {
                    declaration = new Declaration("this", pattern);
                    context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)pattern.getObjectType()).getClassName(), expr, (AcceptsReadAccessor)declaration);
                }
            }
        } else {
            String part1 = expr.substring(0, dotPos).trim();
            String part2 = expr.substring(dotPos + 1).trim();
            if ("this".equals(part1)) {
                declaration = PatternBuilder.createDeclarationObject(context, part2, (Pattern)context.getBuildStack().peek());
            } else {
                declaration = context.getDeclarationResolver().getDeclaration(context.getRule(), part1);
                if (declaration != null) {
                    declaration = declaration.isPatternDeclaration() ? PatternBuilder.createDeclarationObject(context, part2, declaration.getPattern()) : null;
                }
            }
        }
        return declaration;
    }

    public static Map<String, Class<?>> getDeclarationsMap(BaseDescr baseDescr, RuleBuildContext context, boolean reportError) {
        HashMap declarations = new HashMap();
        for (Map.Entry entry : context.getDeclarationResolver().getDeclarations(context.getRule()).entrySet()) {
            if (((Declaration)entry.getValue()).getExtractor() == null) {
                if (!reportError) continue;
                context.addError(new DescrBuildError(context.getParentDescr(), baseDescr, null, "Field Reader does not exist for declaration '" + (String)entry.getKey() + "' in '" + baseDescr + "' in the rule '" + context.getRule().getName() + "'"));
                continue;
            }
            declarations.put((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
        }
        return declarations;
    }

    protected static ConstraintBuilder getConstraintBuilder(RuleBuildContext context) {
        return context.getCompilerFactory().getConstraintBuilderFactoryService().newConstraintBuilder();
    }

    public static void createImplicitBindings(RuleBuildContext context, Pattern pattern, Set<String> unboundIdentifiers, BoundIdentifiers boundIdentifiers, List<Declaration> factDeclarations) {
        Iterator<String> it = unboundIdentifiers.iterator();
        while (it.hasNext()) {
            String identifier = it.next();
            Declaration declaration = PatternBuilder.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
            if (boundIdentifiers.getDeclarations() == null) {
                boundIdentifiers.setDeclarations(new HashMap<String, Declaration>());
            }
            boundIdentifiers.getDeclarations().put(identifier, declaration);
            boundIdentifiers.getDeclrClasses().put(identifier, declaration.getExtractor().getExtractToClass());
            it.remove();
        }
    }

    protected static Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        return PatternBuilder.createDeclarationObject(context, identifier, identifier, pattern);
    }

    protected static Declaration createDeclarationObject(RuleBuildContext context, String identifier, String expr, Pattern pattern) {
        BindingDescr implicitBinding = new BindingDescr(identifier, expr);
        Declaration declaration = new Declaration(identifier, null, pattern, true);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getExpression(), (AcceptsReadAccessor)declaration, false);
        if (extractor == null) {
            return null;
        }
        declaration.setReadAccessor(extractor);
        return declaration;
    }

    protected FieldValue getFieldValue(RuleBuildContext context, ValueType vtype, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        try {
            String value = literalRestrictionDescr.getText().trim();
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
            MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            ParserConfiguration pconf = data.getParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            Object o = MVEL.executeExpression((Object)MVEL.compileExpression((String)value, (ParserContext)pctx));
            if (o != null && vtype == null) {
                vtype = ValueType.determineValueType(o.getClass());
            }
            field = context.getCompilerFactory().getFieldFactory().getFieldValue(o, vtype, context.getPackageBuilder().getDateFormats());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return field;
    }

    public static void registerReadAccessor(RuleBuildContext context, ObjectType objectType, String fieldName, AcceptsReadAccessor target) {
        if (!ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        FactTemplateFieldExtractor reader;
        block26: {
            if (ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
                FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
                reader = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
                if (target != null) {
                    target.setReadAccessor((InternalReadAccessor)reader);
                }
            } else if (!identifierRegexp.matcher(fieldName).matches() || fieldName.indexOf(46) > -1 || fieldName.indexOf(91) > -1 || fieldName.indexOf(40) > -1) {
                Dialect dialect = context.getDialect();
                try {
                    MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                    context.setDialect(mvelDialect);
                    Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(descr, context, false);
                    Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
                    AnalysisResult analysis = context.getDialect().analyzeExpression(context, descr, fieldName, new BoundIdentifiers(declarations, globals, null, ((ClassObjectType)objectType).getClassType()));
                    if (analysis == null) {
                        if (reportError) {
                            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to analyze expression '" + fieldName + "'"));
                        }
                        InternalReadAccessor internalReadAccessor = null;
                        return internalReadAccessor;
                    }
                    BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
                    if (!usedIdentifiers.getDeclrClasses().isEmpty()) {
                        if (reportError && descr instanceof BindingDescr) {
                            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Variables can not be used inside bindings. Variable " + usedIdentifiers.getDeclrClasses().keySet() + " is being used in binding '" + fieldName + "'"));
                        }
                        InternalReadAccessor internalReadAccessor = null;
                        return internalReadAccessor;
                    }
                    reader = context.getPkg().getClassFieldAccessorStore().getMVELReader(context.getPkg().getName(), ((ClassObjectType)objectType).getClassName(), fieldName, context.isTypesafe(), ((MVELAnalysisResult)analysis).getReturnType());
                    MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
                    ((MVELCompileable)reader).compile(data);
                    data.addCompileable((MVELCompileable)reader);
                }
                catch (Exception e) {
                    if (reportError) {
                        DialectUtil.copyErrorLocation(e, descr);
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create reader for '" + fieldName + "':" + e.getMessage()));
                    }
                    reader = null;
                }
                finally {
                    context.setDialect(dialect);
                }
            } else {
                Declaration decl = (Declaration)context.getDeclarationResolver().getDeclarations(context.getRule()).get(fieldName);
                if (decl != null && decl.getExtractor() instanceof ClassFieldReader && "this".equals(((ClassFieldReader)decl.getExtractor()).getFieldName())) {
                    return decl.getExtractor();
                }
                boolean alternatives = false;
                try {
                    Map<String, Class<?>> declarations = PatternBuilder.getDeclarationsMap(descr, context, false);
                    Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
                    alternatives = declarations.containsKey(fieldName) || globals.containsKey(fieldName);
                    reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
                }
                catch (Exception e) {
                    if (reportError && !alternatives && context.isTypesafe()) {
                        DialectUtil.copyErrorLocation(e, descr);
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create Field Extractor for '" + fieldName + "'" + e.getMessage()));
                    }
                    reader = null;
                    return reader;
                }
                finally {
                    Collection results;
                    if (!reportError || alternatives || (results = context.getPkg().getClassFieldAccessorStore().getWiringResults(((ClassObjectType)objectType).getClassType(), fieldName)).isEmpty()) break block26;
                    for (KnowledgeBuilderResult res : results) {
                        if (res.getSeverity() == ResultSeverity.ERROR) {
                            context.addError(new DroolsErrorWrapper(res));
                            continue;
                        }
                        context.addWarning(new DroolsWarningWrapper(res));
                    }
                }
            }
        }
        return reader;
    }

    protected ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, BaseDescr original, String expression) {
        DrlExprParser parser = new DrlExprParser(context.getConfiguration().getLanguageLevel());
        ConstraintConnectiveDescr result = parser.parse(expression);
        result.copyLocation(original);
        if (parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return null;
        }
        return result;
    }

    public static class ExprBindings {
        protected Set<String> globalBindings = new HashSet<String>();
        protected Set<String> ruleBindings = new HashSet<String>();
        protected Set<String> fieldAccessors = new HashSet<String>();

        public Set<String> getGlobalBindings() {
            return this.globalBindings;
        }

        public Set<String> getRuleBindings() {
            return this.ruleBindings;
        }

        public Set<String> getFieldAccessors() {
            return this.fieldAccessors;
        }

        public boolean isConstant() {
            return this.globalBindings.isEmpty() && this.ruleBindings.isEmpty() && this.fieldAccessors.size() <= 1;
        }
    }
}

