/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.lang.reflect.Constructor;
import java.util.Date;
import org.drools.core.RuleBase;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.CommandService;
import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.command.impl.DefaultCommandService;
import org.drools.core.command.impl.FixedKnowledgeCommandContext;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.command.runtime.DisposeCommand;
import org.drools.core.common.EndOperationListener;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.marshalling.impl.MarshallingConfigurationImpl;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.SessionMarshallingHelper;
import org.drools.persistence.SessionNotFoundException;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.jpa.JpaPersistenceContextManager;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManager;
import org.drools.persistence.jta.JtaTransactionManager;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.command.Context;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSessionCommandService
implements org.drools.core.command.SingleSessionCommandService {
    private static Logger logger = LoggerFactory.getLogger(SingleSessionCommandService.class);
    private SessionInfo sessionInfo;
    private SessionMarshallingHelper marshallingHelper;
    private KieSession ksession;
    private Environment env;
    private KnowledgeCommandContext kContext;
    private CommandService commandService;
    private TransactionManager txm;
    private PersistenceContextManager jpm;
    private volatile boolean doRollback;
    private static String SPRING_TM_CLASSNAME = "org.springframework.transaction.support.AbstractPlatformTransactionManager";

    public void checkEnvironment(Environment env) {
        if (env.get("org.kie.api.persistence.jpa.EntityManagerFactory") == null && env.get("org.kie.api.persistence.PersistenceContextManager") == null) {
            throw new IllegalArgumentException("Environment must have an EntityManagerFactory or a PersistenceContextManager instance");
        }
    }

    public SingleSessionCommandService(RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this((KieBase)new KnowledgeBaseImpl(ruleBase), (KieSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(Integer sessionId, RuleBase ruleBase, SessionConfiguration conf, Environment env) {
        this(sessionId, (KieBase)new KnowledgeBaseImpl(ruleBase), (KieSessionConfiguration)conf, env);
    }

    public SingleSessionCommandService(KieBase kbase, KieSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.checkEnvironment(this.env);
        this.initTransactionManager(this.env);
        this.initNewKnowledgeSession(kbase, conf);
        PersistenceContext persistenceContext = this.jpm.getApplicationScopedPersistenceContext();
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            this.registerRollbackSync();
            persistenceContext.joinTransaction();
            this.sessionInfo = persistenceContext.persist(this.sessionInfo);
            this.txm.commit(transactionOwner);
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
        ((InternalKnowledgeRuntime)this.ksession).setId(this.sessionInfo.getId().intValue());
    }

    protected void initNewKnowledgeSession(KieBase kbase, KieSessionConfiguration conf) {
        this.sessionInfo = new SessionInfo();
        this.ksession = kbase.newKieSession(conf, this.env);
        this.marshallingHelper = new SessionMarshallingHelper(this.ksession, conf);
        MarshallingConfigurationImpl config = (MarshallingConfigurationImpl)this.marshallingHelper.getMarshaller().getMarshallingConfiguration();
        config.setMarshallProcessInstances(false);
        config.setMarshallWorkItems(false);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        ((InternalKnowledgeRuntime)this.ksession).setEndOperationListener((EndOperationListener)new EndOperationListenerImpl(this.sessionInfo));
        this.kContext = new FixedKnowledgeCommandContext(null, null, null, this.ksession, null);
        this.commandService = new TransactionInterceptor((Context)this.kContext);
        ((AcceptsTimerJobFactoryManager)((InternalKnowledgeRuntime)this.ksession).getTimerService()).getTimerJobFactoryManager().setCommandService((CommandService)this);
    }

    public SingleSessionCommandService(Integer sessionId, KieBase kbase, KieSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.checkEnvironment(this.env);
        this.initTransactionManager(this.env);
        PersistenceContext persistenceContext = this.jpm.getApplicationScopedPersistenceContext();
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            this.registerRollbackSync();
            persistenceContext.joinTransaction();
            this.initExistingKnowledgeSession(sessionId, kbase, conf, persistenceContext);
            this.txm.commit(transactionOwner);
        }
        catch (SessionNotFoundException e) {
            if (transactionOwner) {
                this.rollbackTransaction(e, transactionOwner);
            }
            throw e;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    protected void initExistingKnowledgeSession(Integer sessionId, KieBase kbase, KieSessionConfiguration conf, PersistenceContext persistenceContext) {
        if (!this.doRollback && this.ksession != null) {
            return;
        }
        this.doRollback = false;
        try {
            this.sessionInfo = persistenceContext.findSessionInfo(sessionId);
        }
        catch (Exception e) {
            throw new SessionNotFoundException("Could not find session data for id " + sessionId, e);
        }
        if (this.sessionInfo == null) {
            throw new SessionNotFoundException("Could not find session data for id " + sessionId);
        }
        if (this.marshallingHelper == null) {
            this.marshallingHelper = new SessionMarshallingHelper(kbase, conf, this.env);
            MarshallingConfigurationImpl config = (MarshallingConfigurationImpl)this.marshallingHelper.getMarshaller().getMarshallingConfiguration();
            config.setMarshallProcessInstances(false);
            config.setMarshallWorkItems(false);
        }
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        ((SessionConfiguration)conf).getTimerJobFactoryManager().setCommandService((CommandService)this);
        this.ksession = (StatefulKnowledgeSession)this.marshallingHelper.loadSnapshot(this.sessionInfo.getData(), this.ksession);
        ((InternalKnowledgeRuntime)this.ksession).setId(this.sessionInfo.getId().intValue());
        ((InternalKnowledgeRuntime)this.ksession).setEndOperationListener((EndOperationListener)new EndOperationListenerImpl(this.sessionInfo));
        if (this.kContext == null) {
            this.kContext = new FixedKnowledgeCommandContext(null, null, null, this.ksession, null);
        }
        this.commandService = new TransactionInterceptor((Context)this.kContext);
    }

    public void initTransactionManager(Environment env) {
        Object tm = env.get("org.kie.transaction.TransactionManager");
        if (env.get("org.kie.api.persistence.PersistenceContextManager") != null && env.get("org.kie.transaction.TransactionManager") != null) {
            this.txm = (TransactionManager)tm;
            this.jpm = (PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager");
        } else {
            if (tm != null && SingleSessionCommandService.isSpringTransactionManager(tm.getClass())) {
                try {
                    logger.debug("Instantiating KieSpringTransactionManager");
                    Class<?> cls = Class.forName("org.kie.spring.persistence.KieSpringTransactionManager");
                    Constructor<?> con = cls.getConstructors()[0];
                    this.txm = (TransactionManager)con.newInstance(tm);
                    env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                    cls = Class.forName("org.kie.spring.persistence.KieSpringJpaManager");
                    con = cls.getConstructors()[0];
                    this.jpm = (PersistenceContextManager)con.newInstance(this.env);
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate KieSpringTransactionManager. Trying with DroolsSpringTransactionManager.");
                    try {
                        logger.debug("Instantiating DroolsSpringTransactionManager");
                        Class<?> cls = Class.forName("org.drools.container.spring.beans.persistence.DroolsSpringTransactionManager");
                        Constructor<?> con = cls.getConstructors()[0];
                        this.txm = (TransactionManager)con.newInstance(tm);
                        env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                        cls = Class.forName("org.drools.container.spring.beans.persistence.DroolsSpringJpaManager");
                        con = cls.getConstructors()[0];
                        this.jpm = (PersistenceContextManager)con.newInstance(this.env);
                    }
                    catch (Exception ex) {
                        logger.warn("Could not instantiate DroolsSpringTransactionManager");
                        throw new RuntimeException("Could not instantiate org.kie.container.spring.beans.persistence.DroolsSpringTransactionManager", ex);
                    }
                }
            } else {
                logger.debug("Instantiating JtaTransactionManager");
                this.txm = new JtaTransactionManager(env.get("org.kie.transaction.Transaction"), env.get("org.kie.transaction.TransactionSynchronizationRegistry"), tm);
                env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                try {
                    Class<?> jpaPersistenceCtxMngrClass = Class.forName("org.jbpm.persistence.JpaProcessPersistenceContextManager");
                    Constructor<?> jpaPersistenceCtxMngrCtor = jpaPersistenceCtxMngrClass.getConstructors()[0];
                    this.jpm = (PersistenceContextManager)jpaPersistenceCtxMngrCtor.newInstance(this.env);
                }
                catch (ClassNotFoundException e) {
                    this.jpm = new JpaPersistenceContextManager(this.env);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating JpaProcessPersistenceContextManager", e);
                }
            }
            env.set("org.kie.api.persistence.PersistenceContextManager", (Object)this.jpm);
            env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
        }
    }

    public static boolean isSpringTransactionManager(Class<?> clazz) {
        if (SPRING_TM_CLASSNAME.equals(clazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass() != null) {
            return SingleSessionCommandService.isSpringTransactionManager(clazz.getSuperclass());
        }
        return false;
    }

    public Context getContext() {
        return this.kContext;
    }

    public synchronized <T> T execute(Command<T> command) {
        return (T)this.commandService.execute(command);
    }

    private void rollbackTransaction(Exception t1, boolean transactionOwner) {
        try {
            logger.warn("Could not commit session", (Throwable)t1);
            this.txm.rollback(transactionOwner);
        }
        catch (Exception t2) {
            logger.error("Could not rollback", (Throwable)t2);
            throw new RuntimeException("Could not commit session or rollback", t2);
        }
    }

    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    public void destroy() {
        PersistenceContext persistenceContext = this.jpm.getApplicationScopedPersistenceContext();
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            persistenceContext.joinTransaction();
            this.initExistingKnowledgeSession(this.sessionInfo.getId(), this.marshallingHelper.getKbase(), this.marshallingHelper.getConf(), persistenceContext);
            persistenceContext.remove(this.sessionInfo);
            this.txm.commit(transactionOwner);
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    public int getSessionId() {
        return this.sessionInfo.getId();
    }

    private void registerRollbackSync() {
        TransactionManagerHelper.registerTransactionSyncInContainer(this.txm, new SynchronizationImpl(this));
    }

    public KieSession getKieSession() {
        return this.ksession;
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext(this.commandService);
        this.commandService = interceptor;
    }

    private void rollback() {
        this.doRollback = true;
    }

    private class TransactionInterceptor
    extends AbstractInterceptor {
        public TransactionInterceptor(Context context) {
            this.setNext((CommandService)new DefaultCommandService(context));
        }

        public <T> T execute(Command<T> command) {
            if (command instanceof DisposeCommand) {
                Object result = this.executeNext((Command)((GenericCommand)command));
                SingleSessionCommandService.this.jpm.dispose();
                return (T)result;
            }
            PersistenceContext persistenceContext = SingleSessionCommandService.this.jpm.getApplicationScopedPersistenceContext();
            boolean transactionOwner = false;
            try {
                transactionOwner = SingleSessionCommandService.this.txm.begin();
                persistenceContext.joinTransaction();
                SingleSessionCommandService.this.initExistingKnowledgeSession(SingleSessionCommandService.this.sessionInfo.getId(), SingleSessionCommandService.this.marshallingHelper.getKbase(), SingleSessionCommandService.this.marshallingHelper.getConf(), persistenceContext);
                SingleSessionCommandService.this.jpm.beginCommandScopedEntityManager();
                SingleSessionCommandService.this.registerRollbackSync();
                Object result = null;
                if (command instanceof BatchExecutionCommand) {
                    result = SingleSessionCommandService.this.ksession.execute(command);
                } else {
                    logger.trace("Executing " + command.getClass().getSimpleName());
                    result = this.executeNext((Command)((GenericCommand)command));
                }
                SingleSessionCommandService.this.txm.commit(transactionOwner);
                Object object = result;
                return (T)object;
            }
            catch (RuntimeException re) {
                SingleSessionCommandService.this.rollbackTransaction(re, transactionOwner);
                throw re;
            }
            catch (Exception t1) {
                SingleSessionCommandService.this.rollbackTransaction(t1, transactionOwner);
                throw new RuntimeException("Wrapped exception see cause", t1);
            }
            finally {
                if (command instanceof DisposeCommand) {
                    this.executeNext((Command)((GenericCommand)command));
                    SingleSessionCommandService.this.jpm.dispose();
                }
            }
        }
    }

    private static class SynchronizationImpl
    extends OrderedTransactionSynchronization {
        SingleSessionCommandService service;

        public SynchronizationImpl(SingleSessionCommandService service) {
            super(1);
            this.service = service;
        }

        @Override
        public void afterCompletion(int status) {
            if (status != 0) {
                this.service.rollback();
            }
            this.service.jpm.endCommandScopedEntityManager();
            KieSession ksession = this.service.ksession;
            if (ksession != null) {
                InternalProcessRuntime internalProcessRuntime = ((InternalKnowledgeRuntime)ksession).getProcessRuntime();
                if (internalProcessRuntime != null) {
                    if (this.service.doRollback) {
                        internalProcessRuntime.clearProcessInstancesState();
                    }
                    internalProcessRuntime.clearProcessInstances();
                }
                ((JPAWorkItemManager)ksession.getWorkItemManager()).clearWorkItems();
            }
        }

        @Override
        public void beforeCompletion() {
        }
    }

    public static class EndOperationListenerImpl
    implements EndOperationListener {
        private SessionInfo info;

        public EndOperationListenerImpl(SessionInfo info) {
            this.info = info;
        }

        public void endOperation(InternalKnowledgeRuntime kruntime) {
            this.info.setLastModificationDate(new Date(kruntime.getLastIdleTimestamp()));
        }
    }
}

