/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.RuleComponent;
import org.kie.api.definition.rule.Rule;

public abstract class BaseNode
implements NetworkNode {
    protected int id;
    protected RuleBasePartitionId partitionId;
    protected boolean partitionsEnabled;
    protected Map<Rule, RuleComponent> associations;
    protected boolean streamMode;

    public BaseNode() {
    }

    public BaseNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this.id = id;
        this.partitionId = partitionId;
        this.partitionsEnabled = partitionsEnabled;
        this.associations = new HashMap<Rule, RuleComponent>();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.partitionId = (RuleBasePartitionId)in.readObject();
        this.partitionsEnabled = in.readBoolean();
        this.associations = (Map)in.readObject();
        this.streamMode = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.partitionId);
        out.writeBoolean(this.partitionsEnabled);
        out.writeObject(this.associations);
        out.writeBoolean(this.streamMode);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isStreamMode() {
        return this.streamMode;
    }

    public void attach() {
        this.attach(null);
    }

    public abstract void attach(BuildContext var1);

    public abstract void networkUpdated(UpdateContext var1);

    public void remove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        this.removeAssociation(context.getRule());
        this.doRemove(context, builder, workingMemories);
        if (!this.isInUse() && !(this instanceof EntryPointNode)) {
            builder.getIdGenerator().releaseId(this.getId());
        }
    }

    protected abstract void doRemove(RuleRemovalContext var1, ReteooBuilder var2, InternalWorkingMemory[] var3);

    public abstract boolean isInUse();

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ")]";
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public void addAssociation(Rule rule, RuleComponent component) {
        this.associations.put(rule, component);
    }

    @Override
    public Map<Rule, RuleComponent> getAssociations() {
        return this.associations;
    }

    public void removeAssociation(Rule rule) {
        this.associations.remove(rule);
    }
}

