/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.kie.scanner.IoUtils;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.kie.scanner.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.file.FileRepositoryConnectorFactory;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.DefaultRepositorySystemSession;

public class Aether {
    private static final Logger log = LoggerFactory.getLogger(Aether.class);
    private String localRepoDir;
    public static Aether instance;
    private final RepositorySystem system;
    private RepositorySystemSession session;
    private final Collection<RemoteRepository> repositories;
    private RemoteRepository localRepository;

    private Aether(String localRepoDir) {
        this(MavenProjectLoader.loadMavenProject(), localRepoDir);
    }

    Aether(MavenProject mavenProject) {
        this(mavenProject, Aether.getAether().localRepoDir);
    }

    public static synchronized Aether getAether() {
        if (instance == null) {
            Settings settings = MavenSettings.getSettings();
            instance = new Aether(settings.getLocalRepository());
        }
        return instance;
    }

    private Aether(MavenProject mavenProject, String localRepoDir) {
        this.localRepoDir = localRepoDir;
        this.system = this.newRepositorySystem();
        this.session = this.newRepositorySystemSession(this.system);
        this.repositories = this.initRepositories(mavenProject);
    }

    private Collection<RemoteRepository> initRepositories(MavenProject mavenProject) {
        RemoteRepository localRepo;
        HashSet<RemoteRepository> reps = new HashSet<RemoteRepository>();
        reps.add(this.newCentralRepository());
        if (mavenProject != null) {
            reps.addAll(mavenProject.getRemoteProjectRepositories());
        }
        if ((localRepo = this.newLocalRepository()) != null) {
            reps.add(localRepo);
            this.localRepository = localRepo;
        } else {
            this.localRepoDir = IoUtils.getTmpDirectory().getAbsolutePath();
        }
        return reps;
    }

    private RepositorySystem newRepositorySystem() {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setServices(WagonProvider.class, new ManualWagonProvider());
        return locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        LocalRepository localRepo = new LocalRepository(this.localRepoDir);
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    private RemoteRepository newCentralRepository() {
        return new RemoteRepository("central", "default", "http://repo1.maven.org/maven2/");
    }

    private RemoteRepository newLocalRepository() {
        File m2RepoDir = new File(this.localRepoDir);
        if (!m2RepoDir.exists()) {
            return null;
        }
        try {
            String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
            return new RemoteRepository("local", "default", localRepositoryUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public void renewSession() {
        this.session = this.newRepositorySystemSession(this.system);
    }

    public Collection<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public RemoteRepository getLocalRepository() {
        return this.localRepository;
    }

    private static class ManualWagonProvider
    implements WagonProvider {
        private ManualWagonProvider() {
        }

        @Override
        public Wagon lookup(String roleHint) throws Exception {
            if ("http".equals(roleHint) || "https".equals(roleHint)) {
                return new HttpWagon();
            }
            if ("sramp".equals(roleHint)) {
                try {
                    return (Wagon)Class.forName("org.overlord.dtgov.jbpm.util.SrampWagonProxy").newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    log.warn("Cannot find sramp wagon implementation class", (Throwable)cnfe);
                }
            }
            return null;
        }

        @Override
        public void release(Wagon wagon) {
        }
    }
}

