/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.BaseDescr;

public class AnnotatedBaseDescr
extends BaseDescr
implements Externalizable {
    private Map<String, AnnotationDescr> annotations = new HashMap<String, AnnotationDescr>();
    private static final long serialVersionUID = 520L;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.annotations = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.annotations);
    }

    public AnnotationDescr addAnnotation(AnnotationDescr annotation) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationDescr>();
        } else {
            AnnotationDescr existingAnnotation = this.annotations.get(annotation.getName());
            if (existingAnnotation != null) {
                existingAnnotation.setDuplicated();
                return existingAnnotation;
            }
        }
        return this.annotations.put(annotation.getName(), annotation);
    }

    public AnnotationDescr addAnnotation(String name, String value) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationDescr>();
        } else {
            AnnotationDescr existingAnnotation = this.annotations.get(name);
            if (existingAnnotation != null) {
                existingAnnotation.setDuplicated();
                return existingAnnotation;
            }
        }
        AnnotationDescr annotation = new AnnotationDescr(name, value);
        return this.annotations.put(annotation.getName(), annotation);
    }

    public AnnotationDescr getAnnotation(String name) {
        return this.annotations == null ? null : this.annotations.get(name);
    }

    public Set<String> getAnnotationNames() {
        return this.annotations == null ? null : this.annotations.keySet();
    }

    public Map<String, AnnotationDescr> getAnnotations() {
        return this.annotations;
    }
}

