/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuiltinFormats {
    public static final int FIRST_USER_DEFINED_FORMAT_INDEX = 164;
    private static final String[] _formats;

    private static void putFormat(List<String> m, int index, String value) {
        if (m.size() != index) {
            throw new IllegalStateException("index " + index + " is wrong");
        }
        m.add(value);
    }

    public static Map<Integer, String> getBuiltinFormats() {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < _formats.length; ++i) {
            result.put(i, _formats[i]);
        }
        return result;
    }

    public static String[] getAll() {
        return (String[])_formats.clone();
    }

    public static String getBuiltinFormat(int index) {
        if (index < 0 || index >= _formats.length) {
            return null;
        }
        return _formats[index];
    }

    public static int getBuiltinFormat(String pFmt) {
        String fmt = pFmt.equalsIgnoreCase("TEXT") ? "@" : pFmt;
        for (int i = 0; i < _formats.length; ++i) {
            if (!fmt.equals(_formats[i])) continue;
            return i;
        }
        return -1;
    }

    static {
        ArrayList<String> m = new ArrayList<String>();
        BuiltinFormats.putFormat(m, 0, "General");
        BuiltinFormats.putFormat(m, 1, "0");
        BuiltinFormats.putFormat(m, 2, "0.00");
        BuiltinFormats.putFormat(m, 3, "#,##0");
        BuiltinFormats.putFormat(m, 4, "#,##0.00");
        BuiltinFormats.putFormat(m, 5, "\"$\"#,##0_);(\"$\"#,##0)");
        BuiltinFormats.putFormat(m, 6, "\"$\"#,##0_);[Red](\"$\"#,##0)");
        BuiltinFormats.putFormat(m, 7, "\"$\"#,##0.00_);(\"$\"#,##0.00)");
        BuiltinFormats.putFormat(m, 8, "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)");
        BuiltinFormats.putFormat(m, 9, "0%");
        BuiltinFormats.putFormat(m, 10, "0.00%");
        BuiltinFormats.putFormat(m, 11, "0.00E+00");
        BuiltinFormats.putFormat(m, 12, "# ?/?");
        BuiltinFormats.putFormat(m, 13, "# ??/??");
        BuiltinFormats.putFormat(m, 14, "m/d/yy");
        BuiltinFormats.putFormat(m, 15, "d-mmm-yy");
        BuiltinFormats.putFormat(m, 16, "d-mmm");
        BuiltinFormats.putFormat(m, 17, "mmm-yy");
        BuiltinFormats.putFormat(m, 18, "h:mm AM/PM");
        BuiltinFormats.putFormat(m, 19, "h:mm:ss AM/PM");
        BuiltinFormats.putFormat(m, 20, "h:mm");
        BuiltinFormats.putFormat(m, 21, "h:mm:ss");
        BuiltinFormats.putFormat(m, 22, "m/d/yy h:mm");
        for (int i = 23; i <= 36; ++i) {
            BuiltinFormats.putFormat(m, i, "reserved-0x" + Integer.toHexString(i));
        }
        BuiltinFormats.putFormat(m, 37, "#,##0_);(#,##0)");
        BuiltinFormats.putFormat(m, 38, "#,##0_);[Red](#,##0)");
        BuiltinFormats.putFormat(m, 39, "#,##0.00_);(#,##0.00)");
        BuiltinFormats.putFormat(m, 40, "#,##0.00_);[Red](#,##0.00)");
        BuiltinFormats.putFormat(m, 41, "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(m, 42, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(m, 43, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)");
        BuiltinFormats.putFormat(m, 44, "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)");
        BuiltinFormats.putFormat(m, 45, "mm:ss");
        BuiltinFormats.putFormat(m, 46, "[h]:mm:ss");
        BuiltinFormats.putFormat(m, 47, "mm:ss.0");
        BuiltinFormats.putFormat(m, 48, "##0.0E+0");
        BuiltinFormats.putFormat(m, 49, "@");
        String[] ss = new String[m.size()];
        m.toArray(ss);
        _formats = ss;
    }
}

