/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.EasyX509TrustManager;
import org.apache.maven.wagon.shared.http.HttpConfiguration;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    private BasicHttpContext localContext;
    protected static final int SC_NULL = -1;
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private DefaultHttpClient client;
    protected static ClientConnectionManager connectionManagerPooled;
    protected ClientConnectionManager clientConnectionManager = new SingleClientConnManager();
    protected static boolean useClientManagerPooled;
    protected static boolean sslEasy;
    protected static boolean sslAllowAll;
    protected static boolean IGNORE_SSL_VALIDITY_DATES;
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;
    private HttpGet getMethod;

    public ClientConnectionManager getConnectionManager() {
        if (!useClientManagerPooled) {
            return this.clientConnectionManager;
        }
        return connectionManagerPooled;
    }

    public static void setConnectionManagerPooled(ClientConnectionManager clientConnectionManager) {
        connectionManagerPooled = clientConnectionManager;
    }

    public static void setUseClientManagerPooled(boolean pooledClientManager) {
        useClientManagerPooled = pooledClientManager;
    }

    public void openConnectionInternal() {
        ProxyInfo proxyInfo;
        this.repository.setUrl(this.getURL(this.repository));
        this.client = new DefaultHttpClient(this.getConnectionManager());
        this.client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        String username = null;
        String password = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            password = this.authenticationInfo.getPassword();
        }
        if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            String host = this.getRepository().getHost();
            int port = this.getRepository().getPort() > -1 ? this.getRepository().getPort() : -1;
            this.client.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)creds);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            HttpHost targetHost = new HttpHost(this.repository.getHost(), this.repository.getPort(), this.repository.getProtocol());
            authCache.put(targetHost, (AuthScheme)basicAuth);
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        if ((proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost())) != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            int proxyPort = proxyInfo.getPort();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                if (proxyUsername != null && proxyPassword != null) {
                    Object creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    int port = proxyInfo.getPort() > -1 ? proxyInfo.getPort() : -1;
                    AuthScope authScope = new AuthScope(proxyHost, port);
                    this.client.getCredentialsProvider().setCredentials(authScope, (Credentials)creds);
                }
                this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        }
    }

    public void closeConnection() {
        if (!useClientManagerPooled) {
            this.getConnectionManager().shutdown();
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        String[] parts;
        StringBuilder url = new StringBuilder(this.getRepository().getUrl());
        for (String part : parts = StringUtils.split((String)resource.getName(), (String)"/")) {
            if (!url.toString().endsWith("/")) {
                url.append('/');
            }
            url.append(URLEncoder.encode(part));
        }
        try {
            this.mkdirs(PathUtils.dirname((String)resource.getName()));
        }
        catch (HttpException he) {
            this.fireTransferError(resource, (Exception)((Object)he), 5);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
        }
        HttpPut putMethod = new HttpPut(url.toString());
        this.firePutStarted(resource, source);
        try {
            HttpResponse response;
            putMethod.setEntity((HttpEntity)new RequestEntityImplementation(stream, resource, (Wagon)this, source));
            try {
                response = this.execute((HttpUriRequest)putMethod);
            }
            catch (IOException e) {
                this.fireTransferError(resource, e, 6);
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
            catch (HttpException e) {
                this.fireTransferError(resource, (Exception)((Object)e), 6);
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = ", ReasonPhrase:" + response.getStatusLine().getReasonPhrase() + ".";
            this.fireTransferDebug(url + " - Status code: " + statusCode + reasonPhrase);
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case -1: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + reasonPhrase);
                    this.fireTransferError(resource, (Exception)e, 6);
                    throw e;
                }
                case 403: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist" + reasonPhrase);
                }
                default: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
                    this.fireTransferError(resource, (Exception)e, 6);
                    throw e;
                }
            }
            this.firePutCompleted(resource, source);
        }
        finally {
            putMethod.abort();
        }
    }

    protected void mkdirs(String dirname) throws HttpException, IOException {
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resourceName;
        HttpHead headMethod = new HttpHead(url);
        HttpResponse response = null;
        try {
            response = this.execute((HttpUriRequest)headMethod);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = ", ReasonPhrase:" + response.getStatusLine().getReasonPhrase() + ".";
            switch (statusCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 304: {
                    boolean bl = true;
                    return bl;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url + reasonPhrase);
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized" + reasonPhrase);
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy" + reasonPhrase);
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
        }
        finally {
            headMethod.abort();
        }
    }

    protected HttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        int statusCode = -1;
        this.setParameters(httpMethod);
        this.setHeaders(httpMethod);
        this.client.getParams().setParameter("http.useragent", (Object)this.getUserAgent(httpMethod));
        return this.client.execute(httpMethod, (HttpContext)this.localContext);
    }

    protected void setParameters(HttpUriRequest method) {
        HttpParams params;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null && (params = config.asMethodParams(method.getParams())) != null) {
            method.setParams(params);
        }
        if (config == null || config.getReadTimeout() == 60000) {
            method.getParams().setParameter("http.socket.timeout", (Object)this.getTimeout());
        }
    }

    protected void setHeaders(HttpUriRequest method) {
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addHeader("Cache-control", "no-cache");
            method.addHeader("Cache-store", "no-store");
            method.addHeader("Pragma", "no-cache");
            method.addHeader("Expires", "0");
            method.addHeader("Accept-Encoding", "gzip");
        }
        if (this.httpHeaders != null) {
            for (Map.Entry<Object, Object> entry : this.httpHeaders.entrySet()) {
                method.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                method.addHeader(headers[i]);
            }
        }
    }

    protected String getUserAgent(HttpUriRequest method) {
        HttpMethodConfiguration config;
        String value;
        if (this.httpHeaders != null && (value = (String)this.httpHeaders.get("User-Agent")) != null) {
            return value;
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null) {
            return (String)config.getHeaders().get("User-Agent");
        }
        return null;
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputStream is;
        Header contentEncoding;
        HttpResponse response;
        Resource resource = inputData.getResource();
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resource.getName();
        this.getMethod = new HttpGet(url);
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            BasicHeader hdr = new BasicHeader("If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
            this.getMethod.addHeader((Header)hdr);
        }
        try {
            response = this.execute((HttpUriRequest)this.getMethod);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 5);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        String reasonPhrase = ", ReasonPhrase:" + response.getStatusLine().getReasonPhrase() + ".";
        this.fireTransferDebug(url + " - Status code: " + statusCode + reasonPhrase);
        switch (statusCode) {
            case 200: {
                break;
            }
            case 304: {
                return;
            }
            case -1: {
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + reasonPhrase);
                this.fireTransferError(resource, (Exception)e, 5);
                throw e;
            }
            case 403: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
            }
            case 401: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized" + reasonPhrase);
            }
            case 407: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized by proxy" + reasonPhrase);
            }
            case 404: {
                throw new ResourceDoesNotExistException("File: " + url + reasonPhrase);
            }
            default: {
                this.cleanupGetTransfer(resource);
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
                this.fireTransferError(resource, (Exception)e, 5);
                throw e;
            }
        }
        Header contentLengthHeader = response.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            try {
                long contentLength = Integer.valueOf(contentLengthHeader.getValue()).intValue();
                resource.setContentLength(contentLength);
            }
            catch (NumberFormatException e) {
                this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
            }
        }
        Header lastModifiedHeader = response.getFirstHeader("Last-Modified");
        long lastModified = 0L;
        if (lastModifiedHeader != null) {
            try {
                lastModified = DateUtils.parseDate((String)lastModifiedHeader.getValue()).getTime();
                resource.setLastModified(lastModified);
            }
            catch (DateParseException e) {
                this.fireTransferDebug("Unable to parse last modified header");
            }
            this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified + ")");
        }
        boolean isGZipped = (contentEncoding = response.getFirstHeader("Content-Encoding")) == null ? false : "gzip".equalsIgnoreCase(contentEncoding.getValue());
        try {
            is = response.getEntity().getContent();
            if (isGZipped) {
                is = new GZIPInputStream(is);
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            String msg = "Error occurred while retrieving from remote repository:" + this.getRepository() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
        inputData.setInputStream(is);
    }

    protected void cleanupGetTransfer(Resource resource) {
        if (this.getMethod != null) {
            this.getMethod.abort();
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("Should not be using the streaming wagon for HTTP PUT");
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    static {
        useClientManagerPooled = Boolean.valueOf(System.getProperty("maven.wagon.http.pool", "true"));
        sslEasy = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.easy", "true"));
        sslAllowAll = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.allowall", "true"));
        IGNORE_SSL_VALIDITY_DATES = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.ignore.validity.dates", "true"));
        if (!useClientManagerPooled) {
            System.out.println("http connection pool disabled in wagon http");
        } else {
            ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager();
            int maxPerRoute = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxPerRoute", "20"));
            threadSafeClientConnManager.setDefaultMaxPerRoute(maxPerRoute);
            int maxTotal = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxTotal", "40"));
            threadSafeClientConnManager.setDefaultMaxPerRoute(maxPerRoute);
            threadSafeClientConnManager.setMaxTotal(maxTotal);
            if (sslEasy) {
                try {
                    SSLSocketFactory sslSocketFactory = new SSLSocketFactory(EasyX509TrustManager.createEasySSLContext(), (X509HostnameVerifier)(sslAllowAll ? new EasyHostNameVerifier() : new BrowserCompatHostnameVerifier()));
                    Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
                    threadSafeClientConnManager.getSchemeRegistry().register(httpsScheme);
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to init SSLSocket Factory " + e.getMessage(), e);
                }
            }
            System.out.println(" wagon http use multi threaded http connection manager maxPerRoute " + threadSafeClientConnManager.getDefaultMaxPerRoute() + ", max total " + threadSafeClientConnManager.getMaxTotal());
            connectionManagerPooled = threadSafeClientConnManager;
        }
    }

    private static class EasyHostNameVerifier
    implements X509HostnameVerifier {
        private EasyHostNameVerifier() {
        }

        public void verify(String s, SSLSocket sslSocket) throws IOException {
        }

        public void verify(String s, X509Certificate x509Certificate) throws SSLException {
        }

        public void verify(String s, String[] strings, String[] strings1) throws SSLException {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    private final class RequestEntityImplementation
    implements HttpEntity {
        private final Resource resource;
        private final Wagon wagon;
        private final File source;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private RequestEntityImplementation(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
            } else {
                FileOutputStream fos = null;
                try {
                    this.source = File.createTempFile("http-wagon.", ".tmp");
                    this.source.deleteOnExit();
                    fos = new FileOutputStream(this.source);
                    IOUtil.copy((InputStream)stream, (OutputStream)fos);
                }
                catch (IOException e) {
                    try {
                        AbstractHttpClientWagon.this.fireTransferError(resource, e, 6);
                        throw new TransferFailedException("Failed to buffer stream contents to temp file for upload.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(fos);
                        throw throwable;
                    }
                }
                IOUtil.close((OutputStream)fos);
            }
            this.resource = resource;
            this.wagon = wagon;
        }

        public long getContentLength() {
            return this.resource.getContentLength();
        }

        public Header getContentType() {
            return null;
        }

        public Header getContentEncoding() {
            return null;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            FileInputStream fis = new FileInputStream(this.source);
            return fis;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isChunked() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream output) throws IOException {
            byte[] buffer = new byte[4096];
            TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
            transferEvent.setTimestamp(System.currentTimeMillis());
            FileInputStream fin = null;
            try {
                int n;
                fin = new FileInputStream(this.source);
                for (int remaining = Integer.MAX_VALUE; remaining > 0 && (n = fin.read(buffer, 0, Math.min(buffer.length, remaining))) != -1; remaining -= n) {
                    AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, n);
                    output.write(buffer, 0, n);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fin);
                throw throwable;
            }
            IOUtil.close((InputStream)fin);
            output.flush();
        }

        public boolean isStreaming() {
            return false;
        }

        public void consumeContent() throws IOException {
        }
    }
}

