/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.map.KnowledgeSessionStorage;
import org.drools.persistence.map.NonTransactionalPersistentSession;

public class MapBasedPersistenceContext
implements PersistenceContext,
NonTransactionalPersistentSession {
    private Map<Integer, SessionInfo> ksessions;
    private Map<Long, WorkItemInfo> workItems;
    private boolean open = true;
    private KnowledgeSessionStorage storage;

    public MapBasedPersistenceContext(KnowledgeSessionStorage storage) {
        this.storage = storage;
        this.ksessions = new HashMap<Integer, SessionInfo>();
        this.workItems = new HashMap<Long, WorkItemInfo>();
    }

    @Override
    public SessionInfo persist(SessionInfo entity) {
        if (entity.getId() == null) {
            entity.setId(this.storage.getNextStatefulKnowledgeSessionId());
        }
        this.ksessions.put(entity.getId(), entity);
        return entity;
    }

    @Override
    public SessionInfo findSessionInfo(Integer sessionId) {
        SessionInfo sessionInfo = this.ksessions.get(sessionId);
        if (sessionInfo == null) {
            sessionInfo = this.storage.findSessionInfo(sessionId);
            this.ksessions.put(sessionId, sessionInfo);
        }
        return sessionInfo;
    }

    @Override
    public void remove(SessionInfo sessionInfo) {
        this.ksessions.remove(sessionInfo.getId());
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void joinTransaction() {
    }

    @Override
    public void close() {
        this.open = false;
        this.clear();
    }

    @Override
    public void clear() {
        this.clearAll();
    }

    private void clearAll() {
        this.ksessions.clear();
        this.workItems.clear();
    }

    @Override
    public List<SessionInfo> getStoredKnowledgeSessions() {
        return Collections.unmodifiableList(new ArrayList<SessionInfo>(this.ksessions.values()));
    }

    @Override
    public WorkItemInfo persist(WorkItemInfo workItemInfo) {
        if (workItemInfo.getId() == null) {
            workItemInfo.setId(this.storage.getNextWorkItemId());
        }
        this.workItems.put(workItemInfo.getId(), workItemInfo);
        return workItemInfo;
    }

    @Override
    public List<WorkItemInfo> getStoredWorkItems() {
        return Collections.unmodifiableList(new ArrayList<WorkItemInfo>(this.workItems.values()));
    }

    @Override
    public WorkItemInfo findWorkItemInfo(Long id) {
        WorkItemInfo workItemInfo = this.workItems.get(id);
        if (workItemInfo == null) {
            workItemInfo = this.storage.findWorkItemInfo(id);
        }
        return workItemInfo;
    }

    @Override
    public void remove(WorkItemInfo workItemInfo) {
        if (this.workItems.remove(workItemInfo.getId()) != null) {
            this.storage.remove(workItemInfo);
        }
    }

    @Override
    public WorkItemInfo merge(WorkItemInfo workItemInfo) {
        this.storage.saveOrUpdate(workItemInfo);
        return workItemInfo;
    }

    public void lock(SessionInfo sessionInfo) {
        throw new UnsupportedOperationException("Map based persistence does not support locking.");
    }

    @Override
    public void lock(WorkItemInfo workItemInfo) {
        throw new UnsupportedOperationException("Map based persistence does not support locking.");
    }
}

