/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.compiler.lang.descr.AnnotatedBaseDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.PatternDescr;

public class TypeFieldDescr
extends AnnotatedBaseDescr
implements Comparable<TypeFieldDescr> {
    private static final long serialVersionUID = 510L;
    private int index = -1;
    private String fieldName;
    private String initExpr;
    private PatternDescr pattern;
    private boolean inherited;

    public TypeFieldDescr() {
        this(null);
    }

    public TypeFieldDescr(String fieldName) {
        this.fieldName = fieldName;
    }

    public TypeFieldDescr(String fieldName, PatternDescr pat) {
        this(fieldName);
        this.pattern = pat;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.index = in.readInt();
        this.fieldName = (String)in.readObject();
        this.initExpr = (String)in.readObject();
        this.pattern = (PatternDescr)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.index);
        out.writeObject(this.fieldName);
        out.writeObject(this.initExpr);
        out.writeObject(this.pattern);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getInitExpr() {
        return this.initExpr;
    }

    public void setInitExpr(String initExpr) {
        this.initExpr = initExpr;
    }

    public PatternDescr getPattern() {
        return this.pattern;
    }

    public void setPattern(PatternDescr pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return "TypeField[ " + this.getFieldName() + " : " + this.pattern + " = " + this.initExpr + " ]";
    }

    @Override
    public int compareTo(TypeFieldDescr other) {
        return this.index - other.index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public TypeFieldDescr cloneAsInherited() {
        TypeFieldDescr clone = new TypeFieldDescr(this.fieldName, this.pattern);
        clone.index = this.index;
        clone.initExpr = this.initExpr;
        clone.inherited = true;
        for (AnnotationDescr ad : this.getAnnotations().values()) {
            clone.addAnnotation(ad);
        }
        return clone;
    }
}

