/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.invaders;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.games.GameUI;
import org.drools.games.invaders.InvadersConfiguration;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class Invaders2Main {
    public static void main(String[] args) {
        new Invaders2Main().init(true);
    }

    public void init(boolean exitOnClose) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        KieSession ksession = kc.newKieSession("Invaders2KS");
        InvadersConfiguration conf = new InvadersConfiguration();
        conf.setExitOnClose(exitOnClose);
        GameUI ui = new GameUI(ksession, conf);
        ui.init();
        ksession.setGlobal("conf", conf);
        ksession.setGlobal("ui", ui);
        this.runKSession(ksession);
    }

    public void runKSession(final KieSession ksession) {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ksession.fireUntilHalt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

