/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.project.DefaultDependencyResolutionResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

@Component(role=ProjectDependenciesResolver.class)
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    @Override
    public DependencyResolutionResult resolve(DependencyResolutionRequest request) throws DependencyResolutionException {
        DependencyNode node;
        DependencyManagement depMngt;
        RequestTrace trace = RequestTrace.newChild(null, (Object)request);
        DefaultDependencyResolutionResult result = new DefaultDependencyResolutionResult();
        MavenProject project = request.getMavenProject();
        RepositorySystemSession session = request.getRepositorySession();
        if (this.logger.isDebugEnabled() && session.getConfigProperties().get("aether.dependencyManager.verbose") == null) {
            DefaultRepositorySystemSession verbose = new DefaultRepositorySystemSession(session);
            verbose.setConfigProperty("aether.dependencyManager.verbose", (Object)Boolean.TRUE);
            session = verbose;
        }
        DependencyFilter filter = request.getResolutionFilter();
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        CollectRequest collect = new CollectRequest();
        collect.setRootArtifact(RepositoryUtils.toArtifact(project.getArtifact()));
        collect.setRequestContext("project");
        collect.setRepositories(project.getRemoteProjectRepositories());
        if (project.getDependencyArtifacts() == null) {
            for (Dependency dependency : project.getDependencies()) {
                if (StringUtils.isEmpty((String)dependency.getGroupId()) || StringUtils.isEmpty((String)dependency.getArtifactId()) || StringUtils.isEmpty((String)dependency.getVersion())) continue;
                collect.addDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        } else {
            HashMap<String, Dependency> dependencies = new HashMap<String, Dependency>();
            for (Dependency dependency : project.getDependencies()) {
                ArtifactType type;
                String classifier = dependency.getClassifier();
                if (classifier == null && (type = stereotypes.get(dependency.getType())) != null) {
                    classifier = type.getClassifier();
                }
                String key = ArtifactIdUtils.toVersionlessId((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getType(), (String)classifier);
                dependencies.put(key, dependency);
            }
            Iterator<Object> i$ = project.getDependencyArtifacts().iterator();
            while (i$.hasNext()) {
                org.apache.maven.artifact.Artifact artifact;
                String key = (artifact = (org.apache.maven.artifact.Artifact)i$.next()).getDependencyConflictId();
                Dependency dependency = (Dependency)dependencies.get(key);
                List exclusions = dependency != null ? dependency.getExclusions() : null;
                org.eclipse.aether.graph.Dependency dep = RepositoryUtils.toDependency(artifact, exclusions);
                if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collect.addDependency(dep);
            }
        }
        if ((depMngt = project.getDependencyManagement()) != null) {
            for (Dependency dependency : depMngt.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        }
        DependencyRequest depRequest = new DependencyRequest(collect, filter);
        depRequest.setTrace(trace);
        try {
            collect.setTrace(RequestTrace.newChild((RequestTrace)trace, (Object)depRequest));
            node = this.repoSystem.collectDependencies(session, collect).getRoot();
            result.setDependencyGraph(node);
        }
        catch (DependencyCollectionException e) {
            result.setDependencyGraph(e.getResult().getRoot());
            result.setCollectionErrors(e.getResult().getExceptions());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        depRequest.setRoot(node);
        if (this.logger.isWarnEnabled()) {
            for (DependencyNode child : node.getChildren()) {
                if (child.getRelocations().isEmpty()) continue;
                this.logger.warn("The artifact " + child.getRelocations().get(0) + " has been relocated to " + child.getDependency().getArtifact());
            }
        }
        if (this.logger.isDebugEnabled()) {
            node.accept((DependencyVisitor)new GraphLogger(project));
        }
        try {
            this.process(result, this.repoSystem.resolveDependencies(session, depRequest).getArtifactResults());
        }
        catch (org.eclipse.aether.resolution.DependencyResolutionException e) {
            this.process(result, e.getResult().getArtifactResults());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        return result;
    }

    private void process(DefaultDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node.getDependency());
                continue;
            }
            result.setResolutionErrors(node.getDependency(), ar.getExceptions());
        }
    }

    class GraphLogger
    implements DependencyVisitor {
        private final MavenProject project;
        private String indent = "";
        private Map<String, Dependency> managed;

        public GraphLogger(MavenProject project) {
            this.project = project;
        }

        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            org.eclipse.aether.graph.Dependency dep = node.getDependency();
            if (dep != null) {
                String premanagedVersion;
                Artifact art = dep.getArtifact();
                buffer.append(art);
                buffer.append(':').append(dep.getScope());
                String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)node);
                if (premanagedScope != null && !premanagedScope.equals(dep.getScope())) {
                    buffer.append(" (scope managed from ").append(premanagedScope);
                    this.appendManagementSource(buffer, art, "scope");
                    buffer.append(")");
                }
                if ((premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node)) != null && !premanagedVersion.equals(art.getVersion())) {
                    buffer.append(" (version managed from ").append(premanagedVersion);
                    this.appendManagementSource(buffer, art, "version");
                    buffer.append(")");
                }
            } else {
                buffer.append(this.project.getGroupId());
                buffer.append(':').append(this.project.getArtifactId());
                buffer.append(':').append(this.project.getPackaging());
                buffer.append(':').append(this.project.getVersion());
            }
            DefaultProjectDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }

        private void appendManagementSource(StringBuilder buffer, Artifact artifact, String field) {
            InputSource source;
            InputLocation location;
            String key;
            Dependency dependency;
            if (this.managed == null) {
                this.managed = new HashMap<String, Dependency>();
                if (this.project.getDependencyManagement() != null) {
                    for (Dependency dep : this.project.getDependencyManagement().getDependencies()) {
                        this.managed.put(dep.getManagementKey(), dep);
                    }
                }
            }
            if ((dependency = this.managed.get(key = ArtifactIdUtils.toVersionlessId((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getProperty("type", "jar"), (String)artifact.getClassifier()))) != null && (location = dependency.getLocation((Object)field)) != null && (source = location.getSource()) != null) {
                buffer.append(" by ").append(source.getModelId());
            }
        }
    }
}

