/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.Stack;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.DroolsCompilerComponentFactory;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.beliefsystem.abductive.Abductive;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.AbductiveQuery;
import org.drools.core.rule.Dialectable;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryImpl;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;

public class RuleBuildContext
extends PackageBuildContext {
    private RuleImpl rule;
    private Stack<RuleConditionElement> buildStack = new Stack();
    private RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;
    private DroolsCompilerComponentFactory compilerFactory;
    private boolean needStreamMode = false;
    private Pattern prefixPattern;

    public RuleBuildContext(KnowledgeBuilderImpl kBuilder, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectCompiletimeRegistry, InternalKnowledgePackage pkg, Dialect defaultDialect) {
        Dialect dialect;
        Abductive abductive;
        this.declarationResolver = new DeclarationScopeResolver(kBuilder.getGlobals(), this.buildStack);
        this.declarationResolver.setPackage(pkg);
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? ((abductive = ruleDescr.getTypedAnnotation(Abductive.class)) == null ? new QueryImpl(ruleDescr.getName()) : new AbductiveQuery(ruleDescr.getName(), (Object)abductive.mode())) : new RuleImpl(ruleDescr.getName());
        this.rule.setPackage(pkg.getName());
        this.rule.setDialect(ruleDescr.getDialect());
        this.rule.setLoadOrder(ruleDescr.getLoadOrder());
        this.init(kBuilder, pkg, ruleDescr, dialectCompiletimeRegistry, defaultDialect, (Dialectable)this.rule);
        if (this.rule.getDialect() == null) {
            this.rule.setDialect(this.getDialect().getId());
        }
        if ((dialect = this.getDialect()) != null) {
            dialect.init(ruleDescr);
        }
        this.compilerFactory = kBuilder.getBuilderConfiguration().getComponentFactory();
    }

    public RuleImpl getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver variables) {
        this.declarationResolver = variables;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public void setPatternId(int patternId) {
        this.patternId = patternId;
    }

    public Stack<RuleConditionElement> getBuildStack() {
        return this.buildStack;
    }

    public DroolsCompilerComponentFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(DroolsCompilerComponentFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    public void setPrefixPattern(Pattern prefixPattern) {
        this.prefixPattern = prefixPattern;
    }

    public Pattern getPrefixPattern() {
        return this.prefixPattern;
    }
}

