/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.sisu.bean.BeanListener;
import org.eclipse.sisu.plexus.PlexusBeanBinder;
import org.eclipse.sisu.plexus.PlexusBeanManager;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBeanSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusBindingModule
implements Module {
    private final PlexusBeanManager manager;
    private final PlexusBeanModule[] modules;

    public PlexusBindingModule(PlexusBeanManager manager, PlexusBeanModule ... modules) {
        this.manager = manager;
        this.modules = (PlexusBeanModule[])modules.clone();
    }

    public PlexusBindingModule(PlexusBeanManager manager, Collection<? extends PlexusBeanModule> modules) {
        this.manager = manager;
        this.modules = modules.toArray(new PlexusBeanModule[modules.size()]);
    }

    @Override
    public void configure(Binder binder) {
        ArrayList<PlexusBeanSource> sources = new ArrayList<PlexusBeanSource>(this.modules.length);
        PlexusBeanModule[] plexusBeanModuleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusBeanModule module = plexusBeanModuleArray[n2];
            PlexusBeanSource source = module.configure(binder);
            if (source != null) {
                sources.add(source);
            }
            ++n2;
        }
        PlexusBeanBinder plexusBinder = new PlexusBeanBinder(this.manager, sources);
        binder.bindListener(Matchers.any(), new BeanListener(plexusBinder));
        if (this.manager instanceof ProvisionListener) {
            binder.bindListener(Matchers.any(), (ProvisionListener)((Object)this.manager));
        }
    }
}

