/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.RightTupleList;
import org.drools.reteoo.nodes.ReteBetaNodeUtils;

public class ReteExistsNode
extends ExistsNode {
    public ReteExistsNode() {
    }

    public ReteExistsNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, leftInput, rightInput, joinNodeBinder, context);
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        ReteBetaNodeUtils.assertObject((BetaNode)this, factHandle, pctx, wm);
    }

    public void attach(BuildContext context) {
        ReteBetaNodeUtils.attach((BetaNode)this, context);
    }

    public void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        ReteBetaNodeUtils.doRemove((BetaNode)this, context, builder, workingMemories);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteBetaNodeUtils.modifyObject((BetaNode)this, factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple((InternalFactHandle)factHandle, (ModifyPreviousTuples)modifyPreviousTuples, (PropagationContext)context, (InternalWorkingMemory)workingMemory, (LeftTupleSink)this, (ObjectTypeNode.Id)this.getLeftInputOtnId(), (BitMask)this.getLeftInferredMask());
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        while (rightTuple != null) {
            if (this.constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (!useLeftMemory) break;
                rightTuple.addBlocked(leftTuple);
                break;
            }
            rightTuple = (RightTuple)it.next((Entry)rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
        if (leftTuple.getBlocker() != null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        } else if (useLeftMemory) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
    }

    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, it);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)it.next((Entry)leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                memory.getLeftTupleMemory().remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        RightTupleMemory rtm = memory.getRightTupleMemory();
        if (rightTuple.getBlocked() != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, pctx, workingMemory, memory, memory.getLeftTupleMemory(), rightTuple.getBlocked(), rtm, false);
            rightTuple.nullBlocked();
        } else {
            rtm.remove(rightTuple);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
            memory.getLeftTupleMemory().remove(leftTuple);
        } else {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            blocker.removeBlocked(leftTuple);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple firstRightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            memory.getLeftTupleMemory().remove(leftTuple);
        } else if (rightMemory.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        if (blocker != null && !this.isLeftUpdateOptimizationAllowed()) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        if (blocker == null || !this.constraints.isAllowedCachedLeft(memory.getContext(), blocker.getFactHandle())) {
            if (blocker != null) {
                blocker.removeBlocked(leftTuple);
            }
            FastIterator it = memory.getRightTupleMemory().fastIterator();
            RightTuple newBlocker = firstRightTuple;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next((Entry)newBlocker);
            }
        }
        if (leftTuple.getBlocker() == null) {
            memory.getLeftTupleMemory().add(leftTuple);
            if (leftTuple.getFirstChild() != null) {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
        } else if (leftTuple.getFirstChild() == null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
        } else {
            this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, true);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
            memory.getRightTupleMemory().removeAdd(rightTuple);
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple firstLeftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, leftIt);
        LeftTuple firstBlocked = rightTuple.getBlocked();
        rightTuple.nullBlocked();
        LeftTuple leftTuple = firstLeftTuple;
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftIt.next((Entry)leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                leftMemory.remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        RightTupleMemory rightTupleMemory = memory.getRightTupleMemory();
        if (firstBlocked != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, leftMemory, firstBlocked, rightTupleMemory, true);
        } else {
            rightTupleMemory.removeAdd(rightTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
        this.constraints.resetTuple(memory.getContext());
    }

    private void updateLeftTupleToNewBlocker(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory, LeftTupleMemory leftMemory, LeftTuple firstBlocked, RightTupleMemory rightTupleMemory, boolean removeAdd) {
        boolean resumeFromCurrent = !this.indexedUnificationJoin && !rightTupleMemory.getIndexType().isComparison();
        FastIterator rightIt = null;
        RightTuple rootBlocker = null;
        if (resumeFromCurrent) {
            RightTupleList currentRtm = rightTuple.getMemory();
            rightIt = currentRtm.fastIterator();
            rootBlocker = (RightTuple)rightTuple.getNext();
            if (removeAdd) {
                rightTupleMemory.removeAdd(rightTuple);
            } else {
                rightTupleMemory.remove(rightTuple);
            }
            if (rootBlocker == null && rightTuple.getMemory() == currentRtm) {
                rootBlocker = rightTuple;
            }
        } else {
            rightIt = this.getRightIterator(rightTupleMemory);
            if (removeAdd) {
                rightTupleMemory.removeAdd(rightTuple);
            } else {
                rightTupleMemory.remove(rightTuple);
            }
        }
        LeftTuple leftTuple = firstBlocked;
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.clearBlocker();
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            if (!resumeFromCurrent) {
                rootBlocker = this.getFirstRightTuple(leftTuple, rightTupleMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
            }
            RightTuple newBlocker = rootBlocker;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next((Entry)newBlocker);
            }
            if (leftTuple.getBlocker() == null) {
                leftMemory.add(leftTuple);
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            leftTuple = temp;
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        Iterator it = memory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            for (LeftTuple leftTuple = rightTuple.getBlocked(); leftTuple != null; leftTuple = leftTuple.getBlockedNext()) {
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, sink, context, true), context, workingMemory);
            }
            rightTuple = (RightTuple)it.next();
        }
    }
}

