/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;

public class RetePropagationContext
implements PropagationContext {
    private static final long serialVersionUID = 510L;
    private int type;
    private RuleImpl rule;
    private TerminalNode terminalNodeOrigin;
    private LeftTuple leftTuple;
    private InternalFactHandle factHandle;
    private long propagationNumber;
    private EntryPointId entryPoint;
    private int originOffset;
    private final LinkedList<WorkingMemoryAction> queue1 = new LinkedList();
    private LinkedList<WorkingMemoryAction> queue2;
    private BitMask modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
    private BitMask originalMask = PropertySpecificUtil.allSetButTraitBitMask();
    private Class<?> modifiedClass;
    private ObjectType objectType;
    private transient MarshallerReaderContext readerContext;

    public RetePropagationContext() {
    }

    public RetePropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle) {
        this(number, type, rule, leftTuple, factHandle, EntryPointId.DEFAULT, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
        this.originOffset = -1;
    }

    public RetePropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPointId entryPoint) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
    }

    public RetePropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPointId entryPoint, BitMask modificationMask) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, modificationMask, Object.class, null);
    }

    public RetePropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPointId entryPoint, MarshallerReaderContext readerContext) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, readerContext);
    }

    public RetePropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPointId entryPoint, BitMask modificationMask, Class<?> modifiedClass, MarshallerReaderContext readerContext) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.terminalNodeOrigin = leftTuple != null ? (TerminalNode)leftTuple.getSink() : null;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.entryPoint = entryPoint;
        this.originOffset = -1;
        this.modificationMask = modificationMask;
        this.originalMask = modificationMask;
        this.modifiedClass = modifiedClass;
        this.readerContext = readerContext;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.propagationNumber = in.readLong();
        this.rule = (RuleImpl)in.readObject();
        this.leftTuple = (LeftTuple)in.readObject();
        this.entryPoint = (EntryPointId)in.readObject();
        this.originOffset = in.readInt();
        this.modificationMask = (BitMask)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.leftTuple);
        out.writeObject(this.entryPoint);
        out.writeInt(this.originOffset);
        out.writeObject(this.modificationMask);
    }

    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    public void cleanReaderContext() {
        this.readerContext = null;
    }

    public RuleImpl getRuleOrigin() {
        return this.rule;
    }

    public TerminalNode getTerminalNodeOrigin() {
        return this.terminalNodeOrigin;
    }

    public Rule getRule() {
        return this.rule;
    }

    public LeftTuple getLeftTupleOrigin() {
        return this.leftTuple;
    }

    public InternalFactHandle getFactHandleOrigin() {
        return this.factHandle;
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    public void setFactHandle(FactHandle factHandle) {
        this.factHandle = (InternalFactHandle)factHandle;
    }

    public int getType() {
        return this.type;
    }

    public RetePropagationContext compareTypeAndClone(int expectedType, int newType) {
        if (this.type != expectedType) {
            return this;
        }
        RetePropagationContext clone = new RetePropagationContext();
        clone.type = newType;
        clone.rule = this.rule;
        clone.leftTuple = this.leftTuple;
        clone.factHandle = this.factHandle;
        clone.propagationNumber = this.propagationNumber;
        clone.entryPoint = this.entryPoint;
        clone.originOffset = this.originOffset;
        clone.modificationMask = this.modificationMask;
        clone.originalMask = this.originalMask;
        clone.modifiedClass = this.modifiedClass;
        clone.readerContext = this.readerContext;
        return clone;
    }

    public void releaseResources() {
        this.leftTuple = null;
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPointId entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    public int getOriginOffset() {
        return this.originOffset;
    }

    public void setOriginOffset(int originOffset) {
        this.originOffset = originOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInsertAction(WorkingMemoryAction action) {
        LinkedList<WorkingMemoryAction> linkedList = this.queue1;
        synchronized (linkedList) {
            this.queue1.addFirst(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInsertAction(WorkingMemoryAction action) {
        LinkedList<WorkingMemoryAction> linkedList = this.queue1;
        synchronized (linkedList) {
            this.queue1.remove(action);
        }
    }

    public LinkedList<WorkingMemoryAction> getQueue1() {
        return this.queue1;
    }

    public LinkedList<WorkingMemoryAction> getQueue2() {
        if (this.queue2 == null) {
            this.queue2 = new LinkedList();
        }
        return this.queue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateActionQueue(InternalWorkingMemory workingMemory) {
        boolean repeat = true;
        block3: while (repeat) {
            WorkingMemoryAction action;
            LinkedList<WorkingMemoryAction> linkedList = this.queue1;
            synchronized (linkedList) {
                WorkingMemoryAction action2;
                while ((action2 = !this.queue1.isEmpty() ? this.queue1.removeFirst() : null) != null) {
                    action2.execute(workingMemory);
                }
            }
            repeat = false;
            if (this.queue2 == null) continue;
            while ((action = !this.queue2.isEmpty() ? this.queue2.removeFirst() : null) != null) {
                action.execute(workingMemory);
                if (this.queue1.isEmpty()) continue;
                repeat = true;
                continue block3;
            }
        }
    }

    public BitMask getModificationMask() {
        return this.modificationMask;
    }

    public void setModificationMask(BitMask modificationMask) {
        this.modificationMask = modificationMask;
    }

    public PropagationContext adaptModificationMaskForObjectType(ObjectType type, InternalWorkingMemory workingMemory) {
        if (PropertySpecificUtil.isAllSetPropertyReactiveMask((BitMask)this.originalMask) || this.originalMask.isSet(0) || !(type instanceof ClassObjectType)) {
            return this;
        }
        ClassObjectType classObjectType = (ClassObjectType)type;
        BitMask cachedMask = classObjectType.getTransformedMask(this.modifiedClass, this.originalMask);
        if (cachedMask != null) {
            return this;
        }
        this.modificationMask = this.originalMask;
        boolean typeBit = this.modificationMask.isSet(0);
        this.modificationMask = this.modificationMask.reset(0);
        Class classType = classObjectType.getClassType();
        String pkgName = classType.getPackage().getName();
        if (classType == this.modifiedClass || "java.lang".equals(pkgName) || !classType.isInterface() && !this.modifiedClass.isInterface()) {
            if (typeBit) {
                this.modificationMask = this.modificationMask.set(0);
            }
            return this;
        }
        List<String> typeClassProps = this.getSettableProperties(workingMemory, classType, pkgName);
        List<String> modifiedClassProps = this.getSettableProperties(workingMemory, this.modifiedClass);
        this.modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)typeClassProps.size());
        for (int i = 0; i < modifiedClassProps.size(); ++i) {
            int posInType;
            if (!PropertySpecificUtil.isPropertySetOnMask((BitMask)this.originalMask, (int)i) || (posInType = typeClassProps.indexOf(modifiedClassProps.get(i))) < 0) continue;
            this.modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)this.modificationMask, (int)posInType);
        }
        if (typeBit) {
            this.modificationMask = this.modificationMask.set(0);
        }
        classObjectType.storeTransformedMask(this.modifiedClass, this.originalMask, this.modificationMask);
        return this;
    }

    private List<String> getSettableProperties(InternalWorkingMemory workingMemory, Class<?> classType) {
        return this.getSettableProperties(workingMemory, classType, classType.getPackage().getName());
    }

    private List<String> getSettableProperties(InternalWorkingMemory workingMemory, Class<?> classType, String pkgName) {
        if (pkgName.equals("java.lang") || pkgName.equals("java.util")) {
            return Collections.EMPTY_LIST;
        }
        InternalKnowledgePackage pkg = workingMemory.getKnowledgeBase().getPackage(pkgName);
        TypeDeclaration tdecl = pkg != null ? pkg.getTypeDeclaration(classType) : null;
        return tdecl != null ? tdecl.getSettableProperties() : Collections.EMPTY_LIST;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public MarshallerReaderContext getReaderContext() {
        return this.readerContext;
    }

    public static String intEnumToString(PropagationContext pctx) {
        Object pctxType = null;
        switch (pctx.getType()) {
            case 0: {
                return "INSERTION";
            }
            case 3: {
                return "RULE_ADDITION";
            }
            case 2: {
                return "MODIFICATION";
            }
            case 4: {
                return "RULE_REMOVAL";
            }
            case 1: {
                return "DELETION";
            }
            case 5: {
                return "EXPIRATION";
            }
        }
        throw new IllegalStateException("Int type unknown");
    }

    public String toString() {
        return "RetePropagationContext [entryPoint=" + this.entryPoint + ", factHandle=" + this.factHandle + ", leftTuple=" + this.leftTuple + ", originOffset=" + this.originOffset + ", propagationNumber=" + this.propagationNumber + ", rule=" + this.rule + ", type=" + this.type + "]";
    }
}

