/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.bitmask.BitMask;
import org.drools.reteoo.nodes.ReteBetaNodeUtils;

public class ReteJoinNode
extends JoinNode {
    public ReteJoinNode() {
    }

    public ReteJoinNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints binder, BuildContext context) {
        super(id, leftInput, rightInput, binder, context);
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        ReteBetaNodeUtils.assertObject((BetaNode)this, factHandle, pctx, wm);
    }

    public void attach(BuildContext context) {
        ReteBetaNodeUtils.attach((BetaNode)this, context);
    }

    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        return ReteBetaNodeUtils.doRemove((BetaNode)this, context, builder, workingMemories);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteBetaNodeUtils.modifyObject((BetaNode)this, factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple((InternalFactHandle)factHandle, (ModifyPreviousTuples)modifyPreviousTuples, (PropagationContext)context, (InternalWorkingMemory)workingMemory, (LeftTupleSink)this, (ObjectTypeNode.Id)this.getLeftInputOtnId(), (BitMask)this.getLeftInferredMask());
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        if (useLeftMemory) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        while (rightTuple != null) {
            this.propagateFromLeft(rightTuple, leftTuple, contextEntry, useLeftMemory, context, workingMemory);
            rightTuple = (RightTuple)it.next((Entry)rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
    }

    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, it);
        while (leftTuple != null) {
            this.propagateFromRight(rightTuple, leftTuple, memory, context, workingMemory);
            leftTuple = (LeftTuple)it.next((Entry)leftTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    protected void propagateFromRight(RightTuple rightTuple, LeftTuple leftTuple, BetaMemory memory, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
        }
    }

    protected void propagateFromLeft(RightTuple rightTuple, LeftTuple leftTuple, ContextEntry[] contextEntry, boolean useLeftMemory, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.constraints.isAllowedCachedLeft(contextEntry, handle)) {
            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, useLeftMemory);
        }
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory wm) {
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)this);
        memory.getRightTupleMemory().remove(rightTuple);
        this.sink.propagateRetractRightTuple(rightTuple, pctx, wm);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.getLeftTupleMemory().remove(leftTuple);
        if (leftTuple.getFirstChild() != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.getRightTupleMemory().removeAdd(rightTuple);
        if (memory.getLeftTupleMemory() != null && memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, it);
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    this.propagateFromRight(rightTuple, leftTuple, memory, context, workingMemory);
                    leftTuple = (LeftTuple)it.next((Entry)leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    childLeftTuple = this.propagateOrModifyFromRight(rightTuple, leftTuple, childLeftTuple, memory, context, workingMemory);
                    leftTuple = (LeftTuple)it.next((Entry)leftTuple);
                }
            }
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    protected LeftTuple propagateOrModifyFromRight(RightTuple rightTuple, LeftTuple leftTuple, LeftTuple childLeftTuple, BetaMemory memory, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
            if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, childLeftTuple, context, workingMemory, true);
            } else {
                childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory, true);
            }
        } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
            childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory);
        }
        return childLeftTuple;
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        ContextEntry[] contextEntry = memory.getContext();
        memory.getLeftTupleMemory().removeAdd(leftTuple);
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        LeftTuple childLeftTuple = leftTuple.getFirstChild();
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        if (childLeftTuple != null && rightMemory.isIndexed() && !it.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    this.propagateFromLeft(rightTuple, leftTuple, contextEntry, true, context, workingMemory);
                    rightTuple = (RightTuple)it.next((Entry)rightTuple);
                }
            } else {
                while (rightTuple != null) {
                    childLeftTuple = this.propagateOrModifyFromLeft(rightTuple, leftTuple, childLeftTuple, contextEntry, context, workingMemory);
                    rightTuple = (RightTuple)it.next((Entry)rightTuple);
                }
            }
        }
        this.constraints.resetTuple(contextEntry);
    }

    protected LeftTuple propagateOrModifyFromLeft(RightTuple rightTuple, LeftTuple leftTuple, LeftTuple childLeftTuple, ContextEntry[] contextEntry, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.constraints.isAllowedCachedLeft(contextEntry, handle)) {
            if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, childLeftTuple, null, context, workingMemory, true);
            } else {
                childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory, true);
            }
        } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
            childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory);
        }
        return childLeftTuple;
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        FastIterator it = memory.getLeftTupleMemory().fastIterator();
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle(), it);
            while (rightTuple != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) {
                    sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true), context, workingMemory);
                }
                rightTuple = (RightTuple)it.next((Entry)rightTuple);
            }
            this.constraints.resetTuple(memory.getContext());
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }
}

