/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.rule;

import java.io.PrintStream;
import java.util.List;
import org.drools.definition.rule.Rule;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.WorkingMemory;

public class ConsequenceException
extends RuntimeException {
    private WorkingMemory workingMemory;
    private Activation activation;

    public ConsequenceException(Throwable rootCause, WorkingMemory workingMemory, Activation activation) {
        super(rootCause);
        this.workingMemory = workingMemory;
        this.activation = activation;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Exception executing consequence for ");
        Rule rule = null;
        if (this.activation != null && (rule = this.activation.getRule()) != null) {
            String packageName = rule.getPackageName();
            String ruleName = rule.getName();
            sb.append("rule \"").append(ruleName).append("\" in ").append(packageName);
        } else {
            sb.append("rule, name unknown");
        }
        sb.append(": ").append(super.getMessage());
        return sb.toString();
    }

    public Activation getActivation() {
        return this.activation;
    }

    public Rule getRule() {
        return this.activation.getRule();
    }

    public void printFacts() {
        this.printFacts(System.err);
    }

    public void printFacts(PrintStream pStream) {
        List<? extends FactHandle> handles = this.activation.getFactHandles();
        for (FactHandle factHandle : handles) {
            Object object = this.workingMemory.getObject(factHandle);
            if (object == null) continue;
            pStream.println("   Fact " + object.getClass().getSimpleName() + ": " + object.toString());
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

