/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.performance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.io.ResourceFactory;

public class PerformanceExample {
    public static RuleEngineOption phreak = RuleEngineOption.PHREAK;

    public static void main(String[] args) throws Exception {
        FactType ft;
        StatelessKieSession kSession;
        long numberOfRulesToBuild = 10L;
        boolean useAccumulate = true;
        String dialect = "mvel";
        boolean usekjars = false;
        boolean collectionBasedRules = true;
        System.out.println("********* Numbers of rules: 10 kjars: " + usekjars + " accumulate: " + useAccumulate + " dialect: " + dialect + " *********");
        String rules = PerformanceExample.getRules(10L, useAccumulate, dialect, collectionBasedRules);
        long startTime = System.currentTimeMillis();
        if (usekjars) {
            KieContainer kContainer = PerformanceExample.loadContainerFromString(rules);
            kSession = kContainer.newStatelessKieSession();
            ft = kContainer.getKieBase().getFactType("org.drools.examples.performance", "TransactionC");
        } else {
            KnowledgeBase kbase = PerformanceExample.loadKnowledgeBaseFromString(rules);
            kSession = kbase.newStatelessKieSession();
            ft = kbase.getFactType("org.drools.examples.performance", "TransactionC");
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Total time to build and load knowledgebase: " + (endTime - startTime) + " ms");
        ArrayList output = new ArrayList();
        kSession.setGlobal("mo", output);
        Object o = ft.newInstance();
        Gson gConverter = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
        Object fo = gConverter.fromJson(PerformanceExample.getFact(), o.getClass());
        kSession.execute(fo);
        startTime = System.currentTimeMillis();
        kSession.execute(fo);
        endTime = System.currentTimeMillis();
        System.out.println("Execution time: " + (endTime - startTime) + " ms");
        String rulesOutput = gConverter.toJson(output);
        System.out.println(rulesOutput);
    }

    private static KieContainer loadContainerFromString(String rules) {
        long startTime = System.currentTimeMillis();
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/examples/pertest.drl", rules);
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time to build rules : " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        endTime = System.currentTimeMillis();
        System.out.println("Time to load container: " + (endTime - startTime) + " ms");
        return kContainer;
    }

    protected static KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        long startTime = System.currentTimeMillis();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Build Errors:\n" + kbuilder.getErrors());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time to build rules: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        KieBaseConfiguration kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kBaseConfig.setOption((KieBaseOption)phreak);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        endTime = System.currentTimeMillis();
        System.out.println("Time to create knowledgebase: " + (endTime - startTime) + " ms");
        return kbase;
    }

    private static String getFact() {
        return "{\n\"TransactionNumber\": \"88882\",\n\"TrackingID\": \"T001\",\n\"CurrencyCode\": \"USD\",\n\"TransactionNetTotal\" : 100.0,\n\"StoreCode\": \"D001\",\n\"CardNumber\": \"3614838386\",\n\"TransactionDetails\": [\n{\n\"Quantity\": 25,\n\"ItemNumber\": \"SKU1_0\",\n\"BrandID\": \"Nike\",\n\"SKU\": \"SKU1\",\n\"ProductCategoryCode\" : \"Clothing\"\n}]\n}";
    }

    private static String getRules(long numberofRules, boolean useAccumulate, String dialect, boolean collectionBasedRules) {
        long startTime = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder("package org.drools.examples.performance;\n");
        sb.append(PerformanceExample.getImportStatements());
        sb.append("global ArrayList<Outcome> mo;");
        sb.append(PerformanceExample.getDeclareStatements());
        for (long l = 0L; l < numberofRules; ++l) {
            sb.append(PerformanceExample.createRule(l, useAccumulate, dialect, collectionBasedRules));
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time to generate: " + (endTime - startTime) + " ms");
        return sb.toString();
    }

    private static String createRule(long number, boolean useAccumulate, String dialect, boolean collectionBasedRules) {
        if (collectionBasedRules) {
            return PerformanceExample.createCollectionRule(number, useAccumulate, dialect);
        }
        return PerformanceExample.createRule(number, useAccumulate, dialect);
    }

    private static String createRule(long number, boolean useAccumulate, String dialect) {
        String s = "rule \"rule" + number + "\" \n";
        if (!dialect.isEmpty()) {
            s = s + "dialect \"" + dialect + "\"\n";
        }
        s = s + "when   t : TransactionC(CurrencyCode == \"USD" + number + "\") \n";
        if (useAccumulate) {
            s = s + "accumulate($item:TransactionDetailsC() from t.TransactionDetails, $totQty: collectList($item.getQuantity()))\n";
        }
        s = s + "then \n" + "mo.add(new Outcome(\"rule" + number + "\", t.getTransactionNumber()));\n" + "end \n";
        return s;
    }

    private static String createCollectionRule(long number, boolean useAccumulate, String dialect) {
        long NumOfSKU = 10L;
        String sku = "";
        String prefix = "";
        for (long l = 0L; l < NumOfSKU; ++l) {
            sku = sku + prefix + "\"SKU" + number + "_" + l + "\"";
            prefix = ",";
        }
        String s = "rule \"rule" + number + "\" \n";
        if (!dialect.isEmpty()) {
            s = s + "dialect \"" + dialect + "\"\n";
        }
        s = s + "when   t : TransactionC() \n" + "d: TransactionDetailsC(ItemNumber in (" + sku + ")) from t.TransactionDetails \n";
        if (useAccumulate) {
            s = s + "accumulate($item:TransactionDetailsC(ItemNumber in (" + sku + ")) from t.TransactionDetails, $totQty: collectList($item.getQuantity()))\n";
        }
        s = s + "then \n" + "mo.add(new Outcome(\"rule" + number + "\", d.getBrandID()));\n" + "end \n";
        return s;
    }

    private static String createRules2(String dialect) {
        return "rule \"r1\"\ndialect \"" + dialect + "\"\n" + "when   t : TransactionC(CurrencyCode == \"USD\") \n" + "then \n" + "mo.add(new Outcome(\"r1\" , t.getTransactionNumber()));\n" + "end \n" + "rule \"r2\"\n" + "dialect \"" + dialect + "\"\n" + "when   t : TransactionC(CurrencyCode == \"USD\") \n" + "then \n" + "mo.add(new Outcome(\"r2\" , t.getTransactionNumber()));\n" + "end \n" + "rule \"r3\"\n" + "dialect \"" + dialect + "\"\n" + "when   t : TransactionC(CurrencyCode == \"CAD\") \n" + "then \n" + "mo.add(new Outcome(\"r3\", t.getTransactionNumber()));\n" + "end \n" + "rule \"r4\"\n" + "dialect \"" + dialect + "\"\n" + "when   t : TransactionC(CurrencyCode == \"USD\") \n" + "then \n" + "mo.add(new Outcome(\"r4\", t.getTransactionNumber()));\n" + "end \n";
    }

    private static String getDeclareStatements() {
        return "declare TransactionC \nCardNumber : String \nStoreCode : String \nTrackingID : String \nCurrencyCode : String \nTransactionNetTotal : Double \nTransactionNumber : String \nTransactionDetails : TransactionDetailsC[] \nend \ndeclare TransactionDetailsC \nItemNumber : String \nBrandID : String \nSKU : String \nProductCategoryCode : String \nQuantity : Double \nend\ndeclare Outcome \nRuleId : String \nOutcomeValue : String \nend \n";
    }

    private static String getImportStatements() {
        return "import java.util.ArrayList \nimport java.util.List \n";
    }
}

