/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.installer;

import java.io.File;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.MetadataBridge;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.SubArtifact;

@Component(role=ArtifactInstaller.class)
public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private LegacySupport legacySupport;

    @Override
    @Deprecated
    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.install(source, artifact, localRepository);
    }

    @Override
    public void install(File source, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        RepositorySystemSession session = LegacyLocalRepositoryManager.overlay(localRepository, this.legacySupport.getRepositorySession(), this.repoSystem);
        InstallRequest request = new InstallRequest();
        request.setTrace(RequestTrace.newChild(null, this.legacySupport.getSession().getCurrentProject()));
        org.eclipse.aether.artifact.Artifact mainArtifact = RepositoryUtils.toArtifact(artifact);
        mainArtifact = mainArtifact.setFile(source);
        request.addArtifact(mainArtifact);
        for (ArtifactMetadata metadata : artifact.getMetadataList()) {
            if (metadata instanceof ProjectArtifactMetadata) {
                org.eclipse.aether.artifact.Artifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                request.addArtifact(pomArtifact);
                continue;
            }
            if (metadata instanceof SnapshotArtifactRepositoryMetadata || metadata instanceof ArtifactRepositoryMetadata) continue;
            request.addMetadata(new MetadataBridge(metadata));
        }
        try {
            this.repoSystem.install(session, request);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallationException(e.getMessage(), e);
        }
        if (artifact.isSnapshot()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setLocalCopy(true);
            artifact.addMetadata(new SnapshotArtifactRepositoryMetadata(artifact, snapshot));
        }
        Versioning versioning = new Versioning();
        versioning.updateTimestamp();
        versioning.addVersion(artifact.getBaseVersion());
        if (artifact.isRelease()) {
            versioning.setRelease(artifact.getBaseVersion());
        }
        artifact.addMetadata(new ArtifactRepositoryMetadata(artifact, versioning));
    }
}

