/*
 * Decompiled with CFR 0.152.
 */
package javax.rules;

import java.util.Hashtable;
import java.util.Map;
import javax.rules.ConfigurationException;
import javax.rules.RuleServiceProvider;

public abstract class RuleServiceProviderManager {
    private static Map registrationMap = new Hashtable();

    private RuleServiceProviderManager() {
    }

    public static void registerRuleServiceProvider(String uri, Class providerClass) throws ConfigurationException {
        RuleServiceProviderManager.registerRuleServiceProvider(uri, providerClass, null);
    }

    public static void registerRuleServiceProvider(String uri, Class providerClass, ClassLoader classLoader) throws ConfigurationException {
        try {
            RuleServiceProvider rsp = (RuleServiceProvider)providerClass.newInstance();
            if (classLoader != null) {
                rsp.setClassLoader(classLoader);
            }
            registrationMap.put(uri, rsp);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not register driver: " + providerClass + " against URI: " + uri, e);
        }
    }

    public static void deregisterRuleServiceProvider(String uri) {
        registrationMap.remove(uri);
    }

    public static RuleServiceProvider getRuleServiceProvider(String uri) throws ConfigurationException {
        RuleServiceProvider rsp = (RuleServiceProvider)registrationMap.get(uri);
        if (rsp == null) {
            throw new ConfigurationException("No RuleServiceProvider registered against URI: " + uri);
        }
        return rsp;
    }
}

