/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.assembler;

import java.util.Map;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.bayes.assembler.BayesNetworkAssemblerError;
import org.drools.beliefs.bayes.assembler.BayesPackage;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.XmlBifParser;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.assembler.KieAssemblerService;
import org.kie.internal.builder.KnowledgeBuilder;

public class BayesAssemblerService
implements KieAssemblerService {
    public ResourceType getResourceType() {
        return ResourceType.BAYES;
    }

    public void addResource(KnowledgeBuilder kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        InternalKnowledgePackage kpkgs;
        Map rpkg;
        BayesPackage bpkg;
        JunctionTreeBuilder builder;
        BayesNetwork network;
        Bif bif = XmlBifParser.loadBif(resource, kbuilder.getErrors());
        if (bif == null) {
            return;
        }
        try {
            network = XmlBifParser.buildBayesNetwork(bif);
        }
        catch (Exception e) {
            kbuilder.getErrors().add((Object)new BayesNetworkAssemblerError(resource, "Unable to parse opening Stream:\n" + e.toString()));
            return;
        }
        try {
            builder = new JunctionTreeBuilder(network);
        }
        catch (Exception e) {
            kbuilder.getErrors().add((Object)new BayesNetworkAssemblerError(resource, "Unable to build Junction Tree:\n" + e.toString()));
            return;
        }
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        PackageRegistry pkgReg = kbuilderImpl.getPackageRegistry(network.getPackageName());
        if (pkgReg == null) {
            pkgReg = kbuilderImpl.newPackage(new PackageDescr(network.getPackageName()));
        }
        if ((bpkg = (BayesPackage)(rpkg = (kpkgs = pkgReg.getPackage()).getResourceTypePackages()).get(ResourceType.BAYES)) == null) {
            bpkg = new BayesPackage();
            rpkg.put(ResourceType.BAYES, bpkg);
        }
        bpkg.addJunctionTree(network.getName(), builder.build());
    }

    public Class getServiceInterface() {
        return KieAssemblerService.class;
    }
}

