/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.MVELDumper;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.QueryImpl;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.runtime.rule.Variable;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

public class QueryElementBuilder
implements RuleConditionBuilder {
    private static final QueryElementBuilder INSTANCE = new QueryElementBuilder();

    public static QueryElementBuilder getInstance() {
        return INSTANCE;
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, (Pattern)null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        throw new UnsupportedOperationException();
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern, QueryImpl query) {
        boolean addAbductiveReturnArgument;
        PatternDescr patternDescr = (PatternDescr)descr;
        Declaration[] params = query.getParameters();
        List<? extends BaseDescr> args = patternDescr.getDescrs();
        ArrayList<Integer> declrIndexes = new ArrayList<Integer>();
        ArrayList<Integer> varIndexes = new ArrayList<Integer>();
        ArrayList<Object> arguments = new ArrayList<Object>(params.length);
        for (int i = 0; i < params.length; ++i) {
            arguments.add(null);
        }
        ArrayList<Declaration> requiredDeclarations = new ArrayList<Declaration>();
        ClassObjectType argsObjectType = ClassObjectType.ObjectArray_ObjectType;
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class);
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)argsObjectType, null);
        if (!StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier())) {
            if (query.isAbductive()) {
                Declaration declr = context.getDeclarationResolver().getDeclaration((RuleImpl)query, patternDescr.getIdentifier());
                if (declr != null && !patternDescr.isUnification()) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Duplicate declaration " + patternDescr.getIdentifier() + ", unable to bind abducted value"));
                }
            } else {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query binding is not supported by non-abductive queries : " + patternDescr.getIdentifier()));
            }
        }
        boolean bl = addAbductiveReturnArgument = query.isAbductive() && !StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier()) && args.size() < params.length;
        if (addAbductiveReturnArgument) {
            ExprConstraintDescr extraDescr = new ExprConstraintDescr(patternDescr.getIdentifier());
            extraDescr.setPosition(patternDescr.getConstraint().getDescrs().size());
            extraDescr.setType(ExprConstraintDescr.Type.POSITIONAL);
            args.add(extraDescr);
        }
        for (BaseDescr baseDescr : args) {
            String expression = null;
            boolean isPositional = false;
            boolean isBinding = false;
            BindingDescr bind = null;
            ConstraintConnectiveDescr result = null;
            if (baseDescr instanceof BindingDescr) {
                bind = (BindingDescr)baseDescr;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
                isBinding = true;
            } else {
                if (baseDescr instanceof ExprConstraintDescr) {
                    ExprConstraintDescr ecd = (ExprConstraintDescr)baseDescr;
                    expression = ecd.getExpression();
                    isPositional = ecd.getType() == ExprConstraintDescr.Type.POSITIONAL;
                } else {
                    expression = baseDescr.getText();
                }
                result = this.parseExpression(context, patternDescr, expression);
                if (result == null) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parse constraint: \n" + expression));
                    continue;
                }
                boolean bl2 = isBinding = result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof BindingDescr;
                if (isBinding) {
                    bind = (BindingDescr)result.getDescrs().get(0);
                }
            }
            if (!isPositional && !isBinding) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query's must use positional or bindings, not field constraints:\n" + expression));
                continue;
            }
            if (isPositional && isBinding) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query's can't use positional bindings:\n" + expression));
                continue;
            }
            if (isPositional) {
                this.processPositional(context, query, params, declrIndexes, varIndexes, arguments, requiredDeclarations, (InternalReadAccessor)arrayReader, pattern, baseDescr, expression, result);
                continue;
            }
            this.processBinding(context, descr, params, declrIndexes, varIndexes, arguments, requiredDeclarations, (InternalReadAccessor)arrayReader, pattern, bind);
        }
        Declaration[] declrsArray = requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]);
        int[] nArray = new int[declrIndexes.size()];
        for (int i = 0; i < declrsArray.length; ++i) {
            nArray[i] = (Integer)declrIndexes.get(i);
        }
        int[] varIndexesArray = new int[varIndexes.size()];
        for (int i = 0; i < varIndexesArray.length; ++i) {
            varIndexesArray[i] = (Integer)varIndexes.get(i);
        }
        for (Integer declIndex : declrIndexes) {
            Class formal;
            Declaration knownInputArg = (Declaration)arguments.get(declIndex);
            Declaration formalArgument = query.getParameters()[declIndex];
            Class actual = knownInputArg.getDeclarationClass();
            if (ClassUtils.isTypeCompatibleWithArgumentType((Class)actual, (Class)(formal = formalArgument.getDeclarationClass())) || ClassUtils.isTypeCompatibleWithArgumentType((Class)formal, (Class)actual)) continue;
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Query is being invoked with known argument of type " + actual + " at position " + declIndex + ", but the expected query argument is of type " + formal));
        }
        return new QueryElement(pattern, query.getName(), arguments.toArray(new Object[arguments.size()]), declrsArray, nArray, varIndexesArray, !patternDescr.isQuery(), query.isAbductive());
    }

    private void processBinding(RuleBuildContext context, BaseDescr descr, Declaration[] params, List<Integer> declrIndexes, List<Integer> varIndexes, List<Object> arguments, List<Declaration> requiredDeclarations, InternalReadAccessor arrayReader, Pattern pattern, BindingDescr bind) {
        int pos;
        Declaration declr = context.getDeclarationResolver().getDeclaration(context.getRule(), bind.getVariable());
        if (declr != null && (pos = QueryElementBuilder.getPos(bind.getExpression(), params)) >= 0) {
            String slot = bind.getExpression();
            String var = bind.getVariable();
            bind.setVariable(slot);
            bind.setExpression(var);
        }
        if ((pos = QueryElementBuilder.getPos(bind.getVariable(), params)) >= 0) {
            declr = context.getDeclarationResolver().getDeclaration(context.getRule(), bind.getExpression());
            if (declr != null) {
                arguments.set(pos, declr);
                declrIndexes.add(pos);
                requiredDeclarations.add(declr);
            } else {
                DrlExprParser parser = new DrlExprParser(context.getConfiguration().getLanguageLevel());
                ConstraintConnectiveDescr bresult = parser.parse(bind.getExpression());
                if (parser.hasErrors()) {
                    for (DroolsParserException error : parser.getErrors()) {
                        context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
                    }
                    return;
                }
                MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
                String expr = context.getCompilerFactory().getExpressionProcessor().dump((BaseDescr)bresult, mvelCtx);
                try {
                    MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
                    ParserConfiguration conf = data.getParserConfiguration();
                    conf.setClassLoader(context.getKnowledgeBuilder().getRootClassLoader());
                    arguments.set(pos, MVELSafeHelper.getEvaluator().executeExpression((Object)MVEL.compileExpression((String)expr, (ParserContext)new ParserContext(conf))));
                }
                catch (Exception e) {
                    context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to compile expression:\n" + expr));
                }
            }
        } else {
            declr = pattern.addDeclaration(bind.getVariable());
            pos = QueryElementBuilder.getPos(bind.getExpression(), params);
            if (pos < 0) {
                context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "named argument does not exist:\n" + bind.getExpression()));
                return;
            }
            ArrayElementReader reader = new ArrayElementReader(arrayReader, pos, params[pos].getDeclarationClass());
            declr.setReadAccessor((InternalReadAccessor)reader);
            varIndexes.add(pos);
            arguments.set(pos, Variable.v);
        }
    }

    private void processPositional(RuleBuildContext context, QueryImpl query, Declaration[] params, List<Integer> declrIndexes, List<Integer> varIndexes, List<Object> arguments, List<Declaration> requiredDeclarations, InternalReadAccessor arrayReader, Pattern pattern, BaseDescr base, String expression, ConstraintConnectiveDescr result) {
        Declaration declr;
        int position = ((ExprConstraintDescr)base).getPosition();
        if (position >= arguments.size()) {
            context.addError(new DescrBuildError(context.getParentDescr(), base, null, "Unable to parse query '" + query.getName() + "', as postion " + position + " for expression '" + expression + "' does not exist on query size " + arguments.size()));
            return;
        }
        boolean isVariable = QueryElementBuilder.isVariable(expression);
        Declaration declaration = declr = isVariable ? context.getDeclarationResolver().getDeclaration((RuleImpl)query, expression) : null;
        if (declr != null) {
            arguments.set(position, declr);
            declrIndexes.add(position);
            requiredDeclarations.add(declr);
        } else if (isVariable && expression.indexOf(46) < 0) {
            arguments.set(position, Variable.v);
            varIndexes.add(position);
            declr = pattern.addDeclaration(expression);
            ArrayElementReader reader = new ArrayElementReader(arrayReader, position, params[position].getDeclarationClass());
            declr.setReadAccessor((InternalReadAccessor)reader);
        } else {
            MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
            String rewrittenExpr = context.getCompilerFactory().getExpressionProcessor().dump((BaseDescr)result, mvelCtx);
            try {
                MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
                ParserConfiguration conf = data.getParserConfiguration();
                conf.setClassLoader(context.getKnowledgeBuilder().getRootClassLoader());
                arguments.set(position, MVELSafeHelper.getEvaluator().executeExpression((Object)MVEL.compileExpression((String)rewrittenExpr, (ParserContext)new ParserContext(conf))));
            }
            catch (Exception e) {
                context.addError(new DescrBuildError(context.getParentDescr(), base, null, "Unable to compile expression:\n" + rewrittenExpr));
            }
        }
    }

    public static int getPos(String identifier, Declaration[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].getIdentifier().trim().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    private ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, String expression) {
        DrlExprParser parser = new DrlExprParser(context.getConfiguration().getLanguageLevel());
        ConstraintConnectiveDescr result = parser.parse(expression);
        if (result == null || parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return null;
        }
        return result;
    }

    public static boolean isVariable(String str) {
        if (!StringUtils.isDereferencingIdentifier((String)(str = str.trim()))) {
            return false;
        }
        return !str.endsWith(".class");
    }
}

