/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.Function;
import org.drools.core.rule.LineMappings;

public class DialectRuntimeRegistry
implements Externalizable {
    private Map<String, DialectRuntimeData> dialects = new HashMap<String, DialectRuntimeData>();
    private static final long serialVersionUID = 510L;
    private Map<String, LineMappings> lineMappings;

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.dialects);
        stream.writeObject(this.lineMappings);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.dialects = (Map)stream.readObject();
        this.lineMappings = (Map)stream.readObject();
    }

    public void onAdd(ClassLoader rootClassLoader) {
        for (DialectRuntimeData data : this.dialects.values()) {
            data.onAdd(this, rootClassLoader);
        }
    }

    public void onRemove() {
        for (DialectRuntimeData data : this.dialects.values()) {
            data.onRemove();
        }
    }

    public void setDialectData(String name, DialectRuntimeData data) {
        this.dialects.put(name, data);
    }

    public DialectRuntimeData getDialectData(String dialect) {
        return this.dialects.get(dialect);
    }

    public DialectRuntimeData removeRule(KnowledgePackageImpl pkg, RuleImpl rule) {
        DialectRuntimeData dialect = this.dialects.get(rule.getDialect());
        dialect.removeRule(pkg, rule);
        return dialect;
    }

    public DialectRuntimeData removeFunction(KnowledgePackageImpl pkg, Function function) {
        DialectRuntimeData dialect = this.dialects.get(function.getDialect());
        dialect.removeFunction(pkg, function);
        return dialect;
    }

    public void merge(DialectRuntimeRegistry newDatas, ClassLoader rootClassLoader) {
        this.merge(newDatas, rootClassLoader, false);
    }

    public void merge(DialectRuntimeRegistry newDatas, ClassLoader rootClassLoader, boolean excludeClasses) {
        for (Map.Entry<String, DialectRuntimeData> entry : newDatas.dialects.entrySet()) {
            DialectRuntimeData data = this.dialects.get(entry.getKey());
            if (data == null) {
                DialectRuntimeData dialectData = entry.getValue().clone(this, rootClassLoader, excludeClasses);
                this.dialects.put(entry.getKey(), dialectData);
                continue;
            }
            data.merge(this, entry.getValue(), excludeClasses);
        }
        this.getLineMappings().putAll(newDatas.getLineMappings());
    }

    public void onBeforeExecute() {
        DialectRuntimeData data = this.dialects.get("java");
        boolean isJavaDirty = false;
        if (data != null) {
            isJavaDirty = data.isDirty();
            data.onBeforeExecute();
        }
        for (Map.Entry<String, DialectRuntimeData> entry : this.dialects.entrySet()) {
            if ("java".equals(entry.getKey())) continue;
            data = entry.getValue();
            data.setDirty(isJavaDirty);
            data.onBeforeExecute();
        }
    }

    public void clear() {
        this.dialects.clear();
    }

    public LineMappings getLineMappings(String className) {
        return this.getLineMappings().get(className);
    }

    public Map<String, LineMappings> getLineMappings() {
        if (this.lineMappings == null) {
            this.lineMappings = new HashMap<String, LineMappings>();
        }
        return this.lineMappings;
    }
}

