/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.FileSettingsSource;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsSource;
import org.apache.maven.settings.building.StringSettingsSource;
import org.apache.maven.settings.building.UrlSettingsSource;
import org.kie.scanner.Aether;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.MavenRepositoryConfiguration;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSettings {
    private static final Logger log = LoggerFactory.getLogger(MavenSettings.class);
    public static final String CUSTOM_SETTINGS_PROPERTY = "kie.maven.settings.custom";

    public static void reinitSettings() {
        SettingsHolder.reinitSettings();
    }

    public static void reinitSettingsFromString(String settings) {
        SettingsHolder.reinitSettingsFromString(settings);
    }

    public static SettingsSource getUserSettingsSource() {
        return SettingsHolder.userSettingsSource;
    }

    public static Settings getSettings() {
        return SettingsHolder.settings;
    }

    public static MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
        return SettingsHolder.mavenConf;
    }

    private static Settings initSettings(SettingsSource userSettingsSource) {
        String mavenHome;
        DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        if (userSettingsSource != null) {
            request.setUserSettingsSource(userSettingsSource);
        }
        if ((mavenHome = System.getenv("M2_HOME")) != null) {
            File globalSettingsFile = new File(mavenHome + "/conf/settings.xml");
            if (globalSettingsFile.exists()) {
                request.setGlobalSettingsFile(globalSettingsFile);
            }
        } else {
            log.warn("Environment variable M2_HOME is not set");
        }
        request.setSystemProperties(System.getProperties());
        Settings settings = null;
        try {
            settings = settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
        if (settings.getLocalRepository() == null) {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                settings.setLocalRepository(userHome + "/.m2/repository");
            } else {
                log.error("Cannot find maven local repository");
            }
        }
        return settings;
    }

    private static SettingsSource initUserSettingsSource() {
        String userHome;
        String customSettings = System.getProperty(CUSTOM_SETTINGS_PROPERTY);
        if (customSettings != null) {
            File customSettingsFile = new File(customSettings);
            if (customSettingsFile.exists()) {
                return new FileSettingsSource(customSettingsFile);
            }
            try {
                return new UrlSettingsSource(new URL(customSettings));
            }
            catch (MalformedURLException malformedURLException) {
                log.warn("Cannot find custom maven settings: " + customSettings);
            }
        }
        if ((userHome = System.getProperty("user.home")) != null) {
            File userSettingsFile = new File(userHome + "/.m2/settings.xml");
            if (userSettingsFile.exists()) {
                return new FileSettingsSource(userSettingsFile);
            }
        } else {
            log.warn("User home is not set");
        }
        return null;
    }

    private static class SettingsHolder {
        private static SettingsSource userSettingsSource = MavenSettings.access$000();
        private static Settings settings = MavenSettings.access$100(userSettingsSource);
        private static MavenRepositoryConfiguration mavenConf = new MavenRepositoryConfiguration(settings);

        private SettingsHolder() {
        }

        private static void reinitSettings() {
            userSettingsSource = MavenSettings.initUserSettingsSource();
            SettingsHolder.internalInit();
        }

        private static void reinitSettingsFromString(String settings) {
            userSettingsSource = new StringSettingsSource((CharSequence)settings);
            SettingsHolder.internalInit();
        }

        private static void internalInit() {
            settings = MavenSettings.initSettings(SettingsHolder.userSettingsSource);
            mavenConf = new MavenRepositoryConfiguration(settings);
            Aether.instance = null;
            MavenProjectLoader.mavenProject = null;
            MavenRepository.defaultMavenRepository = null;
        }
    }
}

