/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NodeConnections;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class AbstractConfigurableNetwork<N, E>
extends AbstractNetwork<N, E> {
    private static final int DEFAULT_MAP_SIZE = 11;
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    protected final Map<N, NodeConnections<N, E>> nodeConnections;
    protected final Map<E, N> edgeToReferenceNode;

    AbstractConfigurableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        this(builder, Maps.newLinkedHashMapWithExpectedSize(builder.expectedNodeCount.or(11)), Maps.newLinkedHashMapWithExpectedSize(builder.expectedEdgeCount.or(11)));
    }

    AbstractConfigurableNetwork(NetworkBuilder<? super N, ? super E> builder, Map<N, NodeConnections<N, E>> nodeConnections, Map<E, N> edgeToReferenceNode) {
        this.isDirected = builder.directed;
        this.allowsParallelEdges = builder.allowsParallelEdges;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeConnections = Preconditions.checkNotNull(nodeConnections);
        this.edgeToReferenceNode = Preconditions.checkNotNull(edgeToReferenceNode);
    }

    @Override
    public Set<N> nodes() {
        return Collections.unmodifiableSet(this.nodeConnections.keySet());
    }

    @Override
    public Set<E> edges() {
        return Collections.unmodifiableSet(this.edgeToReferenceNode.keySet());
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public Set<E> incidentEdges(Object node) {
        return this.checkedConnections(node).incidentEdges();
    }

    @Override
    public Set<N> incidentNodes(Object edge) {
        N node1 = this.checkedReferenceNode(edge);
        N node2 = this.nodeConnections.get(node1).oppositeNode(edge);
        return ImmutableSet.of(node1, node2);
    }

    @Override
    public Set<N> adjacentNodes(Object node) {
        return this.checkedConnections(node).adjacentNodes();
    }

    @Override
    public Set<E> adjacentEdges(Object edge) {
        Iterator<N> incidentNodesIterator = this.incidentNodes(edge).iterator();
        Set<E> endpointsIncidentEdges = this.incidentEdges(incidentNodesIterator.next());
        while (incidentNodesIterator.hasNext()) {
            endpointsIncidentEdges = Sets.union(this.incidentEdges(incidentNodesIterator.next()), endpointsIncidentEdges);
        }
        return Sets.difference(endpointsIncidentEdges, ImmutableSet.of(edge));
    }

    @Override
    public Set<E> edgesConnecting(Object node1, Object node2) {
        NodeConnections<N, E> connectionsN1 = this.checkedConnections(node1);
        if (!this.allowsSelfLoops && node1.equals(node2)) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(node2), "Node %s is not an element of this graph", node2);
        return connectionsN1.edgesConnecting(node2);
    }

    @Override
    public Set<E> inEdges(Object node) {
        return this.checkedConnections(node).inEdges();
    }

    @Override
    public Set<E> outEdges(Object node) {
        return this.checkedConnections(node).outEdges();
    }

    @Override
    public Set<N> predecessors(Object node) {
        return this.checkedConnections(node).predecessors();
    }

    @Override
    public Set<N> successors(Object node) {
        return this.checkedConnections(node).successors();
    }

    @Override
    public N source(Object edge) {
        if (!this.isDirected) {
            throw new UnsupportedOperationException("Cannot call source()/target() on an undirected graph. Consider using incidentNodes() (if you don't know either incident node) or Graphs.oppositeNode() (if you know one of the incident nodes).");
        }
        return this.checkedReferenceNode(edge);
    }

    @Override
    public N target(Object edge) {
        N source = this.source(edge);
        return this.nodeConnections.get(source).oppositeNode(edge);
    }

    protected NodeConnections<N, E> checkedConnections(Object node) {
        Preconditions.checkNotNull(node, "node");
        NodeConnections<N, E> connections = this.nodeConnections.get(node);
        Preconditions.checkArgument(connections != null, "Node %s is not an element of this graph", node);
        return connections;
    }

    protected N checkedReferenceNode(Object edge) {
        Preconditions.checkNotNull(edge, "edge");
        N referenceNode = this.edgeToReferenceNode.get(edge);
        Preconditions.checkArgument(referenceNode != null, "Edge %s is not an element of this graph", edge);
        return referenceNode;
    }

    protected boolean containsNode(@Nullable Object node) {
        return this.nodeConnections.containsKey(node);
    }

    protected boolean containsEdge(@Nullable Object edge) {
        return this.edgeToReferenceNode.containsKey(edge);
    }
}

