/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.NodeAdjacencies;
import java.util.Collections;
import java.util.Set;

final class UndirectedNodeAdjacencies<N>
implements NodeAdjacencies<N> {
    private final Set<N> adjacentNodes;

    private UndirectedNodeAdjacencies(Set<N> adjacentNodes) {
        this.adjacentNodes = Preconditions.checkNotNull(adjacentNodes, "adjacentNodes");
    }

    static <N> UndirectedNodeAdjacencies<N> of() {
        return new UndirectedNodeAdjacencies(Sets.newHashSetWithExpectedSize(11));
    }

    static <N> UndirectedNodeAdjacencies<N> ofImmutable(Set<N> adjacentNodes) {
        return new UndirectedNodeAdjacencies<N>(ImmutableSet.copyOf(adjacentNodes));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodes);
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public void removePredecessor(Object node) {
        this.removeSuccessor(node);
    }

    @Override
    public void removeSuccessor(Object node) {
        Preconditions.checkNotNull(node, "node");
        this.adjacentNodes.remove(node);
    }

    @Override
    public void addPredecessor(N node) {
        this.addSuccessor(node);
    }

    @Override
    public void addSuccessor(N node) {
        Preconditions.checkNotNull(node, "node");
        this.adjacentNodes.add(node);
    }
}

