/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.ImplicitBindings;
import org.eclipse.sisu.inject.InjectorPublisher;
import org.eclipse.sisu.inject.LocatedBeans;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.MildConcurrentValues;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankedBindings;
import org.eclipse.sisu.inject.RankedSequence;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.inject.WatchedBeans;
import org.eclipse.sisu.inject.Weak;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<Long, RankedBindings> cachedBindings = Weak.concurrentValues(256, 8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = this.fetchBindings(type, null);
        if (bindings == null) {
            ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
            synchronized (concurrentMap) {
                bindings = this.cacheBindings(type, new RankedBindings(type, this.publishers));
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeArguments.isImplicit(type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    public synchronized void watch(Key key, Mediator mediator, Object watcher) {
        WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
        for (BindingPublisher p : this.publishers()) {
            p.subscribe(beans);
        }
        this.cachedWatchers.put(beans, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(BindingPublisher publisher, int rank) {
        if (this.publishers.contains(publisher)) {
            return false;
        }
        Logs.trace("Add publisher: {}", publisher, null);
        ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            this.publishers.insert(publisher, rank);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.add(publisher, rank);
            }
        }
        for (WatchedBeans beans : new ArrayList<WatchedBeans>(this.cachedWatchers.keySet())) {
            publisher.subscribe(beans);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(BindingPublisher publisher) {
        BindingPublisher oldPublisher;
        ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            block6: {
                oldPublisher = this.publishers.remove(publisher);
                if (oldPublisher != null) break block6;
                return false;
            }
            Logs.trace("Remove publisher: {}", oldPublisher, null);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.remove(oldPublisher);
            }
        }
        for (WatchedBeans beans : this.cachedWatchers.keySet()) {
            oldPublisher.unsubscribe(beans);
        }
        ((MildConcurrentValues)this.cachedBindings).compact();
        return true;
    }

    @Override
    public Iterable<BindingPublisher> publishers() {
        return this.publishers.snapshot();
    }

    @Override
    public synchronized void clear() {
        for (BindingPublisher p : this.publishers()) {
            this.remove(p);
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorPublisher(injector, new DefaultRankingFunction(rank)), rank);
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorPublisher(injector, null));
    }

    private RankedBindings fetchBindings(TypeLiteral type, Long[] idReturn) {
        RankedBindings result;
        int loaderHash = System.identityHashCode(type.getRawType().getClassLoader());
        long id = (long)type.hashCode() << 32 | 0xFFFFFFFFL & (long)loaderHash;
        while ((result = (RankedBindings)this.cachedBindings.get(id)) != null && !type.equals(result.type())) {
            ++id;
        }
        if (idReturn != null) {
            idReturn[0] = id;
        }
        return result;
    }

    private RankedBindings cacheBindings(TypeLiteral type, RankedBindings bindings) {
        Long[] idReturn = new Long[1];
        RankedBindings result = this.fetchBindings(type, idReturn);
        if (result == null) {
            result = bindings;
            this.cachedBindings.put(idReturn[0], result);
        }
        return result;
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        RankingFunction function = injector.getInstance(RankingFunction.class);
        locator.add(new InjectorPublisher(injector, function), function.maxRank());
    }
}

