/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorPublisher;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.launch.BundlePlan;
import org.osgi.framework.Bundle;

public class SisuBundlePlan
implements BundlePlan {
    protected final MutableBeanLocator locator;

    public SisuBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    public BindingPublisher prepare(Bundle bundle) {
        return this.appliesTo(bundle) ? new InjectorPublisher(this.inject(this.compose(bundle))) : null;
    }

    protected boolean appliesTo(Bundle bundle) {
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return imports != null && (imports.contains("javax.inject") || imports.contains("com.google.inject"));
    }

    protected Injector inject(Module module) {
        return Guice.createInjector(module);
    }

    protected Module compose(Bundle bundle) {
        return new BundleModule(bundle, this.locator);
    }
}

