/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractConfigurableGraph;
import com.google.common.graph.DirectedNodeAdjacencies;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.NodeAdjacencies;
import com.google.common.graph.UndirectedNodeAdjacencies;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;

class ConfigurableGraph<N>
extends AbstractConfigurableGraph<N>
implements MutableGraph<N> {
    ConfigurableGraph(GraphBuilder<? super N> builder) {
        super(builder);
    }

    ConfigurableGraph(GraphBuilder<? super N> builder, Map<N, NodeAdjacencies<N>> nodeConnections) {
        super(builder, nodeConnections);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, "node");
        if (this.containsNode(node)) {
            return false;
        }
        this.nodeConnections.put(node, this.newNodeConnections());
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(N node1, N node2) {
        Preconditions.checkNotNull(node1, "node1");
        Preconditions.checkNotNull(node2, "node2");
        Preconditions.checkArgument(this.allowsSelfLoops() || !node1.equals(node2), "Can't add self-loop edge on node %s, as self-loops are not allowed.", node1);
        boolean containsN1 = this.containsNode(node1);
        boolean containsN2 = this.containsNode(node2);
        if (containsN1 && containsN2 && ((NodeAdjacencies)this.nodeConnections.get(node1)).successors().contains(node2)) {
            return false;
        }
        if (!containsN1) {
            this.addNode(node1);
        }
        NodeAdjacencies connectionsN1 = (NodeAdjacencies)this.nodeConnections.get(node1);
        connectionsN1.addSuccessor(node2);
        if (!containsN2) {
            this.addNode(node2);
        }
        NodeAdjacencies connectionsN2 = (NodeAdjacencies)this.nodeConnections.get(node2);
        connectionsN2.addPredecessor(node1);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(Object node) {
        Preconditions.checkNotNull(node, "node");
        NodeAdjacencies connections = (NodeAdjacencies)this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        for (Object successor : connections.successors()) {
            if (node.equals(successor)) continue;
            ((NodeAdjacencies)this.nodeConnections.get(successor)).removePredecessor(node);
        }
        for (Object predecessor : connections.predecessors()) {
            ((NodeAdjacencies)this.nodeConnections.get(predecessor)).removeSuccessor(node);
        }
        this.nodeConnections.remove(node);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeEdge(Object node1, Object node2) {
        Preconditions.checkNotNull(node1, "node1");
        Preconditions.checkNotNull(node2, "node2");
        NodeAdjacencies connectionsN1 = (NodeAdjacencies)this.nodeConnections.get(node1);
        if (connectionsN1 == null || !connectionsN1.successors().contains(node2)) {
            return false;
        }
        NodeAdjacencies connectionsN2 = (NodeAdjacencies)this.nodeConnections.get(node2);
        connectionsN1.removeSuccessor(node2);
        connectionsN2.removePredecessor(node1);
        return true;
    }

    private NodeAdjacencies<N> newNodeConnections() {
        return this.isDirected() ? DirectedNodeAdjacencies.of() : UndirectedNodeAdjacencies.of();
    }
}

