/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.graph.AbstractDirectedNodeConnections;
import com.google.common.graph.SimpleEdgesConnecting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class DirectedNodeConnections<N, E>
extends AbstractDirectedNodeConnections<N, E> {
    protected DirectedNodeConnections(Map<E, N> inEdgeMap, Map<E, N> outEdgeMap) {
        super(inEdgeMap, outEdgeMap);
    }

    static <N, E> DirectedNodeConnections<N, E> of() {
        return new DirectedNodeConnections(HashBiMap.create(11), HashBiMap.create(11));
    }

    static <N, E> DirectedNodeConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges) {
        return new DirectedNodeConnections<N, E>(ImmutableBiMap.copyOf(inEdges), ImmutableBiMap.copyOf(outEdges));
    }

    @Override
    public Set<N> predecessors() {
        return Collections.unmodifiableSet(((BiMap)this.inEdgeMap).values());
    }

    @Override
    public Set<N> successors() {
        return Collections.unmodifiableSet(((BiMap)this.outEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(Object node) {
        return new SimpleEdgesConnecting(((BiMap)this.outEdgeMap).inverse(), node);
    }
}

