/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

final class SimpleEdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToEdgeMap;
    private final Object targetNode;

    SimpleEdgesConnecting(Map<?, E> nodeToEdgeMap, Object targetNode) {
        this.nodeToEdgeMap = Preconditions.checkNotNull(nodeToEdgeMap);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    public Iterator<E> iterator() {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(connectingEdge);
    }

    @Override
    public int size() {
        return this.getConnectingEdge() == null ? 0 : 1;
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && connectingEdge.equals(obj);
    }

    @Nullable
    private E getConnectingEdge() {
        return this.nodeToEdgeMap.get(this.targetNode);
    }
}

