/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.drools.core.util.IoUtils;
import org.drools.pmml.pmml_4_2.PMML4Compiler;
import org.drools.scorecards.ScorecardError;
import org.drools.scorecards.parser.AbstractScorecardParser;
import org.drools.scorecards.parser.ScorecardParseException;
import org.drools.scorecards.parser.xls.XLSScorecardParser;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScorecardCompiler {
    private PMML4Compiler compiler = new PMML4Compiler();
    private PMML pmmlDocument = null;
    public static final String DEFAULT_SHEET_NAME = "scorecards";
    private List<ScorecardError> scorecardErrors;
    private DrlType drlType;
    private static final Logger logger = LoggerFactory.getLogger(ScorecardCompiler.class);

    public ScorecardCompiler(DrlType drlType) {
        this.drlType = drlType;
    }

    public ScorecardCompiler() {
        this(DrlType.INTERNAL_DECLARED_TYPES);
    }

    public DrlType getDrlType() {
        return this.drlType;
    }

    public void setDrlType(DrlType drlType) {
        this.drlType = drlType;
    }

    protected void setPMMLDocument(PMML pmmlDocument) {
        this.pmmlDocument = pmmlDocument;
    }

    public boolean compileFromExcel(String pathToFile) {
        return this.compileFromExcel(pathToFile, DEFAULT_SHEET_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compileFromExcel(String pathToFile, String worksheetName) {
        FileInputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            inputStream = new FileInputStream(pathToFile);
            bufferedInputStream = new BufferedInputStream(inputStream);
            boolean bl = this.compileFromExcel(bufferedInputStream, worksheetName);
            this.closeStream(bufferedInputStream);
            this.closeStream(inputStream);
            return bl;
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                this.closeStream(bufferedInputStream);
                this.closeStream(inputStream);
            }
            catch (Throwable throwable) {
                this.closeStream(bufferedInputStream);
                this.closeStream(inputStream);
                throw throwable;
            }
        }
        return false;
    }

    public boolean compileFromExcel(InputStream stream) {
        return this.compileFromExcel(stream, DEFAULT_SHEET_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compileFromExcel(InputStream stream, String worksheetName) {
        try {
            XLSScorecardParser parser = new XLSScorecardParser();
            this.scorecardErrors = ((AbstractScorecardParser)parser).parseFile(stream, worksheetName);
            if (this.scorecardErrors.isEmpty()) {
                this.pmmlDocument = ((AbstractScorecardParser)parser).getPMMLDocument();
                boolean bl = true;
                return bl;
            }
        }
        catch (ScorecardParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeStream(stream);
        }
        return false;
    }

    public boolean compileFromPMML(InputStream stream) {
        this.pmmlDocument = this.compiler.loadModel(PMML.class.getPackage().getName(), stream);
        return this.pmmlDocument != null;
    }

    public PMML getPMMLDocument() {
        return this.pmmlDocument;
    }

    public String getPMML() {
        if (this.pmmlDocument == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PMML4Compiler.dumpModel((PMML)this.pmmlDocument, (OutputStream)baos);
        return new String(baos.toByteArray(), IoUtils.UTF8_CHARSET);
    }

    public String getDRL() {
        String drl = this.compiler.generateTheory(this.pmmlDocument);
        if (!this.compiler.getResults().isEmpty()) {
            for (KnowledgeBuilderResult res : this.compiler.getResults()) {
                logger.error(res.getMessage());
            }
            this.compiler.clearResults();
        }
        return drl;
    }

    public static String convertToDRL(PMML pmml, DrlType drlType) {
        if (pmml != null) {
            ScorecardCompiler scorecardCompiler = new ScorecardCompiler(drlType);
            scorecardCompiler.setPMMLDocument(pmml);
            return scorecardCompiler.getDRL();
        }
        return null;
    }

    public List<ScorecardError> getScorecardParseErrors() {
        return this.scorecardErrors;
    }

    private void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static enum DrlType {
        INTERNAL_DECLARED_TYPES,
        EXTERNAL_OBJECT_MODEL;

    }
}

