/*
 * Copyright 2010 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.core.event.knowlegebase.impl;

import org.kie.internal.KnowledgeBase;
import org.kie.api.definition.process.Process;
import org.kie.api.event.kiebase.AfterProcessAddedEvent;

public class AfterProcessAddedEventImpl extends KnowledgeBaseEventImpl implements AfterProcessAddedEvent {
    private Process process;
    
    public AfterProcessAddedEventImpl(KnowledgeBase knowledgeBase, Process process) {
        super( knowledgeBase );
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public String toString() {
        return "==>[AfterProcessAddedEventImpl: getProcess()=" + getProcess() + "]";
    }
    
}
